/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.front.model.DocumentationContent;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.AsciidoctorService;
import org.talend.sdk.component.server.service.LocaleMapper;

@Tag(name="Documentation", description="Endpoint to retrieve embedded component documentation.")
@Path(value="documentation")
@ApplicationScoped
public class DocumentationResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentationResource.class);
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentManager manager;
    @Inject
    private AsciidoctorService adoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="component/{id}")
    @Produces(value={"application/json"})
    @Operation(description="Returns an asciidoctor version of the documentation for the component represented by its identifier `id`. Format can be either asciidoc or html - if not it will fallback on asciidoc - and if html is selected you get a partial document. IMPORTANT: it is recommended to use asciidoc format and handle the conversion on your side if you can, the html flavor handles a limited set of the asciidoc syntax only like plain arrays, paragraph and titles. The documentation will likely be the family documentation but you can use anchors to access a particular component (_componentname_inlowercase).")
    @APIResponse(responseCode="200", description="the list of available and storable configurations (datastore, dataset, ...).", content={@Content(mediaType="application/json")})
    public DocumentationContent getDocumentation(@PathParam(value="id") @Parameter(name="id", description="the component identifier", in=ParameterIn.PATH) String id, @QueryParam(value="language") @DefaultValue(value="en") @Parameter(name="language", description="the language for display names.", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="en")) String language, @QueryParam(value="format") @DefaultValue(value="asciidoc") @Parameter(name="format", description="the expected format (asciidoc or html).", in=ParameterIn.QUERY, schema=@Schema(type=SchemaType.STRING, defaultValue="asciidoc")) String format) {
        Locale locale = this.localeMapper.mapLocale(language);
        Container container = Optional.ofNullable(this.componentDao.findById(id)).map(meta -> (Container)this.manager.findPlugin(meta.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "'")).build()))).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
        DocumentationCache cache = (DocumentationCache)container.get(DocumentationCache.class);
        if (cache == null) {
            Container container2 = container;
            synchronized (container2) {
                cache = (DocumentationCache)container.get(DocumentationCache.class);
                if (cache == null) {
                    cache = new DocumentationCache();
                    container.set(DocumentationCache.class, (Object)cache);
                }
            }
        }
        return cache.documentations.computeIfAbsent(new DocKey(id, language, format), key -> {
            String content = Stream.of("documentation_" + locale.getLanguage() + ".adoc", "documentation_" + language + ".adoc", "documentation.adoc").map(name -> container.getLoader().getResource("TALEND-INF/" + name)).filter(Objects::nonNull).findFirst().map(url -> {
                try (BufferedReader stream = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    String string = stream.lines().collect(Collectors.joining("\n"));
                    return string;
                }
                catch (IOException e) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).build());
                }
            }).map(value -> {
                switch (format) {
                    case "html": 
                    case "html5": {
                        return this.adoc.toHtml((String)value);
                    }
                }
                return value;
            }).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
            return new DocumentationContent(format, content);
        });
    }

    private static class DocumentationCache {
        private final ConcurrentMap<DocKey, DocumentationContent> documentations = new ConcurrentHashMap<DocKey, DocumentationContent>();

        private DocumentationCache() {
        }
    }

    private static class DocKey {
        private final String id;
        private final String language;
        private final String format;

        public DocKey(String id, String language, String format) {
            this.id = id;
            this.language = language;
            this.format = format;
        }

        public String getId() {
            return this.id;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocKey)) {
                return false;
            }
            DocKey other = (DocKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DocKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }

        public String toString() {
            return "DocumentationResource.DocKey(id=" + this.getId() + ", language=" + this.getLanguage() + ", format=" + this.getFormat() + ")";
        }
    }
}

