/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.front.model.execution.PrimitiveWrapper;
import org.talend.sdk.component.server.front.model.execution.WriteStatistics;

@Path(value="execution")
@ApplicationScoped
@Consumes(value={"application/json"})
public class ExecutionResource {
    private static final Logger log = LoggerFactory.getLogger(ExecutionResource.class);
    private static final int MAX_RECORDS = 1000;
    private static final byte[] EOL = "\n".getBytes(StandardCharsets.UTF_8);
    @Inject
    private ExecutorService executorService;
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentServerConfiguration appConfiguration;
    private Jsonb inlineStreamingMapper;
    private OutputFactory mockOutputFactory = name -> value -> {};

    @PostConstruct
    private void init() {
        this.inlineStreamingMapper = JsonbBuilder.create();
    }

    @PreDestroy
    private void destroy() {
        try {
            this.inlineStreamingMapper.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    @POST
    @Deprecated
    @Produces(value={"talend/stream"})
    @Path(value="read/{family}/{component}")
    public void read(@Suspended AsyncResponse response, @Context Providers providers, @PathParam(value="family") String family, @PathParam(value="component") String component, @QueryParam(value="size") @DefaultValue(value="50") long size, Map<String, String> configuration) {
        long maxSize = Math.min(size, 1000L);
        response.setTimeoutHandler(asyncResponse -> log.warn("Timeout on dataset retrieval"));
        response.setTimeout(this.appConfiguration.getDatasetRetrieverTimeout().longValue(), TimeUnit.SECONDS);
        this.executorService.submit(() -> {
            Optional mapperOptional = this.manager.findMapper(family, component, this.getConfigComponentVersion(configuration), configuration);
            if (!mapperOptional.isPresent()) {
                response.resume((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find the input component")).build()));
                return;
            }
            Mapper mapper = (Mapper)mapperOptional.get();
            mapper.start();
            try {
                Input input = mapper.create();
                try {
                    input.start();
                    response.resume(output -> {
                        Object data;
                        int current = 0;
                        while ((long)current++ < maxSize && (data = input.next()) != null) {
                            if (CharSequence.class.isInstance(data) || Number.class.isInstance(data) || Boolean.class.isInstance(data)) {
                                PrimitiveWrapper wrapper = new PrimitiveWrapper();
                                wrapper.setValue(data);
                                data = wrapper;
                            }
                            this.inlineStreamingMapper.toJson(data, output);
                            output.write(EOL);
                        }
                    });
                }
                finally {
                    input.stop();
                }
            }
            finally {
                mapper.stop();
            }
        });
    }

    @POST
    @Deprecated
    @Consumes(value={"talend/stream"})
    @Produces(value={"application/json"})
    @Path(value="write/{family}/{component}")
    public void write(@Suspended AsyncResponse response, @Context Providers providers, @PathParam(value="family") String family, @PathParam(value="component") String component, @QueryParam(value="group-size") @DefaultValue(value="50") long chunkSize, InputStream stream) {
        response.setTimeoutHandler(asyncResponse -> log.warn("Timeout on dataset retrieval"));
        response.setTimeout(this.appConfiguration.getDatasetRetrieverTimeout().longValue(), TimeUnit.SECONDS);
        this.executorService.submit(() -> {
            Processor processor = null;
            WriteStatistics statistics = new WriteStatistics(0);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                if (line == null || line.trim().isEmpty()) {
                    response.resume((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_ERROR, "No configuration sent")).build()));
                    return;
                }
                JsonObject configuration = (JsonObject)this.inlineStreamingMapper.fromJson(line, JsonObject.class);
                Map<String, String> config = this.convertConfig(configuration);
                Optional processorOptional = this.manager.findProcessor(family, component, this.getConfigComponentVersion(config), config);
                if (!processorOptional.isPresent()) {
                    response.resume((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find the output component")).build()));
                    return;
                }
                processor = (Processor)processorOptional.get();
                processor.start();
                int groupCount = 0;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    JsonObject object = (JsonObject)this.inlineStreamingMapper.fromJson(line, JsonObject.class);
                    if (groupCount == 0) {
                        processor.beforeGroup();
                    }
                    processor.onNext(name -> {
                        if (!"__default__".equals(name)) {
                            throw new IllegalArgumentException("Can't access branch '" + name + "' from component " + family + "#" + name);
                        }
                        return this.inlineStreamingMapper.fromJson(this.inlineStreamingMapper.toJson((Object)object), JsonObject.class);
                    }, this.mockOutputFactory);
                    statistics.setCount(statistics.getCount() + 1);
                    if ((long)(++groupCount) != chunkSize) continue;
                    processor.afterGroup(this.mockOutputFactory);
                }
            }
            catch (Exception e) {
                response.resume((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.ACTION_ERROR, "Didn't find the input component")).build()));
            }
            finally {
                Optional.ofNullable(processor).ifPresent(Lifecycle::stop);
            }
            response.resume((Object)statistics);
        });
    }

    private Map<String, String> convertConfig(JsonObject configuration) {
        return configuration.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            switch (((JsonValue)e.getValue()).getValueType()) {
                case TRUE: {
                    return "true";
                }
                case FALSE: {
                    return "false";
                }
                case NUMBER: {
                    return ((JsonNumber)JsonNumber.class.cast(e.getValue())).toString();
                }
                case STRING: {
                    return ((JsonString)JsonString.class.cast(e.getValue())).getString();
                }
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorPayload(ErrorDictionary.BAD_FORMAT, "Unsupported parameter " + (String)e.getKey() + "=" + e.getValue())).build());
        }));
    }

    private int getConfigComponentVersion(Map<String, String> config) {
        return Integer.parseInt(config.getOrDefault("tcomp::version", config.getOrDefault("__version", "1")));
    }
}

