/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import brave.http.HttpTracing;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

@ApplicationScoped
public class PoolProducer {
    @Produces
    @ApplicationScoped
    public ExecutorService executorService(ComponentServerConfiguration configuration, HttpTracing tracing) {
        return tracing.tracing().currentTraceContext().executorService(Executors.newFixedThreadPool(configuration.getExecutionPoolSize(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("talend-component-server-%d").daemon(false).build()));
    }

    public void release(@Disposes ExecutorService executorService, ComponentServerConfiguration configuration) {
        long timeout = Duration.parse(configuration.getExecutionPoolShutdownTimeout()).toMillis();
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

