/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class GlobService {
    public Stream<Path> toFiles(String path) {
        if (path.endsWith("*") || path.endsWith("*.properties")) {
            String filePrefix;
            String folder;
            String prefix = path.substring(0, path.lastIndexOf(42));
            int lastSlash = prefix.replace(File.separatorChar, '/').lastIndexOf(47);
            if (lastSlash > 0) {
                folder = prefix.substring(0, lastSlash);
                filePrefix = prefix.substring(lastSlash + 1);
            } else {
                folder = prefix;
                filePrefix = "";
            }
            return Stream.of(Paths.get(folder, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(it -> {
                try {
                    return Files.list(it).filter(file -> {
                        String name = file.getFileName().toString();
                        return name.startsWith(filePrefix) && name.endsWith(".properties");
                    });
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
        }
        return Stream.of(Paths.get(path, new String[0]));
    }
}

