/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.dependencies.maven;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.dependencies.maven.Artifact;

public class MvnCoordinateToFileConverter {
    private static final Logger log = LoggerFactory.getLogger(MvnCoordinateToFileConverter.class);

    public Artifact toArtifact(String coordinates) {
        String[] segments;
        String trim = coordinates.trim().replaceAll(" -- module.*", "");
        if (trim.isEmpty()) {
            return null;
        }
        int endOfTreePrefix = Math.max(trim.indexOf("\u2500 "), trim.indexOf("- "));
        if (endOfTreePrefix > 0) {
            trim = trim.substring(endOfTreePrefix + "\u2500 ".length());
        }
        if ((segments = trim.split(":")).length < 3) {
            throw new IllegalArgumentException("Invalid coordinate: " + trim);
        }
        switch (segments.length) {
            case 3: {
                segments = new String[]{segments[0], segments[1], "jar", segments[2], "compile"};
                break;
            }
            case 4: {
                segments = (trim + ":compile").split(":");
                break;
            }
        }
        int classifierOffset = segments.length == 5 ? 0 : 1;
        return new Artifact(segments[0], segments[1], segments[2], classifierOffset == 0 ? null : segments[3], segments[3 + classifierOffset], segments[4 + classifierOffset]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MvnCoordinateToFileConverter)) {
            return false;
        }
        MvnCoordinateToFileConverter other = (MvnCoordinateToFileConverter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MvnCoordinateToFileConverter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MvnCoordinateToFileConverter()";
    }
}

