/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.dependencies.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.dependencies.Resolver;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnCoordinateToFileConverter;
import org.talend.sdk.component.path.PathFactory;

public class MvnDependencyListLocalRepositoryResolver
implements Resolver {
    private static final Logger log = LoggerFactory.getLogger(MvnDependencyListLocalRepositoryResolver.class);
    private static final Artifact[] NO_ARTIFACT = new Artifact[0];
    private final MvnCoordinateToFileConverter coordinateConverter = new MvnCoordinateToFileConverter();
    private final String dependenciesListFile;
    private final Function<String, Path> artifactMapper;

    @Override
    public Stream<Artifact> resolve(ClassLoader rootLoader, String artifact) {
        return Stream.of(this.readDependencies(Optional.ofNullable(this.getJar(artifact)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(this::findDependenciesFile).orElseGet(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        })));
    }

    private Path getJar(String artifact) {
        return Optional.of(PathFactory.get(artifact)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).orElseGet(() -> this.artifactMapper.apply(artifact));
    }

    public Stream<Artifact> resolveFromDescriptor(InputStream descriptor) throws IOException {
        return Stream.of(this.readDependencies(this.slurp(descriptor)));
    }

    private Artifact[] readDependencies(String content) {
        return content.isEmpty() ? NO_ARTIFACT : new MvnDependenciesTxtArtifactConverter(this.coordinateConverter).withContent(content).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findDependenciesFile(Path module) {
        if (module.getFileName().toString().endsWith(".jar")) {
            try (JarFile jar = new JarFile(module.toFile());){
                ZipEntry entry = jar.getEntry(this.dependenciesListFile);
                if (entry != null) {
                    String string = this.slurp(jar.getInputStream(entry));
                    return string;
                }
                String string = "";
                return string;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!Files.isDirectory(module, new LinkOption[0])) throw new IllegalArgumentException("Unsupported module " + module);
        Path file = module.resolve(this.dependenciesListFile);
        if (!Files.exists(file, new LinkOption[0])) return "";
        try {
            return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String slurp(InputStream in) throws IOException {
        try (BufferedReader stream = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = stream.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public MvnDependencyListLocalRepositoryResolver(String dependenciesListFile, Function<String, Path> artifactMapper) {
        this.dependenciesListFile = dependenciesListFile;
        this.artifactMapper = artifactMapper;
    }

    public MvnCoordinateToFileConverter getCoordinateConverter() {
        return this.coordinateConverter;
    }

    public String getDependenciesListFile() {
        return this.dependenciesListFile;
    }

    public Function<String, Path> getArtifactMapper() {
        return this.artifactMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MvnDependencyListLocalRepositoryResolver)) {
            return false;
        }
        MvnDependencyListLocalRepositoryResolver other = (MvnDependencyListLocalRepositoryResolver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MvnCoordinateToFileConverter this$coordinateConverter = this.getCoordinateConverter();
        MvnCoordinateToFileConverter other$coordinateConverter = other.getCoordinateConverter();
        if (this$coordinateConverter == null ? other$coordinateConverter != null : !((Object)this$coordinateConverter).equals(other$coordinateConverter)) {
            return false;
        }
        String this$dependenciesListFile = this.getDependenciesListFile();
        String other$dependenciesListFile = other.getDependenciesListFile();
        if (this$dependenciesListFile == null ? other$dependenciesListFile != null : !this$dependenciesListFile.equals(other$dependenciesListFile)) {
            return false;
        }
        Function<String, Path> this$artifactMapper = this.getArtifactMapper();
        Function<String, Path> other$artifactMapper = other.getArtifactMapper();
        return !(this$artifactMapper == null ? other$artifactMapper != null : !this$artifactMapper.equals(other$artifactMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MvnDependencyListLocalRepositoryResolver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MvnCoordinateToFileConverter $coordinateConverter = this.getCoordinateConverter();
        result = result * 59 + ($coordinateConverter == null ? 43 : ((Object)$coordinateConverter).hashCode());
        String $dependenciesListFile = this.getDependenciesListFile();
        result = result * 59 + ($dependenciesListFile == null ? 43 : $dependenciesListFile.hashCode());
        Function<String, Path> $artifactMapper = this.getArtifactMapper();
        result = result * 59 + ($artifactMapper == null ? 43 : $artifactMapper.hashCode());
        return result;
    }

    public String toString() {
        return "MvnDependencyListLocalRepositoryResolver(coordinateConverter=" + this.getCoordinateConverter() + ", dependenciesListFile=" + this.getDependenciesListFile() + ", artifactMapper=" + this.getArtifactMapper() + ")";
    }

    private /* synthetic */ String lambda$null$3(InputStream s) {
        try {
            return this.slurp(s);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static /* synthetic */ boolean lambda$null$2(String name) {
        return true;
    }

    private static /* synthetic */ boolean lambda$null$1(String name) {
        return true;
    }

    private static class DefaultFilter
    implements Predicate<Artifact> {
        static final Predicate<Artifact> INSTANCE = new DefaultFilter();
        private static final Collection<String> ACCEPTED_SCOPES = new HashSet<String>(Arrays.asList("compile", "runtime"));
        private static final Collection<String> ACCEPTED_TYPES = new HashSet<String>(Arrays.asList("jar", "bundle", "zip"));

        private DefaultFilter() {
        }

        @Override
        public boolean test(Artifact artifact) {
            return ACCEPTED_SCOPES.contains(artifact.getScope()) && ACCEPTED_TYPES.contains(artifact.getType());
        }
    }

    public static class MvnDependenciesTxtArtifactConverter {
        private static final Artifact[] EMPTY_ARTIFACTS = new Artifact[0];
        private String content;
        private Predicate<Artifact> filter = DefaultFilter.INSTANCE;
        private final MvnCoordinateToFileConverter coordinateConverter;

        public MvnDependenciesTxtArtifactConverter withContent(String content) {
            this.content = content;
            return this;
        }

        public MvnDependenciesTxtArtifactConverter withFilter(Predicate<Artifact> filter) {
            this.filter = filter;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Artifact[] build() {
            if (this.content == null) {
                throw new IllegalArgumentException("No stream passed");
            }
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            try (BufferedReader reader = new BufferedReader(new StringReader(this.content));){
                boolean started = false;
                while (true) {
                    Artifact artifact;
                    String line;
                    if ((line = reader.readLine()) == null) {
                        Artifact[] artifactArray = artifacts.toArray(EMPTY_ARTIFACTS);
                        return artifactArray;
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    if (!started) {
                        if ("The following files have been resolved:".equals(line)) {
                            started = true;
                            continue;
                        }
                        if (line.split(":").length < 3) continue;
                        started = true;
                    }
                    if (!this.filter.test(artifact = this.coordinateConverter.toArtifact(line))) continue;
                    artifacts.add(artifact);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public MvnDependenciesTxtArtifactConverter(MvnCoordinateToFileConverter coordinateConverter) {
            this.coordinateConverter = coordinateConverter;
        }
    }
}

