/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;

public class Jars {
    public static String decode(String fileName) {
        if (fileName.indexOf(37) == -1) {
            return fileName;
        }
        StringBuilder result = new StringBuilder(fileName.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= fileName.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(fileName.charAt(i + 1), 16);
                    int d2 = Character.digit(fileName.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static Path toPath(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    return null;
                }
                return Jars.toPath(new URL(spec.substring(0, separator + 1)));
            }
            catch (MalformedURLException spec) {}
        } else if ("file".equals(url.getProtocol())) {
            String path = Jars.decode(url.getFile());
            if (path.endsWith("!")) {
                path = path.substring(0, path.length() - 1);
            }
            return new File(path).getAbsoluteFile().toPath();
        }
        return null;
    }

    private Jars() {
    }
}

