/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.core.Application;
import org.apache.cxf.cdi.CXFCdiServlet;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.logging.tomcat.LogFacade;

public class CxfCdiAutoSetup
implements ServletContainerInitializer {
    private static final String NAME = "cxf-cdi";

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        final Configuration builder = (Configuration)Configuration.class.cast(ctx.getAttribute("meecrowave.configuration"));
        final MeecrowaveCXFCdiServlet delegate = new MeecrowaveCXFCdiServlet();
        FilterRegistration.Dynamic jaxrs = ctx.addFilter(NAME, new Filter(){
            private final String servletPath;
            {
                this.servletPath = builder.getJaxrsMapping().endsWith("/*") ? builder.getJaxrsMapping().substring(0, builder.getJaxrsMapping().length() - 2) : builder.getJaxrsMapping();
            }

            public void init(final FilterConfig filterConfig) throws ServletException {
                delegate.init(new ServletConfig(){

                    public String getServletName() {
                        return CxfCdiAutoSetup.NAME;
                    }

                    public ServletContext getServletContext() {
                        return filterConfig.getServletContext();
                    }

                    public String getInitParameter(String name) {
                        return filterConfig.getInitParameter(name);
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return filterConfig.getInitParameterNames();
                    }
                });
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                if (!HttpServletRequest.class.isInstance(request)) {
                    chain.doFilter(request, response);
                    return;
                }
                HttpServletRequest http = (HttpServletRequest)HttpServletRequest.class.cast(request);
                final String path = http.getRequestURI().substring(http.getContextPath().length());
                Optional<String> app = Stream.of(delegate.prefixes).filter(path::startsWith).findAny();
                if (app.isPresent()) {
                    delegate.service((ServletRequest)new HttpServletRequestWrapper(http){

                        public String getPathInfo() {
                            return path;
                        }

                        public String getServletPath() {
                            return servletPath;
                        }
                    }, response);
                } else {
                    chain.doFilter(request, response);
                }
            }

            public void destroy() {
                delegate.destroy();
            }
        });
        jaxrs.setAsyncSupported(true);
        jaxrs.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC), true, new String[]{builder.getJaxrsMapping()});
        Optional.ofNullable(builder.getCxfServletParams()).ifPresent(m -> m.forEach((arg_0, arg_1) -> ((FilterRegistration.Dynamic)jaxrs).setInitParameter(arg_0, arg_1)));
    }

    private static String uproxyName(String clazz) {
        if (clazz.contains("$$")) {
            return clazz.substring(0, clazz.indexOf("$$"));
        }
        return clazz;
    }

    private static class MeecrowaveCXFCdiServlet
    extends CXFCdiServlet {
        private String[] prefixes;

        private MeecrowaveCXFCdiServlet() {
        }

        public void init(ServletConfig sc) throws ServletException {
            super.init(sc);
            LogFacade log = new LogFacade(CxfCdiAutoSetup.class.getName());
            String transportId = sc.getInitParameter("transportId");
            DestinationRegistry registry = this.getDestinationRegistryFromBusOrDefault(transportId);
            this.prefixes = (String[])registry.getDestinations().stream().filter(ServletDestination.class::isInstance).map(ServletDestination.class::cast).map(this.getServletDestinationPath(sc, log)).filter(Objects::nonNull).toArray(String[]::new);
        }

        private Function<ServletDestination, String> getServletDestinationPath(ServletConfig sc, LogFacade log) {
            return sd -> {
                Endpoint endpoint = ((ChainInitiationObserver)ChainInitiationObserver.class.cast(sd.getMessageObserver())).getEndpoint();
                ApplicationInfo app = (ApplicationInfo)ApplicationInfo.class.cast(endpoint.get((Object)Application.class.getName()));
                JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)JAXRSServiceFactoryBean.class.cast(endpoint.get((Object)JAXRSServiceFactoryBean.class.getName()));
                String base = sd.getEndpointInfo().getAddress();
                if (sfb != null) {
                    ArrayList<Logs.LogResourceEndpointInfo> resourcesToLog = new ArrayList<Logs.LogResourceEndpointInfo>();
                    int classSize = 0;
                    int addressSize = 0;
                    List resources = sfb.getClassResourceInfo();
                    for (ClassResourceInfo info : resources) {
                        if (info.getResourceClass() == null) continue;
                        String address = Logs.singleSlash(base, info.getURITemplate().getValue());
                        String clazz = CxfCdiAutoSetup.uproxyName(info.getResourceClass().getName());
                        classSize = Math.max(classSize, clazz.length());
                        addressSize = Math.max(addressSize, address.length());
                        int methodSize = 7;
                        int methodStrSize = 0;
                        ArrayList<Logs.LogOperationEndpointInfo> toLog = new ArrayList<Logs.LogOperationEndpointInfo>();
                        MethodDispatcher md = info.getMethodDispatcher();
                        for (OperationResourceInfo ori : md.getOperationResourceInfos()) {
                            String httpMethod = ori.getHttpMethod();
                            String currentAddress = Logs.singleSlash(address, ori.getURITemplate().getValue());
                            String methodToStr = Logs.toSimpleString(ori.getMethodToInvoke());
                            toLog.add(new Logs.LogOperationEndpointInfo(httpMethod, currentAddress, methodToStr));
                            if (httpMethod != null) {
                                methodSize = Math.max(methodSize, httpMethod.length());
                            }
                            addressSize = Math.max(addressSize, currentAddress.length());
                            methodStrSize = Math.max(methodStrSize, methodToStr.length());
                        }
                        Collections.sort(toLog);
                        resourcesToLog.add(new Logs.LogResourceEndpointInfo(address, clazz, toLog, methodSize, methodStrSize));
                    }
                    log.info("REST Application: " + endpoint.getEndpointInfo().getAddress() + " -> " + Optional.ofNullable(app).map(AbstractResourceInfo::getResourceClass).map(Class::getName).map(x$0 -> CxfCdiAutoSetup.uproxyName(x$0)).orElse(""));
                    Collections.sort(resourcesToLog);
                    int fClassSize = classSize;
                    int fAddressSize = addressSize;
                    resourcesToLog.forEach(resource -> {
                        log.info("     Service URI: " + Logs.forceLength(((Logs.LogResourceEndpointInfo)resource).address, fAddressSize, true) + " -> " + Logs.forceLength(((Logs.LogResourceEndpointInfo)resource).classname, fClassSize, true));
                        ((Logs.LogResourceEndpointInfo)resource).operations.forEach(info -> log.info("          " + Logs.forceLength(((Logs.LogOperationEndpointInfo)info).http, ((Logs.LogResourceEndpointInfo)resource).methodSize, false) + " " + Logs.forceLength(((Logs.LogOperationEndpointInfo)info).address, fAddressSize, true) + " ->      " + Logs.forceLength(((Logs.LogOperationEndpointInfo)info).method, ((Logs.LogResourceEndpointInfo)resource).methodStrSize, true)));
                        ((Logs.LogResourceEndpointInfo)resource).operations.clear();
                    });
                    resourcesToLog.clear();
                    if (((Configuration)Configuration.class.cast(sc.getServletContext().getAttribute("meecrowave.configuration"))).isJaxrsLogProviders()) {
                        ServerProviderFactory spf = (ServerProviderFactory)ServerProviderFactory.class.cast(endpoint.get((Object)ServerProviderFactory.class.getName()));
                        this.dump(log, spf, "MessageBodyReaders", "messageReaders");
                        this.dump(log, spf, "MessageBodyWriters", "messageWriters");
                    }
                } else {
                    EndpointInfo endpointInfo = endpoint.getEndpointInfo();
                    if (endpointInfo.getName() != null) {
                        log.info("@WebService > " + endpointInfo.getName().toString() + " -> " + base);
                    }
                }
                return base;
            };
        }

        private void dump(LogFacade log, ServerProviderFactory spf, String description, String fieldName) {
            Field field = ReflectionUtil.getDeclaredField(ProviderFactory.class, (String)fieldName);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Collection providers = (Collection)Collection.class.cast(field.get(spf));
                log.info("     " + description);
                providers.stream().map(ProviderInfo::getProvider).forEach(o -> {
                    try {
                        log.info("       - " + o);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                });
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class Logs {
        private Logs() {
        }

        private static String forceLength(String httpMethod, int l, boolean right) {
            int i;
            String http = httpMethod == null ? "" : httpMethod;
            StringBuilder builder = new StringBuilder();
            if (!right) {
                for (i = 0; i < l - http.length(); ++i) {
                    builder.append(" ");
                }
            }
            builder.append(http);
            if (right) {
                for (i = 0; i < l - http.length(); ++i) {
                    builder.append(" ");
                }
            }
            return builder.toString();
        }

        private static String toSimpleString(Method mtd) {
            try {
                StringBuilder sb = new StringBuilder();
                TypeVariable<Method>[] typeparms = mtd.getTypeParameters();
                if (typeparms.length > 0) {
                    boolean first = true;
                    sb.append("<");
                    for (TypeVariable<Method> typeparm : typeparms) {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append(Logs.name(typeparm));
                        first = false;
                    }
                    sb.append("> ");
                }
                Type genRetType = mtd.getGenericReturnType();
                sb.append(Logs.name(genRetType)).append(" ");
                sb.append(mtd.getName()).append("(");
                Type[] params = mtd.getGenericParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    sb.append(Logs.name(params[j]));
                    if (j >= params.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
                Type[] exceptions = mtd.getGenericExceptionTypes();
                if (exceptions.length > 0) {
                    sb.append(" throws ");
                    for (int k = 0; k < exceptions.length; ++k) {
                        sb.append(Logs.name(exceptions[k]));
                        if (k >= exceptions.length - 1) continue;
                        sb.append(",");
                    }
                }
                return sb.toString();
            }
            catch (Exception e) {
                return "<" + e + ">";
            }
        }

        private static String name(Type type) {
            if (type instanceof Class) {
                return ((Class)type).getSimpleName().replace("java.lang.", "").replace("java.util", "");
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                StringBuilder builder = new StringBuilder();
                builder.append(Logs.name(pt.getRawType()));
                Type[] args = pt.getActualTypeArguments();
                if (args != null) {
                    builder.append("<");
                    for (int i = 0; i < args.length; ++i) {
                        builder.append(Logs.name(args[i]));
                        if (i >= args.length - 1) continue;
                        builder.append(", ");
                    }
                    builder.append(">");
                }
                return builder.toString();
            }
            return type.toString();
        }

        private static String singleSlash(String address, String value) {
            if (address.endsWith("/") && value.startsWith("/")) {
                return address + value.substring(1);
            }
            if (!address.endsWith("/") && !value.startsWith("/")) {
                return address + '/' + value;
            }
            if ("/".equals(value)) {
                return address;
            }
            return address + value;
        }

        private static class LogResourceEndpointInfo
        implements Comparable<LogResourceEndpointInfo> {
            private final String address;
            private final String classname;
            private final List<LogOperationEndpointInfo> operations;
            private final int methodSize;
            private final int methodStrSize;

            private LogResourceEndpointInfo(String address, String classname, List<LogOperationEndpointInfo> operations, int methodSize, int methodStrSize) {
                this.address = address;
                this.classname = classname;
                this.operations = operations;
                this.methodSize = methodSize;
                this.methodStrSize = methodStrSize;
            }

            @Override
            public int compareTo(LogResourceEndpointInfo o) {
                int compare = this.address.compareTo(o.address);
                if (compare != 0) {
                    return compare;
                }
                return this.classname.compareTo(o.classname);
            }
        }

        private static class LogOperationEndpointInfo
        implements Comparable<LogOperationEndpointInfo> {
            private final String http;
            private final String address;
            private final String method;

            private LogOperationEndpointInfo(String http, String address, String method) {
                this.address = address;
                this.method = method;
                this.http = http != null ? http : "";
            }

            @Override
            public int compareTo(LogOperationEndpointInfo o) {
                int compare = this.http.compareTo(o.http);
                if (compare != 0) {
                    return compare;
                }
                compare = this.address.compareTo(o.address);
                if (compare != 0) {
                    return compare;
                }
                return this.method.compareTo(o.method);
            }
        }
    }
}

