/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import java.lang.reflect.Field;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.ws.rs.Path;
import org.apache.cxf.BusFactory;
import org.apache.cxf.cdi.JAXRSCdiResourceExtension;
import org.apache.meecrowave.cxf.ConfigurableBus;
import org.apache.meecrowave.logging.tomcat.LogFacade;

public class Cxfs {
    public static final boolean IS_PRESENT;

    private Cxfs() {
    }

    public static boolean hasDefaultBus() {
        return BusFactory.getDefaultBus((boolean)false) != null;
    }

    public static void resetDefaultBusIfEquals(ConfigurableBus clientBus) {
        if (clientBus != null && BusFactory.getDefaultBus((boolean)false) == clientBus) {
            BusFactory.setDefaultBus(null);
        }
    }

    public static Extension mapCdiExtensionIfNeeded(Extension extension) {
        if ("org.apache.cxf.cdi.JAXRSCdiResourceExtension".equals(extension.getClass().getName())) {
            Field serviceBeans;
            try {
                serviceBeans = JAXRSCdiResourceExtension.class.getDeclaredField("serviceBeans");
            }
            catch (NoSuchFieldException e) {
                new LogFacade(Cxfs.class.getName()).warn(e.getMessage(), e);
                return extension;
            }
            if (!serviceBeans.isAccessible()) {
                serviceBeans.setAccessible(true);
            }
            return new ContractFriendlyJAXRSCdiResourceExtension(serviceBeans);
        }
        return extension;
    }

    static {
        boolean present;
        try {
            Cxfs.class.getClassLoader().loadClass("org.apache.cxf.BusFactory");
            present = true;
        }
        catch (ClassNotFoundException e) {
            present = false;
        }
        IS_PRESENT = present;
    }

    private static class ContractFriendlyJAXRSCdiResourceExtension
    extends JAXRSCdiResourceExtension {
        private final Field serviceBeans;

        private ContractFriendlyJAXRSCdiResourceExtension(Field serviceBeans) {
            this.serviceBeans = serviceBeans;
        }

        public <T> void collect(@Observes ProcessBean<T> event) {
            if (!event.getAnnotated().isAnnotationPresent(Path.class) && AnnotatedType.class.isInstance(event.getAnnotated())) {
                AnnotatedType type = (AnnotatedType)AnnotatedType.class.cast(event.getAnnotated());
                if (type.getTypeClosure().stream().filter(it -> Class.class.isInstance(it) && ((Class)Class.class.cast(it)).isInterface()).map(Class.class::cast).anyMatch(c -> c.isAnnotationPresent(Path.class))) {
                    try {
                        ((List)List.class.cast(this.serviceBeans.get((Object)this))).add(event.getBean());
                        return;
                    }
                    catch (IllegalAccessException e) {
                        new LogFacade(Cxfs.class.getName()).error(e.getMessage(), e);
                    }
                }
            }
            super.collect(event);
        }
    }
}

