/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.logging.jul;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.meecrowave.logging.jul.AbstractDelegatingLogger;

public class Log4j2Logger
extends AbstractDelegatingLogger {
    private static final Map<java.util.logging.Level, Level> TO_LOG4J = new HashMap<java.util.logging.Level, Level>();
    private final Logger log;

    public Log4j2Logger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
        this.log = LogManager.getLogger((String)name);
    }

    @Override
    public void setLevel(java.util.logging.Level newLevel) throws SecurityException {
        if (org.apache.logging.log4j.core.Logger.class.isInstance(this.log)) {
            ((org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(this.log)).setLevel(TO_LOG4J.get(newLevel));
        } else if (StatusLogger.class.isInstance(this.log)) {
            ((StatusLogger)StatusLogger.class.cast(this.log)).setLevel(TO_LOG4J.get(newLevel));
        } else if (SimpleLogger.class.isInstance(this.log)) {
            ((SimpleLogger)SimpleLogger.class.cast(this.log)).setLevel(TO_LOG4J.get(newLevel));
        }
    }

    @Override
    public java.util.logging.Level getLevel() {
        Level l = this.log.getLevel();
        if (l != null) {
            return this.fromL4J(l);
        }
        return null;
    }

    @Override
    protected void internalLogFormatted(String msg, LogRecord record) {
        this.log.log(TO_LOG4J.get(record.getLevel()), msg, record.getThrown());
    }

    private java.util.logging.Level fromL4J(Level l) {
        java.util.logging.Level l2 = null;
        switch (l.getStandardLevel()) {
            case ALL: {
                l2 = java.util.logging.Level.ALL;
                break;
            }
            case FATAL: {
                l2 = java.util.logging.Level.SEVERE;
                break;
            }
            case ERROR: {
                l2 = java.util.logging.Level.SEVERE;
                break;
            }
            case WARN: {
                l2 = java.util.logging.Level.WARNING;
                break;
            }
            case INFO: {
                l2 = java.util.logging.Level.INFO;
                break;
            }
            case DEBUG: {
                l2 = java.util.logging.Level.FINE;
                break;
            }
            case OFF: {
                l2 = java.util.logging.Level.OFF;
                break;
            }
            case TRACE: {
                l2 = java.util.logging.Level.FINEST;
                break;
            }
            default: {
                l2 = java.util.logging.Level.FINE;
            }
        }
        return l2;
    }

    static {
        Level t = Level.DEBUG;
        TO_LOG4J.put(java.util.logging.Level.ALL, Level.ALL);
        TO_LOG4J.put(java.util.logging.Level.SEVERE, Level.ERROR);
        TO_LOG4J.put(java.util.logging.Level.WARNING, Level.WARN);
        TO_LOG4J.put(java.util.logging.Level.INFO, Level.INFO);
        TO_LOG4J.put(java.util.logging.Level.CONFIG, Level.DEBUG);
        TO_LOG4J.put(java.util.logging.Level.FINE, Level.DEBUG);
        TO_LOG4J.put(java.util.logging.Level.FINER, Level.TRACE);
        TO_LOG4J.put(java.util.logging.Level.FINEST, Level.TRACE);
        TO_LOG4J.put(java.util.logging.Level.OFF, Level.OFF);
    }
}

