/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.Annotated;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.GenericsUtil;

public abstract class AbstractAnnotated
implements Annotated {
    private final Type baseType;
    private Set<Type> typeClosures;
    private Set<Annotation> annotations = new HashSet<Annotation>();
    private Set<Class<?>> repeatables = new HashSet();
    private final WebBeansContext webBeansContext;

    protected AbstractAnnotated(WebBeansContext webBeansContext, Type baseType) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(baseType, "base type");
        this.baseType = baseType;
        this.webBeansContext = webBeansContext;
    }

    protected AbstractAnnotated(WebBeansContext webBeansContext, Annotated annotated) {
        this.baseType = annotated.getBaseType();
        this.webBeansContext = webBeansContext;
        this.typeClosures = annotated.getTypeClosure();
        this.annotations.addAll(annotated.getAnnotations());
    }

    protected void buildRepeatableAnnotations(Set<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        List repeatables = annotations.stream().map(a -> {
            Class<? extends Annotation> type = a.annotationType();
            try {
                Optional<Method> repeatableMethod = this.webBeansContext.getAnnotationManager().getRepeatableMethod(type);
                if (!repeatableMethod.isPresent()) {
                    return null;
                }
                return (Annotation[])repeatableMethod.orElseThrow(IllegalStateException::new).invoke(a, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).flatMap(Stream::of).collect(Collectors.toList());
        if (!repeatables.isEmpty()) {
            this.repeatables.addAll(repeatables.stream().map(Annotation::annotationType).collect(Collectors.toList()));
            this.annotations.addAll(repeatables);
        }
    }

    public Set<Class<?>> getRepeatables() {
        return this.repeatables;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        this.buildRepeatableAnnotations(Collections.singleton(annotation));
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.clearAnnotations();
        Collections.addAll(this.annotations, annotations);
        this.buildRepeatableAnnotations(this.annotations);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Set<Type> getTypeClosure() {
        if (this.typeClosures == null) {
            this.initTypeClosure();
        }
        return this.typeClosures;
    }

    protected abstract Class<?> getOwningClass();

    protected abstract Class<?> getDeclaringClass();

    private synchronized void initTypeClosure() {
        if (this.typeClosures == null) {
            this.typeClosures = this.extractTypeClojure(this.baseType);
            Set<String> ignoredInterfaces = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            if (!ignoredInterfaces.isEmpty()) {
                Iterator<Type> i = this.typeClosures.iterator();
                while (i.hasNext()) {
                    Type t = i.next();
                    if (!(t instanceof Class) || !ignoredInterfaces.contains(((Class)t).getName())) continue;
                    i.remove();
                }
            }
        }
    }

    protected Set<Type> extractTypeClojure(Type baseType) {
        return GenericsUtil.getTypeClosure(baseType, this.getOwningClass());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Base Type : " + this.baseType.toString() + "," + "Type Closures : " + this.typeClosures + ",Annotations : " + this.annotations.toString();
    }
}

