/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.RecordPointer;
import org.talend.sdk.component.api.record.RecordPointerFactory;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class RecordPointerFactoryImpl
implements RecordPointerFactory,
Serializable {
    private final String plugin;

    public RecordPointer apply(String pointer) {
        return new RecordPointerImpl(pointer);
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, RecordPointerFactory.class.getName());
    }

    public RecordPointerFactoryImpl(String plugin) {
        this.plugin = plugin;
    }

    private static class RecordPointerImpl
    implements RecordPointer,
    Serializable {
        private final String pointer;
        private final List<String> tokens;

        private RecordPointerImpl(String pointer) {
            if (pointer == null) {
                throw new NullPointerException("pointer must not be null");
            }
            if (!pointer.equals("") && !pointer.startsWith("/")) {
                throw new IllegalArgumentException("A non-empty pointer string must begin with a '/'");
            }
            this.pointer = pointer;
            this.tokens = Stream.of(pointer.split("/", -1)).map(s -> {
                if (s == null || s.isEmpty()) {
                    return s;
                }
                return s.replace("~1", "/").replace("~0", "~");
            }).collect(Collectors.toList());
        }

        public <T> T getValue(Record target, Class<T> type) {
            if (target == null) {
                throw new NullPointerException("target must not be null");
            }
            if (this.pointer.equals("") || this.pointer.equals("/")) {
                return type.cast(target);
            }
            Object current = target;
            int lastIdx = this.tokens.size() - 1;
            for (int i = 1; i < this.tokens.size(); ++i) {
                current = this.getValue(current, this.tokens.get(i), i, lastIdx);
            }
            return type.cast(current);
        }

        public <T> T getEntry(Record target, Class<T> type) {
            if (target == null) {
                throw new NullPointerException("target must not be null");
            }
            if (this.pointer.equals("") || this.pointer.equals("/")) {
                return type.cast(target);
            }
            Object current = target;
            int lastIdx = this.tokens.size() - 1;
            for (int i = 1; i < this.tokens.size(); ++i) {
                current = this.getValue(current, this.tokens.get(i), i, lastIdx);
            }
            return type.cast(current);
        }

        private Object getValue(Object value, String referenceToken, int currentPosition, int referencePosition) {
            if (Record.class.isInstance(value)) {
                Record record = (Record)Record.class.cast(value);
                Object nestedVal = this.getRecordEntry(referenceToken, record);
                if (nestedVal != null) {
                    return nestedVal;
                }
                throw new IllegalArgumentException("'" + record + "' contains no value for name '" + referenceToken + "'");
            }
            if (Collection.class.isInstance(value)) {
                if (referenceToken.startsWith("+") || referenceToken.startsWith("-")) {
                    throw new IllegalArgumentException("An array index must not start with '" + referenceToken.charAt(0) + "'");
                }
                if (referenceToken.startsWith("0") && referenceToken.length() > 1) {
                    throw new IllegalArgumentException("An array index must not start with a leading '0'");
                }
                Collection array = (Collection)Collection.class.cast(value);
                try {
                    int arrayIndex = Integer.parseInt(referenceToken);
                    if (arrayIndex >= array.size()) {
                        throw new IllegalArgumentException("'" + array + "' contains no element for index " + arrayIndex);
                    }
                    return List.class.isInstance(array) ? ((List)List.class.cast(array)).get(arrayIndex) : new ArrayList(array).get(arrayIndex);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("'" + referenceToken + "' is no valid array index", e);
                }
            }
            if (currentPosition != referencePosition) {
                return value;
            }
            throw new IllegalArgumentException("'" + value + "' contains no element for '" + referenceToken + "'");
        }

        private Object getRecordEntry(Schema.Entry entry, Record record) {
            switch (entry.getType()) {
                case STRING: {
                    return record.getString(entry.getName());
                }
                case INT: {
                    return record.getInt(entry.getName());
                }
                case LONG: {
                    return record.getLong(entry.getName());
                }
                case FLOAT: {
                    return Float.valueOf(record.getFloat(entry.getName()));
                }
                case DOUBLE: {
                    return record.getDouble(entry.getName());
                }
                case BOOLEAN: {
                    return record.getBoolean(entry.getName());
                }
                case BYTES: {
                    return record.getBytes(entry.getName());
                }
                case DATETIME: {
                    return record.getDateTime(entry.getName());
                }
                case RECORD: {
                    return record.getRecord(entry.getName());
                }
                case ARRAY: {
                    return record.getArray(Object.class, entry.getName());
                }
            }
            throw new IllegalArgumentException("Unsupported entry type for: " + entry);
        }

        private Object getRecordEntry(String referenceToken, Record record) {
            return this.getEntry(referenceToken, record).map(entry -> this.getRecordEntry((Schema.Entry)entry, record)).orElseGet(() -> record.get(Object.class, referenceToken));
        }

        private Optional<Schema.Entry> getEntry(String referenceToken, Record record) {
            return record.getSchema().getEntries().stream().filter(it -> it.getName().equals(referenceToken)).findFirst();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.pointer.equals(((RecordPointerImpl)RecordPointerImpl.class.cast((Object)obj)).pointer);
        }

        public int hashCode() {
            return this.pointer.hashCode();
        }
    }
}

