/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.ContinuationProviderFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.front.security.ConnectionSecurityProvider;

@Dependent
@WebListener
public class WebSocketBroadcastSetup
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(WebSocketBroadcastSetup.class);
    private static final String EOM = "^@";
    @Inject
    private Bus bus;
    @Inject
    private Instance<Application> applications;

    public void contextInitialized(ServletContextEvent sce) {
        DestinationRegistry registry;
        ServerContainer container = (ServerContainer)ServerContainer.class.cast(sce.getServletContext().getAttribute(ServerContainer.class.getName()));
        JAXRSServiceFactoryBean factory = (JAXRSServiceFactoryBean)JAXRSServiceFactoryBean.class.cast(((Server)((ServerRegistry)this.bus.getExtension(ServerRegistry.class)).getServers().iterator().next()).getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName()));
        final String appBase = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.applications.iterator(), 1024), false).filter(a -> a.getClass().isAnnotationPresent(ApplicationPath.class)).map(a -> a.getClass().getAnnotation(ApplicationPath.class)).map(ApplicationPath::value).findFirst().map(s -> !s.startsWith("/") ? "/" + s : s).orElse("/api/v1");
        String version = appBase.replaceFirst("/api", "");
        try {
            HTTPTransportFactory transportFactory = (HTTPTransportFactory)HTTPTransportFactory.class.cast(((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory("http://cxf.apache.org/transports/http/configuration"));
            registry = transportFactory.getRegistry();
        }
        catch (BusException e2) {
            throw new IllegalStateException(e2);
        }
        final ServletContext servletContext = sce.getServletContext();
        WebSocketRegistry webSocketRegistry = new WebSocketRegistry(registry);
        final ServletController controller = new ServletController((DestinationRegistry)webSocketRegistry, new ServletConfig(){

            public String getServletName() {
                return "Talend Component Kit Websocket Transport";
            }

            public ServletContext getServletContext() {
                return servletContext;
            }

            public String getInitParameter(String s) {
                return null;
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.emptyEnumeration();
            }
        }, (HttpServlet)new ServiceListGeneratorServlet(registry, this.bus));
        webSocketRegistry.controller = controller;
        Stream.concat(factory.getClassResourceInfo().stream().flatMap(cri -> cri.getMethodDispatcher().getOperationResourceInfos().stream()).filter(cri -> cri.getAnnotatedMethod().getDeclaringClass().getName().startsWith("org.talend.")).map(ori -> {
            String uri = ori.getClassResourceInfo().getURITemplate().getValue() + ori.getURITemplate().getValue();
            return ServerEndpointConfig.Builder.create(Endpoint.class, (String)("/websocket" + version + "/" + String.valueOf(ori.getHttpMethod()).toLowerCase(Locale.ENGLISH) + uri)).configurator(new ServerEndpointConfig.Configurator((OperationResourceInfo)ori, appBase, controller, servletContext, uri){
                final /* synthetic */ OperationResourceInfo val$ori;
                final /* synthetic */ String val$appBase;
                final /* synthetic */ ServletController val$controller;
                final /* synthetic */ ServletContext val$servletContext;
                final /* synthetic */ String val$uri;
                {
                    this.val$ori = operationResourceInfo;
                    this.val$appBase = string;
                    this.val$controller = servletController;
                    this.val$servletContext = servletContext;
                    this.val$uri = string2;
                }

                public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
                    HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                    if (!this.val$ori.getProduceTypes().isEmpty()) {
                        headers.put("Content-Type", Collections.singletonList(((MediaType)this.val$ori.getProduceTypes().iterator().next()).toString()));
                    }
                    if (!this.val$ori.getConsumeTypes().isEmpty()) {
                        headers.put("Accept", Collections.singletonList(((MediaType)this.val$ori.getConsumeTypes().iterator().next()).toString()));
                    }
                    return (T)((Object)new JAXRSEndpoint(this.val$appBase, this.val$controller, this.val$servletContext, this.val$ori.getHttpMethod(), this.val$uri, headers));
                }
            }).build();
        }), Stream.of(ServerEndpointConfig.Builder.create(Endpoint.class, (String)("/websocket" + version + "/bus")).configurator(new ServerEndpointConfig.Configurator(){

            public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
                return (T)((Object)new JAXRSEndpoint(appBase, controller, servletContext, "GET", "/", Collections.emptyMap()));
            }
        }).build())).sorted(Comparator.comparing(ServerEndpointConfig::getPath)).peek(e -> log.info("Deploying WebSocket(path={})", (Object)e.getPath())).forEach(config -> {
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private static class WebSocketContinuation
    implements ContinuationProvider,
    Continuation {
        private final Message message;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final WebSocketRegistry registry;
        private final ContinuationCallback callback;
        private Object object;
        private boolean resumed;
        private boolean pending;
        private boolean isNew;

        private WebSocketContinuation(Message message, HttpServletRequest request, HttpServletResponse response, WebSocketRegistry registry) {
            this.message = message;
            this.request = request;
            this.response = response;
            this.registry = registry;
            this.request.setAttribute("cxf.continuation.message", (Object)message.getExchange().getInMessage());
            this.callback = (ContinuationCallback)message.getExchange().get(ContinuationCallback.class);
        }

        public Continuation getContinuation() {
            return this;
        }

        public void complete() {
            this.message.getExchange().getInMessage().remove((Object)"cxf.continuation.message");
            if (this.callback != null) {
                Exception ex = (Exception)this.message.getExchange().get(Exception.class);
                if (ex == null) {
                    this.callback.onComplete();
                } else {
                    this.callback.onError((Throwable)ex);
                }
            }
            try {
                this.response.getWriter().close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean suspend(long timeout) {
            this.isNew = false;
            this.resumed = false;
            this.pending = true;
            this.message.getExchange().getInMessage().getInterceptorChain().suspend();
            return true;
        }

        public void resume() {
            this.resumed = true;
            try {
                this.registry.controller.invoke(this.request, this.response);
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }

        public void reset() {
            this.pending = false;
            this.resumed = false;
            this.isNew = false;
            this.object = null;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isPending() {
            return this.pending;
        }

        public boolean isResumed() {
            return this.resumed;
        }

        public boolean isTimeout() {
            return false;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object o) {
            this.object = o;
        }

        public boolean isReadyForWrite() {
            return true;
        }
    }

    private static class WebSocketContinuationFactory
    implements ContinuationProviderFactory {
        private static final String KEY = WebSocketContinuationFactory.class.getName();
        private final WebSocketRegistry registry;

        private WebSocketContinuationFactory(WebSocketRegistry registry) {
            this.registry = registry;
        }

        public ContinuationProvider createContinuationProvider(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
            return new WebSocketContinuation(inMessage, req, resp, this.registry);
        }

        public Message retrieveFromContinuation(HttpServletRequest req) {
            return (Message)Message.class.cast(req.getAttribute(KEY));
        }
    }

    private static class WebSocketDestination
    extends AbstractHTTPDestination {
        static final java.util.logging.Logger LOG = LogUtils.getL7dLogger(ServletDestination.class);
        private final AbstractHTTPDestination delegate;

        private WebSocketDestination(AbstractHTTPDestination delegate, WebSocketRegistry registry) throws IOException {
            super(delegate.getBus(), (DestinationRegistry)registry, new EndpointInfo(), delegate.getPath(), false);
            this.delegate = delegate;
            this.cproviderFactory = new WebSocketContinuationFactory(registry);
        }

        public EndpointReferenceType getAddress() {
            return this.delegate.getAddress();
        }

        public Conduit getBackChannel(Message inMessage) throws IOException {
            return this.delegate.getBackChannel(inMessage);
        }

        public EndpointInfo getEndpointInfo() {
            return this.delegate.getEndpointInfo();
        }

        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        public void setMessageObserver(MessageObserver observer) {
            throw new UnsupportedOperationException();
        }

        public MessageObserver getMessageObserver() {
            return this.delegate.getMessageObserver();
        }

        protected java.util.logging.Logger getLogger() {
            return LOG;
        }

        public Bus getBus() {
            return this.delegate.getBus();
        }

        public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                inMessage = new MessageImpl();
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                this.setupMessage(inMessage, config, context, req, resp);
                exchange.setSession((org.apache.cxf.transport.Session)new HTTPSession(req));
                ((MessageImpl)MessageImpl.class.cast(inMessage)).setDestination((Destination)this);
            }
            this.delegate.invoke(config, context, req, resp);
        }

        public void finalizeConfig() {
            this.delegate.finalizeConfig();
        }

        public String getBeanName() {
            return this.delegate.getBeanName();
        }

        public EndpointReferenceType getAddressWithId(String id) {
            return this.delegate.getAddressWithId(id);
        }

        public String getId(Map<String, Object> context) {
            return this.delegate.getId(context);
        }

        public String getContextMatchStrategy() {
            return this.delegate.getContextMatchStrategy();
        }

        public boolean isFixedParameterOrder() {
            return this.delegate.isFixedParameterOrder();
        }

        public boolean isMultiplexWithAddress() {
            return this.delegate.isMultiplexWithAddress();
        }

        public HTTPServerPolicy getServer() {
            return this.delegate.getServer();
        }

        public void assertMessage(Message message) {
            this.delegate.assertMessage(message);
        }

        public boolean canAssert(QName type) {
            return this.delegate.canAssert(type);
        }

        public String getPath() {
            return this.delegate.getPath();
        }
    }

    private static class WebSocketRegistry
    implements DestinationRegistry {
        private final DestinationRegistry delegate;
        private ServletController controller;

        private WebSocketRegistry(DestinationRegistry registry) {
            this.delegate = registry;
        }

        public void addDestination(AbstractHTTPDestination destination) {
            throw new UnsupportedOperationException();
        }

        public void removeDestination(String path) {
            throw new UnsupportedOperationException();
        }

        public AbstractHTTPDestination getDestinationForPath(String path) {
            return this.wrap(this.delegate.getDestinationForPath(path));
        }

        public AbstractHTTPDestination getDestinationForPath(String path, boolean tryDecoding) {
            return this.wrap(this.delegate.getDestinationForPath(path, tryDecoding));
        }

        public AbstractHTTPDestination checkRestfulRequest(String address) {
            return this.wrap(this.delegate.checkRestfulRequest(address));
        }

        public Collection<AbstractHTTPDestination> getDestinations() {
            return this.delegate.getDestinations();
        }

        public AbstractDestination[] getSortedDestinations() {
            return this.delegate.getSortedDestinations();
        }

        public Set<String> getDestinationsPaths() {
            return this.delegate.getDestinationsPaths();
        }

        private AbstractHTTPDestination wrap(AbstractHTTPDestination destination) {
            try {
                return destination == null ? null : new WebSocketDestination(destination, this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class ServletByteArrayOutputStream
    extends ServletOutputStream {
        private static final byte[] EOM_BYTES = "^@".getBytes(StandardCharsets.UTF_8);
        private static final int BUFFER_SIZE = 8192;
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final Session session;
        private final Supplier<String> preWrite;
        private boolean closed;
        private boolean headerWritten;

        private ServletByteArrayOutputStream(Session session, Supplier<String> preWrite) {
            this.session = session;
            this.preWrite = preWrite;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener listener) {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.outputStream.write(b, off, len);
        }

        public void writeTo(OutputStream out) throws IOException {
            this.outputStream.writeTo(out);
        }

        public void reset() {
            this.outputStream.reset();
        }

        public void flush() throws IOException {
            if (!this.session.isOpen()) {
                return;
            }
            if (this.outputStream.size() >= 8192) {
                this.doFlush();
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.outputStream.write(EOM_BYTES);
            this.doFlush();
            this.closed = true;
        }

        private void doFlush() throws IOException {
            boolean written;
            RemoteEndpoint.Basic basicRemote = this.session.getBasicRemote();
            byte[] array = this.outputStream.toByteArray();
            boolean bl = written = array.length > 0 || !this.headerWritten;
            if (!this.headerWritten) {
                String headers = this.preWrite.get();
                basicRemote.sendBinary(ByteBuffer.wrap(headers.getBytes(StandardCharsets.UTF_8)));
                this.headerWritten = true;
            }
            if (array.length > 0) {
                this.outputStream.reset();
                basicRemote.sendBinary(ByteBuffer.wrap(array));
            }
            if (written && basicRemote.getBatchingAllowed()) {
                basicRemote.flushBatch();
            }
        }
    }

    private static class WebSocketResponse
    implements HttpServletResponse {
        private final Session session;
        private int code = 200;
        private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private transient PrintWriter writer;
        private transient ServletByteArrayOutputStream sosi;
        private boolean commited = false;
        private String encoding = "UTF-8";
        private Locale locale = Locale.getDefault();

        private WebSocketResponse(Session session) {
            this.session = session;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, new ArrayList<String>(Collections.singletonList(value)));
        }

        public void setIntHeader(String s, int i) {
            this.setHeader(s, Integer.toString(i));
        }

        public void setStatus(int i) {
            this.setCode(i);
        }

        public void setStatus(int i, String s) {
            this.setCode(i);
        }

        public void addCookie(Cookie cookie) {
            this.setHeader(cookie.getName(), cookie.getValue());
        }

        public void addDateHeader(String s, long l) {
            this.setHeader(s, Long.toString(l));
        }

        public void addHeader(String s, String s1) {
            Collection list = this.headers.get(s);
            if (list == null) {
                this.setHeader(s, s1);
            } else {
                list.add(s1);
            }
        }

        public void addIntHeader(String s, int i) {
            this.setIntHeader(s, i);
        }

        public boolean containsHeader(String s) {
            return this.headers.containsKey(s);
        }

        public String encodeURL(String s) {
            return this.toEncoded(s);
        }

        public String encodeRedirectURL(String s) {
            return this.toEncoded(s);
        }

        public String encodeUrl(String s) {
            return this.toEncoded(s);
        }

        public String encodeRedirectUrl(String s) {
            return this.encodeRedirectURL(s);
        }

        public String getHeader(String name) {
            Collection strings = this.headers.get(name);
            return strings == null ? null : (String)strings.iterator().next();
        }

        public Collection<String> getHeaderNames() {
            return this.headers.keySet();
        }

        public Collection<String> getHeaders(String s) {
            return this.headers.get(s);
        }

        public int getStatus() {
            return this.getCode();
        }

        public void sendError(int i) throws IOException {
            this.setCode(i);
        }

        public void sendError(int i, String s) throws IOException {
            this.setCode(i);
        }

        public void sendRedirect(String path) throws IOException {
            if (this.commited) {
                throw new IllegalStateException("response already committed");
            }
            this.resetBuffer();
            try {
                this.setStatus(302);
                this.setHeader("Location", this.toEncoded(path));
            }
            catch (IllegalArgumentException e) {
                this.setStatus(404);
            }
        }

        public void setDateHeader(String s, long l) {
            this.addDateHeader(s, l);
        }

        public ServletOutputStream getOutputStream() {
            return this.sosi == null ? (this.sosi = this.createOutputStream()) : this.sosi;
        }

        public PrintWriter getWriter() {
            return this.writer == null ? (this.writer = new PrintWriter((OutputStream)this.getOutputStream())) : this.writer;
        }

        public boolean isCommitted() {
            return this.commited;
        }

        public void reset() {
            this.createOutputStream();
        }

        private ServletByteArrayOutputStream createOutputStream() {
            this.sosi = new ServletByteArrayOutputStream(this.session, () -> {
                StringBuilder top = new StringBuilder("MESSAGE\r\n");
                top.append("status: ").append(this.getStatus()).append("\r\n");
                this.headers.forEach((k, v) -> top.append((String)k).append(": ").append(v.stream().collect(Collectors.joining(","))).append("\r\n"));
                top.append("\r\n");
                return top.toString();
            });
            return this.sosi;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
        }

        public int getBufferSize() {
            return this.sosi.outputStream.size();
        }

        public String getCharacterEncoding() {
            return this.encoding;
        }

        public void setCode(int code) {
            this.code = code;
            this.commited = true;
        }

        public int getCode() {
            return this.code;
        }

        public void setContentType(String type) {
            this.setHeader("Content-Type", type);
        }

        public void setLocale(Locale loc) {
            this.locale = loc;
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void resetBuffer() {
            this.sosi.outputStream.reset();
        }

        public void setBufferSize(int i) {
        }

        public void setCharacterEncoding(String s) {
            this.encoding = s;
        }

        public void setContentLength(int i) {
        }

        public void setContentLengthLong(long length) {
        }

        private String toEncoded(String url) {
            return url;
        }
    }

    private static class WebSocketInputStream
    extends ServletInputStream {
        private final InputStream delegate;
        private boolean finished;
        private int previous = Integer.MAX_VALUE;

        private WebSocketInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            if (this.finished) {
                return -1;
            }
            if (this.previous != Integer.MAX_VALUE) {
                this.previous = Integer.MAX_VALUE;
                return this.previous;
            }
            int read = this.delegate.read();
            if (read == 94) {
                this.previous = this.delegate.read();
                if (this.previous == 64) {
                    this.finished = true;
                    return -1;
                }
            }
            if (read < 0) {
                this.finished = true;
            }
            return read;
        }
    }

    private static class WebSocketRequest
    implements HttpServletRequest {
        private static final Cookie[] NO_COOKIE = new Cookie[0];
        private static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final String method;
        private final Map<String, List<String>> headers;
        private final String requestUri;
        private final String pathInfo;
        private final String servletPath;
        private final String query;
        private final int port;
        private final ServletContext servletContext;
        private final ServletInputStream inputStream;
        private final Session session;
        private String encoding;
        private long length;
        private String type;
        private Map<String, String[]> parameters = new HashMap<String, String[]>();
        private Locale locale = Locale.getDefault();
        private BufferedReader reader;

        private WebSocketRequest(String method, Map<String, List<String>> headers, String requestUri, String pathInfo, String servletPath, String query, int port, ServletContext servletContext, ServletInputStream inputStream, Session session) {
            this.method = method;
            this.headers = headers;
            this.requestUri = requestUri;
            this.pathInfo = pathInfo;
            this.servletPath = servletPath;
            this.query = query;
            this.port = port;
            this.servletContext = servletContext;
            this.inputStream = inputStream;
            this.session = session;
        }

        public String getAuthType() {
            return null;
        }

        public Cookie[] getCookies() {
            return NO_COOKIE;
        }

        public long getDateHeader(String name) {
            String value = this.getHeader(name);
            if (value == null) {
                return -1L;
            }
            DateFormat[] formats = new SimpleDateFormat[DATE_FORMATS.length];
            for (int i = 0; i < formats.length; ++i) {
                formats[i] = (SimpleDateFormat)SimpleDateFormat.class.cast(DATE_FORMATS[i].clone());
            }
            long result = FastHttpDateFormat.parseDate((String)value, (DateFormat[])formats);
            if (result != -1L) {
                return result;
            }
            throw new IllegalArgumentException(value);
        }

        public String getHeader(String s) {
            List<String> strings = this.headers.get(s);
            return strings == null || strings.isEmpty() ? null : strings.iterator().next();
        }

        public Enumeration<String> getHeaders(String s) {
            List<String> strings = this.headers.get(s);
            return strings == null || strings.isEmpty() ? null : Collections.enumeration(strings);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.headers.keySet());
        }

        public int getIntHeader(String s) {
            String value = this.getHeader(s);
            if (value == null) {
                return -1;
            }
            return Integer.parseInt(value);
        }

        public String getMethod() {
            return this.method;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getPathTranslated() {
            return this.pathInfo;
        }

        public String getContextPath() {
            return this.servletContext.getContextPath();
        }

        public String getQueryString() {
            return this.query;
        }

        public String getRemoteUser() {
            Principal principal = this.getUserPrincipal();
            return principal == null ? null : principal.getName();
        }

        public boolean isUserInRole(String s) {
            return false;
        }

        public Principal getUserPrincipal() {
            return this.session.getUserPrincipal();
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return this.requestUri;
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.requestUri);
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public HttpSession getSession(boolean b) {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public String changeSessionId() {
            return null;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
            return false;
        }

        public void login(String s, String s1) throws ServletException {
        }

        public void logout() throws ServletException {
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return Collections.emptySet();
        }

        public Part getPart(String s) throws IOException, ServletException {
            return null;
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
            return null;
        }

        public Object getAttribute(String s) {
            if (ConnectionSecurityProvider.SKIP.equalsIgnoreCase(s)) {
                return Boolean.TRUE;
            }
            return this.attributes.get(s);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(this.attributes.keySet());
        }

        public String getCharacterEncoding() {
            return this.encoding;
        }

        public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
            this.encoding = s;
        }

        public int getContentLength() {
            return (int)this.length;
        }

        public long getContentLengthLong() {
            return this.length;
        }

        public String getContentType() {
            return this.type;
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public String getParameter(String s) {
            String[] strings = this.parameters.get(s);
            return strings == null || strings.length == 0 ? null : strings[0];
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.parameters.keySet());
        }

        public String[] getParameterValues(String s) {
            return this.parameters.get(s);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameters;
        }

        public String getProtocol() {
            return "HTTP/1.1";
        }

        public String getScheme() {
            return "http";
        }

        public String getServerName() {
            return this.servletContext.getVirtualServerName();
        }

        public int getServerPort() {
            return this.port;
        }

        public BufferedReader getReader() throws IOException {
            return this.reader == null ? (this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()))) : this.reader;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String s, Object o) {
            this.attributes.put(s, o);
        }

        public void removeAttribute(String s) {
            this.attributes.remove(s);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public Enumeration<Locale> getLocales() {
            return this.locale == null ? Collections.emptyEnumeration() : Collections.enumeration(Collections.singleton(this.locale));
        }

        public boolean isSecure() {
            return false;
        }

        public String getRealPath(String s) {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public RequestDispatcher getRequestDispatcher(String s) {
            return this.servletContext.getRequestDispatcher(s);
        }

        public AsyncContext startAsync() throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public AsyncContext getAsyncContext() {
            throw new UnsupportedOperationException();
        }

        public DispatcherType getDispatcherType() {
            throw new UnsupportedOperationException();
        }
    }

    private static class JAXRSEndpoint
    extends Endpoint {
        private final String appBase;
        private final ServletController controller;
        private final ServletContext context;
        private final String defaultMethod;
        private final String defaultUri;
        private final Map<String, List<String>> baseHeaders;

        public void onOpen(Session session, EndpointConfig endpointConfig) {
            log.debug("Opened session {}", (Object)session.getId());
            session.addMessageHandler(InputStream.class, message -> {
                String path;
                String queryString;
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                headers.putAll(this.baseHeaders);
                StringBuilder buffer = new StringBuilder(128);
                try {
                    String line;
                    if (!"SEND".equalsIgnoreCase(JAXRSEndpoint.readLine(buffer, message))) {
                        throw new IllegalArgumentException("not a message");
                    }
                    while ((line = JAXRSEndpoint.readLine(buffer, message)) != null) {
                        boolean done = line.endsWith(WebSocketBroadcastSetup.EOM);
                        if (done) {
                            line = line.substring(0, line.length() - WebSocketBroadcastSetup.EOM.length());
                        }
                        if (!line.isEmpty()) {
                            int del = line.indexOf(58);
                            if (del < 0) {
                                headers.put(line.trim(), Collections.emptyList());
                            } else {
                                headers.put(line.substring(0, del).trim(), Collections.singletonList(line.substring(del + 1).trim()));
                            }
                        }
                        if (!done) continue;
                        break;
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
                List uris = (List)headers.get("destination");
                String uri = uris == null || uris.isEmpty() ? this.defaultUri : (String)uris.iterator().next();
                List methods = (List)headers.get("destinationMethod");
                String method = methods == null || methods.isEmpty() ? this.defaultMethod : (String)methods.iterator().next();
                int query = uri.indexOf(63);
                if (query > 0) {
                    queryString = uri.substring(query + 1);
                    path = uri.substring(0, query);
                } else {
                    queryString = null;
                    path = uri;
                }
                try {
                    WebSocketRequest request = new WebSocketRequest(method.toUpperCase(Locale.ENGLISH), headers, path, this.appBase + path, this.appBase, queryString, 8080, this.context, new WebSocketInputStream((InputStream)message), session);
                    this.controller.invoke((HttpServletRequest)request, (HttpServletResponse)new WebSocketResponse(session));
                }
                catch (ServletException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }

        public void onClose(Session session, CloseReason closeReason) {
            log.debug("Closed session {}", (Object)session.getId());
        }

        public void onError(Session session, Throwable throwable) {
            log.warn("Error for session {}", (Object)session.getId(), (Object)throwable);
        }

        private static String readLine(StringBuilder buffer, InputStream in) throws IOException {
            int c;
            while ((c = in.read()) != -1 && c != 10) {
                if (c == 13) continue;
                buffer.append((char)c);
            }
            if (buffer.length() == 0) {
                return null;
            }
            String string = buffer.toString();
            buffer.setLength(0);
            return string;
        }

        public JAXRSEndpoint(String appBase, ServletController controller, ServletContext context, String defaultMethod, String defaultUri, Map<String, List<String>> baseHeaders) {
            this.appBase = appBase;
            this.controller = controller;
            this.context = context;
            this.defaultMethod = defaultMethod;
            this.defaultUri = defaultUri;
            this.baseHeaders = baseHeaders;
        }

        public String getAppBase() {
            return this.appBase;
        }

        public ServletController getController() {
            return this.controller;
        }

        public ServletContext getContext() {
            return this.context;
        }

        public String getDefaultMethod() {
            return this.defaultMethod;
        }

        public String getDefaultUri() {
            return this.defaultUri;
        }

        public Map<String, List<String>> getBaseHeaders() {
            return this.baseHeaders;
        }

        public String toString() {
            return "WebSocketBroadcastSetup.JAXRSEndpoint(appBase=" + this.getAppBase() + ", controller=" + this.getController() + ", context=" + this.getContext() + ", defaultMethod=" + this.getDefaultMethod() + ", defaultUri=" + this.getDefaultUri() + ", baseHeaders=" + this.getBaseHeaders() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JAXRSEndpoint)) {
                return false;
            }
            JAXRSEndpoint other = (JAXRSEndpoint)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$appBase = this.getAppBase();
            String other$appBase = other.getAppBase();
            if (this$appBase == null ? other$appBase != null : !this$appBase.equals(other$appBase)) {
                return false;
            }
            ServletController this$controller = this.getController();
            ServletController other$controller = other.getController();
            if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
                return false;
            }
            ServletContext this$context = this.getContext();
            ServletContext other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$defaultMethod = this.getDefaultMethod();
            String other$defaultMethod = other.getDefaultMethod();
            if (this$defaultMethod == null ? other$defaultMethod != null : !this$defaultMethod.equals(other$defaultMethod)) {
                return false;
            }
            String this$defaultUri = this.getDefaultUri();
            String other$defaultUri = other.getDefaultUri();
            if (this$defaultUri == null ? other$defaultUri != null : !this$defaultUri.equals(other$defaultUri)) {
                return false;
            }
            Map<String, List<String>> this$baseHeaders = this.getBaseHeaders();
            Map<String, List<String>> other$baseHeaders = other.getBaseHeaders();
            return !(this$baseHeaders == null ? other$baseHeaders != null : !((Object)this$baseHeaders).equals(other$baseHeaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JAXRSEndpoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appBase = this.getAppBase();
            result = result * 59 + ($appBase == null ? 43 : $appBase.hashCode());
            ServletController $controller = this.getController();
            result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
            ServletContext $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $defaultMethod = this.getDefaultMethod();
            result = result * 59 + ($defaultMethod == null ? 43 : $defaultMethod.hashCode());
            String $defaultUri = this.getDefaultUri();
            result = result * 59 + ($defaultUri == null ? 43 : $defaultUri.hashCode());
            Map<String, List<String>> $baseHeaders = this.getBaseHeaders();
            result = result * 59 + ($baseHeaders == null ? 43 : ((Object)$baseHeaders).hashCode());
            return result;
        }
    }
}

