/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.server.api.DocumentationResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.front.model.DocumentationContent;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.LocaleMapper;

@ApplicationScoped
public class DocumentationResourceImpl
implements DocumentationResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentationResourceImpl.class);
    private static final DocumentationContent NO_DOC = new DocumentationContent("asciidoc", "");
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentManager manager;
    @Inject
    private Instance<Object> instance;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private ExtensionComponentMetadataManager virtualComponents;
    private File i18nBase;

    @PostConstruct
    private void init() {
        this.i18nBase = new File(this.configuration.getDocumentationI18nTranslations().replace("${home}", System.getProperty("meecrowave.home", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentationContent getDocumentation(String id, String language, DocumentationResource.DocumentationSegment segment) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return NO_DOC;
        }
        Locale locale = this.localeMapper.mapLocale(language);
        Container container = Optional.ofNullable(this.componentDao.findById(id)).map(meta -> (Container)this.manager.findPlugin(meta.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "'")).build()))).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
        DocumentationCache cache = (DocumentationCache)container.get(DocumentationCache.class);
        if (cache == null) {
            Container container2 = container;
            synchronized (container2) {
                cache = (DocumentationCache)container.get(DocumentationCache.class);
                if (cache == null) {
                    cache = new DocumentationCache();
                    container.set(DocumentationCache.class, (Object)cache);
                }
            }
        }
        return cache.documentations.computeIfAbsent(new DocKey(id, language, segment), key -> {
            String content = Stream.of("documentation_" + locale.getLanguage() + ".adoc", "documentation_" + language + ".adoc", "documentation.adoc").flatMap(name -> {
                try {
                    return Optional.ofNullable(container.getLoader().getResources("TALEND-INF/" + name)).filter(Enumeration::hasMoreElements).map(e -> Collections.list(e).stream()).orElseGet(() -> Optional.ofNullable(this.findLocalI18n(locale, container)).map(Stream::of).orElseGet(Stream::empty));
                }
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }).filter(Objects::nonNull).map(url -> {
                try (BufferedReader stream = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    String string = stream.lines().collect(Collectors.joining("\n"));
                    return string;
                }
                catch (IOException e) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).build());
                }
            }).distinct().sorted().reduce((s1, s2) -> String.join((CharSequence)"\n\n", s1, Optional.ofNullable(s2).orElse(""))).map(value -> Optional.ofNullable(container.get(ContainerComponentRegistry.class)).flatMap(r -> r.getComponents().values().stream().flatMap(f -> Stream.concat(f.getPartitionMappers().values().stream(), f.getProcessors().values().stream())).filter(c -> c.getId().equals(id)).findFirst().map(c -> this.selectById(c.getName(), (String)value, segment))).orElse(value)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
            return new DocumentationContent("asciidoc", content);
        });
    }

    private URL findLocalI18n(Locale locale, Container container) {
        if (!this.i18nBase.exists()) {
            return null;
        }
        File file = new File(this.i18nBase, "documentation_" + container.getId() + "_" + locale.getLanguage() + ".adoc");
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    String selectById(String name, String value, DocumentationResource.DocumentationSegment segment) {
        List lines;
        try (BufferedReader reader = new BufferedReader(new StringReader(value));){
            lines = reader.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        TreeMap configurationLevels = lines.stream().filter(it -> it.endsWith("= Configuration")).map(it -> it.indexOf(32)).collect(Collectors.groupingBy(it -> it, TreeMap::new, Collectors.toList()));
        if (configurationLevels.isEmpty()) {
            return value;
        }
        int titleLevels = Math.max(1, (Integer)configurationLevels.lastKey() - 1);
        String prefixTitle = IntStream.range(0, titleLevels).mapToObj(i -> "=").collect(Collectors.joining()) + " ";
        int titleIndex = lines.indexOf(prefixTitle + name);
        if (titleIndex < 0) {
            return value;
        }
        List endOfLines = lines.subList(titleIndex, lines.size());
        int lineIdx = 0;
        for (String line : endOfLines) {
            if (lineIdx > 0 && line.startsWith(prefixTitle)) {
                endOfLines = endOfLines.subList(0, lineIdx);
                break;
            }
            ++lineIdx;
        }
        if (!endOfLines.isEmpty()) {
            switch (segment) {
                case DESCRIPTION: {
                    int firstIndex;
                    String configTitle = this.getConfigTitle(prefixTitle);
                    int configIndex = endOfLines.indexOf(configTitle);
                    boolean skipFirst = ((String)endOfLines.get(0)).startsWith(prefixTitle);
                    int lastIndex = configIndex < 0 ? endOfLines.size() : configIndex;
                    int n = firstIndex = skipFirst ? 1 : 0;
                    if (lastIndex - firstIndex <= 0) {
                        return "";
                    }
                    return String.join((CharSequence)"\n", endOfLines.subList(firstIndex, lastIndex));
                }
                case CONFIGURATION: {
                    String configTitle = this.getConfigTitle(prefixTitle);
                    int configIndex = endOfLines.indexOf(configTitle);
                    if (configIndex < 0 || configIndex + 1 >= endOfLines.size()) {
                        return "";
                    }
                    return String.join((CharSequence)"\n", endOfLines.subList(configIndex + 1, endOfLines.size()));
                }
            }
            return String.join((CharSequence)"\n", endOfLines);
        }
        return value;
    }

    private String getConfigTitle(String prefixTitle) {
        return '=' + prefixTitle + "Configuration";
    }

    private static class DocumentationCache {
        private final ConcurrentMap<DocKey, DocumentationContent> documentations = new ConcurrentHashMap<DocKey, DocumentationContent>();

        private DocumentationCache() {
        }
    }

    private static class DocKey {
        private final String id;
        private final String language;
        private final DocumentationResource.DocumentationSegment segment;
        private final int hash;

        private DocKey(String id, String language, DocumentationResource.DocumentationSegment segment) {
            this.id = id;
            this.language = language;
            this.segment = segment;
            this.hash = Objects.hash(id, language, segment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocKey docKey = (DocKey)DocKey.class.cast(o);
            return this.id.equals(docKey.id) && this.language.equals(docKey.language) && this.segment == docKey.segment;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

