/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.security.web;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

public abstract class SecuredFilter
implements Filter {
    @Inject
    private ComponentServerConfiguration configuration;
    private Set<String> tokens;

    public void init(FilterConfig filterConfig) {
        this.tokens = Stream.of(this.configuration.getSecuredEndpointsTokens().split(",")).map(String::trim).filter(it -> !it.isEmpty() && !"-".equals(it)).collect(Collectors.toSet());
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if ((this.isLocal(servletRequest) || this.isSecured(servletRequest)) && this.canCall(servletRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)HttpServletResponse.class.cast(servletResponse);
        response.setStatus(404);
    }

    protected boolean canCall(ServletRequest servletRequest) {
        return true;
    }

    private boolean isSecured(ServletRequest servletRequest) {
        String authorization = ((HttpServletRequest)HttpServletRequest.class.cast(servletRequest)).getHeader("Authorization");
        return authorization != null && this.tokens.contains(authorization);
    }

    private boolean isLocal(ServletRequest servletRequest) {
        return HttpServletRequest.class.isInstance(servletRequest) && Optional.ofNullable(((HttpServletRequest)HttpServletRequest.class.cast(servletRequest)).getRemoteAddr()).map(this::isLocal).orElse(false) != false;
    }

    private boolean isLocal(String addr) {
        return addr != null && (addr.startsWith("127.0.0.") || addr.equals("::1") || addr.equals("0:0:0:0:0:0:0:1"));
    }
}

