/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerListener;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnCoordinateToFileConverter;
import org.talend.sdk.component.design.extension.RepositoryModel;
import org.talend.sdk.component.design.extension.repository.Config;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentActionDao;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.dao.ComponentFamilyDao;
import org.talend.sdk.component.server.dao.ConfigurationDao;
import org.talend.sdk.component.server.service.GlobService;
import org.talend.sdk.component.server.service.VirtualDependenciesService;

@ApplicationScoped
public class ComponentManagerService {
    private static final Logger log = LoggerFactory.getLogger(ComponentManagerService.class);
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentFamilyDao componentFamilyDao;
    @Inject
    private ComponentActionDao actionDao;
    @Inject
    private ConfigurationDao configurationDao;
    @Inject
    private VirtualDependenciesService virtualDependenciesService;
    @Inject
    private GlobService globService;
    private ComponentManager instance;
    private MvnCoordinateToFileConverter mvnCoordinateToFileConverter;
    private DeploymentListener deploymentListener;
    private volatile Date lastUpdated = new Date();

    void startupLoad(@Observes @Initialized(value=ApplicationScoped.class) Object start) {
    }

    @PostConstruct
    private void init() {
        this.configuration.getMavenRepository().ifPresent(repo -> System.setProperty("talend.component.manager.m2.repository", repo));
        this.mvnCoordinateToFileConverter = new MvnCoordinateToFileConverter();
        this.instance = ComponentManager.instance();
        this.deploymentListener = new DeploymentListener(this.componentDao, this.componentFamilyDao, this.actionDao, this.configurationDao, this.virtualDependenciesService);
        this.instance.getContainer().registerListener((ContainerListener)this.deploymentListener);
        List<String> coords = this.configuration.getComponentCoordinates().map(it -> Stream.of(it.split(",")).map(String::trim).filter(i -> !i.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
        coords.forEach(this::deploy);
        this.configuration.getComponentRegistry().map(Collection::stream).orElseGet(Stream::empty).flatMap(this.globService::toFiles).filter(File::exists).forEach(registry -> {
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream((File)registry);){
                properties.load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            properties.stringPropertyNames().stream().map(properties::getProperty).filter(gav -> !coords.contains(gav)).forEach(this::deploy);
        });
    }

    @PreDestroy
    private void destroy() {
        this.instance.getContainer().unregisterListener((ContainerListener)this.deploymentListener);
    }

    public String deploy(String pluginGAV) {
        String pluginPath = Optional.ofNullable(pluginGAV).map(gav -> this.mvnCoordinateToFileConverter.toArtifact(gav)).map(Artifact::toPath).orElseThrow(() -> new IllegalArgumentException("Plugin GAV can't be empty"));
        File m2 = this.instance.getContainer().getRootRepositoryLocation();
        String plugin = this.instance.addWithLocationPlugin(pluginGAV, new File(m2, pluginPath).getAbsolutePath());
        this.lastUpdated = new Date();
        return plugin;
    }

    public void undeploy(String pluginGAV) {
        if (pluginGAV == null || pluginGAV.isEmpty()) {
            throw new IllegalArgumentException("plugin maven GAV are required to undeploy a plugin");
        }
        String pluginID = (String)this.instance.find(c -> pluginGAV.equals(((ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class)).getValue()) ? Stream.of(c.getId()) : Stream.empty()).findFirst().orElseThrow(() -> new IllegalArgumentException("No plugin found using maven GAV: " + pluginGAV));
        this.instance.removePlugin(pluginID);
        this.lastUpdated = new Date();
    }

    public Date findLastUpdated() {
        return this.lastUpdated;
    }

    @Produces
    public ComponentManager manager() {
        return this.instance;
    }

    private static class CleanupTask {
        private final Runnable cleanup;

        public CleanupTask(Runnable cleanup) {
            this.cleanup = cleanup;
        }

        public Runnable getCleanup() {
            return this.cleanup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CleanupTask)) {
                return false;
            }
            CleanupTask other = (CleanupTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Runnable this$cleanup = this.getCleanup();
            Runnable other$cleanup = other.getCleanup();
            return !(this$cleanup == null ? other$cleanup != null : !this$cleanup.equals(other$cleanup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CleanupTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Runnable $cleanup = this.getCleanup();
            result = result * 59 + ($cleanup == null ? 43 : $cleanup.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentManagerService.CleanupTask(cleanup=" + this.getCleanup() + ")";
        }
    }

    private static class DeploymentListener
    implements ContainerListener {
        private final ComponentDao componentDao;
        private final ComponentFamilyDao componentFamilyDao;
        private final ComponentActionDao actionDao;
        private final ConfigurationDao configurationDao;
        private final VirtualDependenciesService virtualDependenciesService;

        public void onCreate(Container container) {
            container.set(CleanupTask.class, (Object)new CleanupTask(this.postDeploy(container)));
        }

        public void onClose(Container container) {
            if (container.getState() == Container.State.ON_ERROR) {
                return;
            }
            Optional.ofNullable(container.get(CleanupTask.class)).ifPresent(c -> c.getCleanup().run());
        }

        private Runnable postDeploy(Container plugin) {
            Collection componentIds = ((ContainerComponentRegistry)plugin.get(ContainerComponentRegistry.class)).getComponents().values().stream().flatMap(c -> Stream.concat(c.getPartitionMappers().values().stream(), c.getProcessors().values().stream())).peek(this.componentDao::createOrUpdate).map(ComponentFamilyMeta.BaseMeta::getId).collect(Collectors.toSet());
            Collection actions = ((ContainerComponentRegistry)plugin.get(ContainerComponentRegistry.class)).getServices().stream().flatMap(c -> c.getActions().stream()).map(this.actionDao::createOrUpdate).collect(Collectors.toList());
            Collection families = ((ContainerComponentRegistry)plugin.get(ContainerComponentRegistry.class)).getComponents().values().stream().map(this.componentFamilyDao::createOrUpdate).collect(Collectors.toList());
            Collection configs = Optional.ofNullable(plugin.get(RepositoryModel.class)).map(r -> r.getFamilies().stream().flatMap(f -> this.configAsStream(((List)f.getConfigs().get()).stream())).collect(Collectors.toList())).orElse(Collections.emptyList()).stream().map(this.configurationDao::createOrUpdate).collect(Collectors.toList());
            return () -> {
                this.virtualDependenciesService.onUnDeploy(plugin);
                componentIds.forEach(this.componentDao::removeById);
                actions.forEach(this.actionDao::removeById);
                families.forEach(this.componentFamilyDao::removeById);
                configs.forEach(this.configurationDao::removeById);
            };
        }

        private Stream<Config> configAsStream(Stream<Config> stream) {
            return stream.flatMap(s -> Stream.concat(Stream.of(s), s.getChildConfigs().stream()));
        }

        public DeploymentListener(ComponentDao componentDao, ComponentFamilyDao componentFamilyDao, ComponentActionDao actionDao, ConfigurationDao configurationDao, VirtualDependenciesService virtualDependenciesService) {
            this.componentDao = componentDao;
            this.componentFamilyDao = componentFamilyDao;
            this.actionDao = actionDao;
            this.configurationDao = configurationDao;
            this.virtualDependenciesService = virtualDependenciesService;
        }
    }
}

