/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.error;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;

@Dependent
@Provider
public class DefaultExceptionHandler
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    @Inject
    private ComponentServerConfiguration configuration;
    private boolean replaceException;

    @PostConstruct
    private void init() {
        this.replaceException = !"false".equalsIgnoreCase(this.configuration.getDefaultExceptionMessage());
    }

    public Response toResponse(Throwable exception) {
        log.error(exception.getMessage(), exception);
        if (WebApplicationException.class.isInstance(exception)) {
            return ((WebApplicationException)WebApplicationException.class.cast(exception)).getResponse();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, this.replaceException ? this.configuration.getDefaultExceptionMessage() : exception.getMessage())).type(MediaType.WILDCARD_TYPE).build();
    }
}

