/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.util.Date;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.talend.sdk.component.server.api.EnvironmentResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.front.model.Environment;
import org.talend.sdk.component.server.service.ComponentManagerService;

@ApplicationScoped
public class EnvironmentResourceImpl
implements EnvironmentResource {
    private final AtomicReference<Environment> environment = new AtomicReference();
    @Inject
    @ConfigProperty(name="git.build.version")
    private String version;
    @Inject
    @ConfigProperty(name="git.commit.id")
    private String commit;
    @Inject
    @ConfigProperty(name="git.build.time")
    private String time;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private Instance<Application> applications;
    @Inject
    private ComponentManagerService service;
    private int latestApiVersion;
    private Date startTime;

    @PostConstruct
    private void init() {
        this.latestApiVersion = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.applications.iterator(), 1024), false).filter(a -> a.getClass().isAnnotationPresent(ApplicationPath.class)).map(a -> a.getClass().getAnnotation(ApplicationPath.class).value()).map(path -> path.replace("api/v", "")).mapToInt(Integer::parseInt).max().orElse(1);
        this.startTime = new Date();
    }

    public Environment get() {
        return new Environment(this.latestApiVersion, this.version, this.commit, this.time, this.configuration.getChangeLastUpdatedAtStartup() != false ? this.findLastUpdated() : this.service.findLastUpdated(), this.service.getConnectorsVersion());
    }

    private Date findLastUpdated() {
        Date lastUpdated = this.service.findLastUpdated();
        return this.startTime.after(lastUpdated) ? this.startTime : lastUpdated;
    }
}

