/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.lang.Substitutor;
import org.apache.meecrowave.runner.cli.CliOption;
import org.apache.meecrowave.service.Priotities;
import org.apache.webbeans.config.PropertyLoader;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class Configuration {
    @CliOption(name="pid-file", description="A file path to write the process id if the server starts")
    private File pidFile;
    @CliOption(name="watcher-bouncing", description="Activate redeployment on directories update using this bouncing.")
    private int watcherBouncing = 500;
    @CliOption(name="http", description="HTTP port")
    private int httpPort = 8080;
    @CliOption(name="https", description="HTTPS port")
    private int httpsPort = 8443;
    @CliOption(name="stop", description="Shutdown port if used or -1")
    private int stopPort = -1;
    @CliOption(name="host", description="Default host")
    private String host = "localhost";
    @CliOption(name="dir", description="Root folder if provided otherwise a fake one is created in tmp-dir")
    private String dir;
    @CliOption(name="server-xml", description="Provided server.xml")
    private File serverXml;
    @CliOption(name="keep-server-xml-as-this", description="Don't replace ports in server.xml")
    private boolean keepServerXmlAsThis;
    @CliOption(name="properties", description="Passthrough properties")
    private Properties properties = new Properties();
    @CliOption(name="quick-session", description="Should an unsecured but fast session id generator be used")
    private boolean quickSession = true;
    @CliOption(name="skip-http", description="Skip HTTP connector")
    private boolean skipHttp;
    @CliOption(name="ssl", description="Use HTTPS")
    private boolean ssl;
    @CliOption(name="keystore-file", description="HTTPS keystore location")
    private String keystoreFile;
    @CliOption(name="keystore-password", description="HTTPS keystore password")
    private String keystorePass;
    @CliOption(name="keystore-type", description="HTTPS keystore type")
    private String keystoreType = "JKS";
    @CliOption(name="client-auth", description="HTTPS keystore client authentication")
    private String clientAuth;
    @CliOption(name="keystore-alias", description="HTTPS keystore alias")
    private String keyAlias;
    @CliOption(name="ssl-protocol", description="HTTPS protocol")
    private String sslProtocol;
    @CliOption(name="web-xml", description="Global web.xml")
    private String webXml;
    @CliOption(name="login-config", description="web.xml login config")
    private Meecrowave.LoginConfigBuilder loginConfig;
    @CliOption(name="security-constraint", description="web.xml security constraint")
    private Collection<Meecrowave.SecurityConstaintBuilder> securityConstraints = new LinkedList<Meecrowave.SecurityConstaintBuilder>();
    @CliOption(name="realm", description="realm")
    private Realm realm;
    @CliOption(name="users", description="In memory users")
    private Map<String, String> users;
    @CliOption(name="roles", description="In memory roles")
    private Map<String, String> roles;
    @CliOption(name="http2", description="Activate HTTP 2")
    private boolean http2;
    @CliOption(name="connector", description="Custom connectors")
    private final Collection<Connector> connectors = new ArrayList<Connector>();
    @CliOption(name="tmp-dir", description="Temporary directory")
    private String tempDir = System.getProperty("java.io.tmpdir");
    @CliOption(name="web-resource-cached", description="Cache web resources")
    private boolean webResourceCached = true;
    @CliOption(name="conf", description="Conf folder to synchronize")
    private String conf;
    @CliOption(name="delete-on-startup", description="Should the directory be cleaned on startup if existing")
    private boolean deleteBaseOnStartup = true;
    @CliOption(name="jaxrs-mapping", description="Default jaxrs mapping")
    private String jaxrsMapping = "/*";
    @CliOption(name="cdi-conversation", description="Should CDI conversation be activated")
    private boolean cdiConversation;
    @CliOption(name="jaxrs-provider-setup", description="Should default JAX-RS provider be configured")
    private boolean jaxrsProviderSetup = true;
    @CliOption(name="jaxrs-default-providers", description="If jaxrsProviderSetup is true the list of default providers to load (or defaulting to johnson jsonb and jsonp ones)")
    private String jaxrsDefaultProviders;
    @CliOption(name="jaxrs-beanvalidation", description="Should bean validation be activated on JAX-RS endpoint if present in the classpath.")
    private boolean jaxrsAutoActivateBeanValidation = true;
    @CliOption(name="jaxrs-log-provider", description="Should JAX-RS providers be logged")
    private boolean jaxrsLogProviders = false;
    @CliOption(name="jsonp-buffer-strategy", description="JSON-P JAX-RS provider buffer strategy (see johnzon)")
    private String jsonpBufferStrategy = "QUEUE";
    @CliOption(name="jsonp-max-string-length", description="JSON-P JAX-RS provider max string limit size (see johnzon)")
    private int jsonpMaxStringLen = 65536;
    @CliOption(name="jsonp-read-buffer-length", description="JSON-P JAX-RS provider read buffer limit size (see johnzon)")
    private int jsonpMaxReadBufferLen = 65536;
    @CliOption(name="jsonp-write-buffer-length", description="JSON-P JAX-RS provider write buffer limit size (see johnzon)")
    private int jsonpMaxWriteBufferLen = 65536;
    @CliOption(name="jsonp-supports-comment", description="Should JSON-P JAX-RS provider support comments (see johnzon)")
    private boolean jsonpSupportsComment = false;
    @CliOption(name="jsonp-supports-comment", description="Should JSON-P JAX-RS provider prettify the outputs (see johnzon)")
    private boolean jsonpPrettify = false;
    @CliOption(name="jsonb-encoding", description="Which encoding provider JSON-B should use")
    private String jsonbEncoding = "UTF-8";
    @CliOption(name="jsonb-nulls", description="Should JSON-B provider serialize nulls")
    private boolean jsonbNulls = false;
    @CliOption(name="jsonb-ijson", description="Should JSON-B provider comply to I-JSON")
    private boolean jsonbIJson = false;
    @CliOption(name="jsonb-prettify", description="Should JSON-B provider prettify the output")
    private boolean jsonbPrettify = false;
    @CliOption(name="jsonb-binary-strategy", description="Should JSON-B provider prettify the output")
    private String jsonbBinaryStrategy;
    @CliOption(name="jsonb-naming-strategy", description="Should JSON-B provider prettify the output")
    private String jsonbNamingStrategy;
    @CliOption(name="jsonb-order-strategy", description="Should JSON-B provider prettify the output")
    private String jsonbOrderStrategy;
    @CliOption(name="logging-global-setup", description="Should logging be configured to use log4j2 (it is global)")
    private boolean loggingGlobalSetup = true;
    @CliOption(name="cxf-servlet-params", description="Init parameters passed to CXF servlet")
    private Map<String, String> cxfServletParams;
    @CliOption(name="tomcat-scanning", description="Should Tomcat scanning be used (@HandleTypes, @WebXXX)")
    private boolean tomcatScanning = true;
    @CliOption(name="tomcat-default-setup", description="Add default servlet")
    private boolean tomcatAutoSetup = true;
    @CliOption(name="tomcat-default-setup-jsp-development", description="Should JSP support if available be set in development mode")
    private boolean tomcatJspDevelopment = false;
    @CliOption(name="use-shutdown-hook", description="Use shutdown hook to automatically stop the container on Ctrl+C")
    private boolean useShutdownHook = true;
    @CliOption(name="tomcat-filter", description="A Tomcat JarScanFilter")
    private String tomcatFilter;
    @CliOption(name="scanning-include", description="A forced include list of jar names (comma separated values)")
    private String scanningIncludes;
    @CliOption(name="scanning-exclude", description="A forced exclude list of jar names (comma separated values)")
    private String scanningExcludes;
    @CliOption(name="scanning-package-include", description="A forced include list of packages names (comma separated values)")
    private String scanningPackageIncludes;
    @CliOption(name="scanning-package-exclude", description="A forced exclude list of packages names (comma separated values)")
    private String scanningPackageExcludes;
    @CliOption(name="web-session-timeout", description="Force the session timeout for webapps")
    private Integer webSessionTimeout;
    @CliOption(name="web-session-cookie-config", description="Force the cookie-config, it uses a properties syntax with the keys being the web.xml tag names.")
    private String webSessionCookieConfig;
    @CliOption(name="tomcat-default", description="Should Tomcat default be set (session timeout, mime mapping etc...)")
    private boolean useTomcatDefaults = true;
    @CliOption(name="tomcat-wrap-loader", description="(Experimental) When deploying a classpath (current classloader), should meecrowave wrap the loader to define another loader identity but still use the same classes and resources.")
    private boolean tomcatWrapLoader = false;
    @CliOption(name="tomcat-skip-jmx", description="(Experimental) Should Tomcat MBeans be skipped.")
    private boolean tomcatNoJmx = true;
    @CliOption(name="shared-libraries", description="A folder containing shared libraries.", alias={"shared-librairies"})
    private String sharedLibraries;
    @CliOption(name="log4j2-jul-bridge", description="Should JUL logs be redirected to Log4j2 - only works before JUL usage.")
    private boolean useLog4j2JulLogManager = System.getProperty("java.util.logging.manager") == null;
    @CliOption(name="servlet-container-initializer-injection", description="Should ServletContainerInitialize support injections.")
    private boolean injectServletContainerInitializer = true;
    @CliOption(name="tomcat-access-log-pattern", description="Activates and configure the access log valve. Value example: '%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"'")
    private String tomcatAccessLogPattern;
    @CliOption(name="meecrowave-properties", description="Loads a meecrowave properties, defaults to meecrowave.properties.")
    private String meecrowaveProperties = "meecrowave.properties";
    @CliOption(name="jaxws-support-if-present", description="Should @WebService CDI beans be deployed if cxf-rt-frontend-jaxws is in the classpath.")
    private boolean jaxwsSupportIfAvailable = true;
    @CliOption(name="default-ssl-hostconfig-name", description="The name of the default SSLHostConfig that will be used for secure https connections.")
    private String defaultSSLHostConfigName;
    @CliOption(name="cxf-initialize-client-bus", description="Should the client bus be set. If false the server one will likely be reused.")
    private boolean initializeClientBus = true;
    private final Map<Class<?>, Object> extensions = new HashMap();
    private final Collection<Consumer<Tomcat>> instanceCustomizers = new ArrayList<Consumer<Tomcat>>();
    @CliOption(name="servlet-container-initializer", description="ServletContainerInitializer instances.")
    private Collection<ServletContainerInitializer> initializers = new ArrayList<ServletContainerInitializer>();
    @CliOption(name="tomcat-antiresourcelocking", description="Should Tomcat anti resource locking feature be activated on StandardContext.")
    private boolean antiResourceLocking;
    @CliOption(name="tomcat-context-configurer", description="Configurers for all webapps. The Consumer<Context> instances will be applied to all deployments.")
    private Collection<Consumer<Context>> contextConfigurers;

    public Configuration(Configuration toCopy) {
        this.pidFile = toCopy.pidFile;
        this.watcherBouncing = toCopy.watcherBouncing;
        this.httpPort = toCopy.httpPort;
        this.httpsPort = toCopy.httpsPort;
        this.stopPort = toCopy.stopPort;
        this.host = toCopy.host;
        this.dir = toCopy.dir;
        this.serverXml = toCopy.serverXml;
        this.keepServerXmlAsThis = toCopy.keepServerXmlAsThis;
        this.properties = toCopy.properties;
        this.quickSession = toCopy.quickSession;
        this.skipHttp = toCopy.skipHttp;
        this.ssl = toCopy.ssl;
        this.keystoreFile = toCopy.keystoreFile;
        this.keystorePass = toCopy.keystorePass;
        this.keystoreType = toCopy.keystoreType;
        this.clientAuth = toCopy.clientAuth;
        this.keyAlias = toCopy.keyAlias;
        this.sslProtocol = toCopy.sslProtocol;
        this.webXml = toCopy.webXml;
        this.loginConfig = toCopy.loginConfig;
        this.securityConstraints = toCopy.securityConstraints;
        this.realm = toCopy.realm;
        this.users = toCopy.users;
        this.roles = toCopy.roles;
        this.http2 = toCopy.http2;
        this.connectors.addAll(toCopy.connectors);
        this.tempDir = toCopy.tempDir;
        this.webResourceCached = toCopy.webResourceCached;
        this.conf = toCopy.conf;
        this.deleteBaseOnStartup = toCopy.deleteBaseOnStartup;
        this.jaxrsMapping = toCopy.jaxrsMapping;
        this.cdiConversation = toCopy.cdiConversation;
        this.jaxrsProviderSetup = toCopy.jaxrsProviderSetup;
        this.jaxrsDefaultProviders = toCopy.jaxrsDefaultProviders;
        this.jaxrsAutoActivateBeanValidation = toCopy.jaxrsAutoActivateBeanValidation;
        this.jaxrsLogProviders = toCopy.jaxrsLogProviders;
        this.jsonpBufferStrategy = toCopy.jsonpBufferStrategy;
        this.jsonpMaxStringLen = toCopy.jsonpMaxStringLen;
        this.jsonpMaxReadBufferLen = toCopy.jsonpMaxReadBufferLen;
        this.jsonpMaxWriteBufferLen = toCopy.jsonpMaxWriteBufferLen;
        this.jsonpSupportsComment = toCopy.jsonpSupportsComment;
        this.jsonpPrettify = toCopy.jsonpPrettify;
        this.jsonbEncoding = toCopy.jsonbEncoding;
        this.jsonbNulls = toCopy.jsonbNulls;
        this.jsonbIJson = toCopy.jsonbIJson;
        this.jsonbPrettify = toCopy.jsonbPrettify;
        this.jsonbBinaryStrategy = toCopy.jsonbBinaryStrategy;
        this.jsonbNamingStrategy = toCopy.jsonbNamingStrategy;
        this.jsonbOrderStrategy = toCopy.jsonbOrderStrategy;
        this.loggingGlobalSetup = toCopy.loggingGlobalSetup;
        this.cxfServletParams = toCopy.cxfServletParams;
        this.tomcatScanning = toCopy.tomcatScanning;
        this.tomcatAutoSetup = toCopy.tomcatAutoSetup;
        this.tomcatJspDevelopment = toCopy.tomcatJspDevelopment;
        this.useShutdownHook = toCopy.useShutdownHook;
        this.tomcatFilter = toCopy.tomcatFilter;
        this.scanningIncludes = toCopy.scanningIncludes;
        this.scanningExcludes = toCopy.scanningExcludes;
        this.scanningPackageIncludes = toCopy.scanningPackageIncludes;
        this.scanningPackageExcludes = toCopy.scanningPackageExcludes;
        this.webSessionTimeout = toCopy.webSessionTimeout;
        this.webSessionCookieConfig = toCopy.webSessionCookieConfig;
        this.useTomcatDefaults = toCopy.useTomcatDefaults;
        this.tomcatWrapLoader = toCopy.tomcatWrapLoader;
        this.tomcatNoJmx = toCopy.tomcatNoJmx;
        this.sharedLibraries = toCopy.sharedLibraries;
        this.useLog4j2JulLogManager = toCopy.useLog4j2JulLogManager;
        this.injectServletContainerInitializer = toCopy.injectServletContainerInitializer;
        this.tomcatAccessLogPattern = toCopy.tomcatAccessLogPattern;
        this.meecrowaveProperties = toCopy.meecrowaveProperties;
        this.jaxwsSupportIfAvailable = toCopy.jaxwsSupportIfAvailable;
        this.defaultSSLHostConfigName = toCopy.defaultSSLHostConfigName;
        this.initializeClientBus = toCopy.initializeClientBus;
        this.extensions.putAll(toCopy.extensions);
        this.instanceCustomizers.addAll(toCopy.instanceCustomizers);
        this.initializers = toCopy.initializers;
        this.antiResourceLocking = toCopy.antiResourceLocking;
        this.contextConfigurers = toCopy.contextConfigurers;
    }

    public Configuration() {
        this.extensions.put(Meecrowave.ValueTransformers.class, new Meecrowave.ValueTransformers());
        StreamSupport.stream(ServiceLoader.load(Meecrowave.ConfigurationCustomizer.class).spliterator(), false).sorted(Priotities::sortByPriority).forEach(c -> c.accept(this));
        this.loadFrom(this.meecrowaveProperties);
    }

    public Collection<Consumer<Tomcat>> getInstanceCustomizers() {
        return this.instanceCustomizers;
    }

    public <T> T getExtension(Class<T> extension) {
        return extension.cast(this.extensions.computeIfAbsent(extension, k -> {
            try {
                return this.bind(k.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }

    public boolean isAntiResourceLocking() {
        return this.antiResourceLocking;
    }

    public void setAntiResourceLocking(boolean antiResourceLocking) {
        this.antiResourceLocking = antiResourceLocking;
    }

    public Collection<Consumer<Context>> getGlobalContextConfigurers() {
        return Optional.ofNullable(this.contextConfigurers).orElseGet(Collections::emptySet);
    }

    public boolean isTomcatJspDevelopment() {
        return this.tomcatJspDevelopment;
    }

    public void setTomcatJspDevelopment(boolean tomcatJspDevelopment) {
        this.tomcatJspDevelopment = tomcatJspDevelopment;
    }

    public Integer getWebSessionTimeout() {
        return this.webSessionTimeout;
    }

    public void setWebSessionTimeout(Integer webSessionTimeout) {
        this.webSessionTimeout = webSessionTimeout;
    }

    public String getWebSessionCookieConfig() {
        return this.webSessionCookieConfig;
    }

    public void setWebSessionCookieConfig(String webSessionCookieConfig) {
        this.webSessionCookieConfig = webSessionCookieConfig;
    }

    public boolean isInitializeClientBus() {
        return this.initializeClientBus;
    }

    public void setInitializeClientBus(boolean initializeClientBus) {
        this.initializeClientBus = initializeClientBus;
    }

    public boolean isJaxwsSupportIfAvailable() {
        return this.jaxwsSupportIfAvailable;
    }

    public void setJaxwsSupportIfAvailable(boolean jaxwsSupportIfAvailable) {
        this.jaxwsSupportIfAvailable = jaxwsSupportIfAvailable;
    }

    public int getWatcherBouncing() {
        return this.watcherBouncing;
    }

    public void setWatcherBouncing(int watcherBouncing) {
        this.watcherBouncing = watcherBouncing;
    }

    public String getTomcatAccessLogPattern() {
        return this.tomcatAccessLogPattern;
    }

    public void setTomcatAccessLogPattern(String tomcatAccessLogPattern) {
        this.tomcatAccessLogPattern = tomcatAccessLogPattern;
    }

    public boolean isTomcatNoJmx() {
        return this.tomcatNoJmx;
    }

    public void setTomcatNoJmx(boolean tomcatNoJmx) {
        this.tomcatNoJmx = tomcatNoJmx;
    }

    public File getPidFile() {
        return this.pidFile;
    }

    public void setPidFile(File pidFile) {
        this.pidFile = pidFile;
    }

    public String getScanningPackageIncludes() {
        return this.scanningPackageIncludes;
    }

    public void setScanningPackageIncludes(String scanningPackageIncludes) {
        this.scanningPackageIncludes = scanningPackageIncludes;
    }

    public String getScanningPackageExcludes() {
        return this.scanningPackageExcludes;
    }

    public void setScanningPackageExcludes(String scanningPackageExcludes) {
        this.scanningPackageExcludes = scanningPackageExcludes;
    }

    public void setExtension(Class<?> type, Object value) {
        this.extensions.put(type, value);
    }

    public String getScanningIncludes() {
        return this.scanningIncludes;
    }

    public void setScanningIncludes(String scanningIncludes) {
        this.scanningIncludes = scanningIncludes;
    }

    public String getScanningExcludes() {
        return this.scanningExcludes;
    }

    public void setScanningExcludes(String scanningExcludes) {
        this.scanningExcludes = scanningExcludes;
    }

    public String getJsonpBufferStrategy() {
        return this.jsonpBufferStrategy;
    }

    public String getJsonbEncoding() {
        return this.jsonbEncoding;
    }

    public void setJsonbEncoding(String jsonbEncoding) {
        this.jsonbEncoding = jsonbEncoding;
    }

    public boolean isJsonbNulls() {
        return this.jsonbNulls;
    }

    public void setJsonbNulls(boolean jsonbNulls) {
        this.jsonbNulls = jsonbNulls;
    }

    public boolean isJsonbIJson() {
        return this.jsonbIJson;
    }

    public void setJsonbIJson(boolean jsonbIJson) {
        this.jsonbIJson = jsonbIJson;
    }

    public boolean isJsonbPrettify() {
        return this.jsonbPrettify;
    }

    public void setJsonbPrettify(boolean jsonbPrettify) {
        this.jsonbPrettify = jsonbPrettify;
    }

    public String getJsonbBinaryStrategy() {
        return this.jsonbBinaryStrategy;
    }

    public void setJsonbBinaryStrategy(String jsonbBinaryStrategy) {
        this.jsonbBinaryStrategy = jsonbBinaryStrategy;
    }

    public String getJsonbNamingStrategy() {
        return this.jsonbNamingStrategy;
    }

    public void setJsonbNamingStrategy(String jsonbNamingStrategy) {
        this.jsonbNamingStrategy = jsonbNamingStrategy;
    }

    public String getJsonbOrderStrategy() {
        return this.jsonbOrderStrategy;
    }

    public void setJsonbOrderStrategy(String jsonbOrderStrategy) {
        this.jsonbOrderStrategy = jsonbOrderStrategy;
    }

    public void setJsonpBufferStrategy(String jsonpBufferStrategy) {
        this.jsonpBufferStrategy = jsonpBufferStrategy;
    }

    public int getJsonpMaxStringLen() {
        return this.jsonpMaxStringLen;
    }

    public void setJsonpMaxStringLen(int jsonpMaxStringLen) {
        this.jsonpMaxStringLen = jsonpMaxStringLen;
    }

    public int getJsonpMaxReadBufferLen() {
        return this.jsonpMaxReadBufferLen;
    }

    public void setJsonpMaxReadBufferLen(int jsonpMaxReadBufferLen) {
        this.jsonpMaxReadBufferLen = jsonpMaxReadBufferLen;
    }

    public int getJsonpMaxWriteBufferLen() {
        return this.jsonpMaxWriteBufferLen;
    }

    public void setJsonpMaxWriteBufferLen(int jsonpMaxWriteBufferLen) {
        this.jsonpMaxWriteBufferLen = jsonpMaxWriteBufferLen;
    }

    public boolean isJsonpSupportsComment() {
        return this.jsonpSupportsComment;
    }

    public void setJsonpSupportsComment(boolean jsonpSupportsComment) {
        this.jsonpSupportsComment = jsonpSupportsComment;
    }

    public boolean isJsonpPrettify() {
        return this.jsonpPrettify;
    }

    public void setJsonpPrettify(boolean jsonpPrettify) {
        this.jsonpPrettify = jsonpPrettify;
    }

    public String getSharedLibraries() {
        return this.sharedLibraries;
    }

    public void setSharedLibraries(String sharedLibraries) {
        this.sharedLibraries = sharedLibraries;
    }

    public boolean isJaxrsLogProviders() {
        return this.jaxrsLogProviders;
    }

    public void setJaxrsLogProviders(boolean jaxrsLogProviders) {
        this.jaxrsLogProviders = jaxrsLogProviders;
    }

    public boolean isUseTomcatDefaults() {
        return this.useTomcatDefaults;
    }

    public void setUseTomcatDefaults(boolean useTomcatDefaults) {
        this.useTomcatDefaults = useTomcatDefaults;
    }

    public String getTomcatFilter() {
        return this.tomcatFilter;
    }

    public void setTomcatFilter(String tomcatFilter) {
        this.tomcatFilter = tomcatFilter;
    }

    public boolean isTomcatScanning() {
        return this.tomcatScanning;
    }

    public void setTomcatScanning(boolean tomcatScanning) {
        this.tomcatScanning = tomcatScanning;
    }

    public Map<String, String> getCxfServletParams() {
        return this.cxfServletParams;
    }

    public void setCxfServletParams(Map<String, String> cxfServletParams) {
        this.cxfServletParams = cxfServletParams;
    }

    public boolean isLoggingGlobalSetup() {
        return this.loggingGlobalSetup;
    }

    public void setLoggingGlobalSetup(boolean loggingGlobalSetup) {
        this.loggingGlobalSetup = loggingGlobalSetup;
    }

    public boolean isJaxrsAutoActivateBeanValidation() {
        return this.jaxrsAutoActivateBeanValidation;
    }

    public void setJaxrsAutoActivateBeanValidation(boolean jaxrsAutoActivateBeanValidation) {
        this.jaxrsAutoActivateBeanValidation = jaxrsAutoActivateBeanValidation;
    }

    public boolean isJaxrsProviderSetup() {
        return this.jaxrsProviderSetup;
    }

    public void setJaxrsProviderSetup(boolean jaxrsProviderSetup) {
        this.jaxrsProviderSetup = jaxrsProviderSetup;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public File getServerXml() {
        return this.serverXml;
    }

    public void setServerXml(File serverXml) {
        this.serverXml = serverXml;
    }

    public boolean isKeepServerXmlAsThis() {
        return this.keepServerXmlAsThis;
    }

    public void setKeepServerXmlAsThis(boolean keepServerXmlAsThis) {
        this.keepServerXmlAsThis = keepServerXmlAsThis;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isQuickSession() {
        return this.quickSession;
    }

    public void setQuickSession(boolean quickSession) {
        this.quickSession = quickSession;
    }

    public boolean isSkipHttp() {
        return this.skipHttp;
    }

    public void setSkipHttp(boolean skipHttp) {
        this.skipHttp = skipHttp;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getWebXml() {
        return this.webXml;
    }

    public void setWebXml(String webXml) {
        this.webXml = webXml;
    }

    public Meecrowave.LoginConfigBuilder getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(Meecrowave.LoginConfigBuilder loginConfig) {
        this.loginConfig = loginConfig;
    }

    public Collection<Meecrowave.SecurityConstaintBuilder> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setSecurityConstraints(Collection<Meecrowave.SecurityConstaintBuilder> securityConstraints) {
        this.securityConstraints = securityConstraints;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public Map<String, String> getUsers() {
        return this.users;
    }

    public void setUsers(Map<String, String> users) {
        this.users = users;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public boolean isHttp2() {
        return this.http2;
    }

    public void setHttp2(boolean http2) {
        this.http2 = http2;
    }

    public Collection<Connector> getConnectors() {
        return this.connectors;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public boolean isWebResourceCached() {
        return this.webResourceCached;
    }

    public void setWebResourceCached(boolean webResourceCached) {
        this.webResourceCached = webResourceCached;
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public boolean isDeleteBaseOnStartup() {
        return this.deleteBaseOnStartup;
    }

    public void setDeleteBaseOnStartup(boolean deleteBaseOnStartup) {
        this.deleteBaseOnStartup = deleteBaseOnStartup;
    }

    public String getJaxrsMapping() {
        return this.jaxrsMapping;
    }

    public void setJaxrsMapping(String jaxrsMapping) {
        this.jaxrsMapping = jaxrsMapping;
    }

    public boolean isCdiConversation() {
        return this.cdiConversation;
    }

    public void setCdiConversation(boolean cdiConversation) {
        this.cdiConversation = cdiConversation;
    }

    public void setServerXml(String file) {
        if (file == null) {
            this.serverXml = null;
        } else {
            File sXml = new File(file);
            if (sXml.exists()) {
                this.serverXml = sXml;
            }
        }
    }

    public String getActiveProtocol() {
        return this.isSkipHttp() ? "https" : "http";
    }

    public int getActivePort() {
        return this.isSkipHttp() ? this.getHttpsPort() : this.getHttpPort();
    }

    public boolean isTomcatAutoSetup() {
        return this.tomcatAutoSetup;
    }

    public void setTomcatAutoSetup(boolean tomcatAutoSetup) {
        this.tomcatAutoSetup = tomcatAutoSetup;
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean isTomcatWrapLoader() {
        return this.tomcatWrapLoader;
    }

    public void setTomcatWrapLoader(boolean tomcatWrapLoader) {
        this.tomcatWrapLoader = tomcatWrapLoader;
    }

    public void addInstanceCustomizer(Consumer<Tomcat> customizer) {
        this.instanceCustomizers.add(customizer);
    }

    public void addCustomizer(Consumer<Configuration> configurationCustomizer) {
        configurationCustomizer.accept(this);
    }

    public void addGlobalContextCustomizer(Consumer<Context> contextConfigurer) {
        if (this.contextConfigurers == null) {
            this.contextConfigurers = new ArrayList<Consumer<Context>>();
        }
        this.contextConfigurers.add(contextConfigurer);
    }

    public void addServletContextInitializer(ServletContainerInitializer initializer) {
        this.initializers.add(initializer);
    }

    public Collection<ServletContainerInitializer> getInitializers() {
        return this.initializers;
    }

    public String getJaxrsDefaultProviders() {
        return this.jaxrsDefaultProviders;
    }

    public void setJaxrsDefaultProviders(String jaxrsDefaultProviders) {
        this.jaxrsDefaultProviders = jaxrsDefaultProviders;
    }

    public boolean isUseLog4j2JulLogManager() {
        return this.useLog4j2JulLogManager;
    }

    public void setUseLog4j2JulLogManager(boolean useLog4j2JulLogManager) {
        this.useLog4j2JulLogManager = useLog4j2JulLogManager;
    }

    public String getDefaultSSLHostConfigName() {
        return this.defaultSSLHostConfigName;
    }

    public void setDefaultSSLHostConfigName(String defaultSSLHostConfigName) {
        this.defaultSSLHostConfigName = defaultSSLHostConfigName;
    }

    public void loadFromProperties(final Properties config) {
        Substitutor strSubstitutor = new Substitutor(Collections.emptyMap()){

            @Override
            public String getOrDefault(String key, String or) {
                String property = System.getProperty(key);
                return property == null ? config.getProperty(key, or) : or;
            }
        };
        Meecrowave.ValueTransformers transformers = this.getExtension(Meecrowave.ValueTransformers.class);
        for (String key : config.stringPropertyNames()) {
            String newVal;
            String val2 = config.getProperty(key);
            if (val2 == null || val2.trim().isEmpty() || val2.equals(newVal = transformers.apply(strSubstitutor.replace(config.getProperty(key))))) continue;
            config.setProperty(key, newVal);
        }
        for (Field field : Configuration.class.getDeclaredFields()) {
            CliOption annotation = field.getAnnotation(CliOption.class);
            if (annotation == null) continue;
            String name = field.getName();
            Stream.of(Stream.of(annotation.name()), Stream.of(annotation.alias())).flatMap(a -> a).map(config::getProperty).filter(Objects::nonNull).findAny().ifPresent(val -> {
                Comparable<File> toSet;
                if (field.getType() == String.class) {
                    toSet = val;
                } else if (field.getType() == Integer.TYPE) {
                    if ("httpPort".equals(name) && "-1".equals(val)) {
                        try (ServerSocket serverSocket = new ServerSocket(0);){
                            this.setHttpPort(serverSocket.getLocalPort());
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                        toSet = null;
                    } else {
                        toSet = Integer.parseInt(val);
                    }
                } else {
                    toSet = field.getType() == Boolean.TYPE ? Boolean.valueOf(Boolean.parseBoolean(val)) : (field.getType() == File.class ? new File((String)val) : (field.getType() == Long.TYPE ? Long.valueOf(Long.parseLong(val)) : null));
                }
                if (toSet == null) {
                    return;
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(this, toSet);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        for (String prop : config.stringPropertyNames()) {
            if (prop.startsWith("properties.")) {
                this.getProperties().setProperty(prop.substring("properties.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("users.")) {
                if (this.users == null) {
                    this.users = new HashMap<String, String>();
                }
                this.users.put(prop.substring("users.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("roles.")) {
                if (this.roles == null) {
                    this.roles = new HashMap<String, String>();
                }
                this.roles.put(prop.substring("roles.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("cxf.servlet.params.")) {
                if (this.cxfServletParams == null) {
                    this.cxfServletParams = new HashMap<String, String>();
                }
                this.cxfServletParams.put(prop.substring("cxf.servlet.params.".length()), config.getProperty(prop));
                continue;
            }
            if (prop.startsWith("connector.")) {
                this.getProperties().setProperty(prop, config.getProperty(prop));
                continue;
            }
            if (prop.equals("realm")) {
                ObjectRecipe recipe = Configuration.newRecipe(config.getProperty(prop));
                for (String realmConfig : config.stringPropertyNames()) {
                    if (!realmConfig.startsWith("realm.")) continue;
                    recipe.setProperty(realmConfig.substring("realm.".length()), (Object)config.getProperty(realmConfig));
                }
                this.realm = (Realm)Realm.class.cast(recipe.create());
                continue;
            }
            if (prop.equals("login")) {
                ObjectRecipe recipe = Configuration.newRecipe(Meecrowave.LoginConfigBuilder.class.getName());
                for (String nestedConfig : config.stringPropertyNames()) {
                    if (!nestedConfig.startsWith("login.")) continue;
                    recipe.setProperty(nestedConfig.substring("login.".length()), (Object)config.getProperty(nestedConfig));
                }
                this.loginConfig = (Meecrowave.LoginConfigBuilder)Meecrowave.LoginConfigBuilder.class.cast(recipe.create());
                continue;
            }
            if (prop.equals("securityConstraint")) {
                ObjectRecipe recipe = Configuration.newRecipe(Meecrowave.SecurityConstaintBuilder.class.getName());
                for (String nestedConfig : config.stringPropertyNames()) {
                    if (!nestedConfig.startsWith("securityConstraint.")) continue;
                    recipe.setProperty(nestedConfig.substring("securityConstraint.".length()), (Object)config.getProperty(nestedConfig));
                }
                this.securityConstraints.add((Meecrowave.SecurityConstaintBuilder)Meecrowave.SecurityConstaintBuilder.class.cast(recipe.create()));
                continue;
            }
            if (!prop.equals("configurationCustomizer")) continue;
            ObjectRecipe recipe = Configuration.newRecipe(prop);
            for (String nestedConfig : config.stringPropertyNames()) {
                if (!nestedConfig.startsWith(prop + '.')) continue;
                recipe.setProperty(nestedConfig.substring(prop.length() + 2), (Object)config.getProperty(nestedConfig));
            }
            this.addCustomizer((Consumer)Consumer.class.cast(recipe.create()));
        }
    }

    public <T> T bind(T instance) {
        Meecrowave.ValueTransformers transformers = this.getExtension(Meecrowave.ValueTransformers.class);
        Class<?> type = instance.getClass();
        do {
            Stream.of(type.getDeclaredFields()).filter(f -> f.isAnnotationPresent(CliOption.class)).forEach(f -> {
                block9: {
                    CliOption annotation = f.getAnnotation(CliOption.class);
                    String value = this.properties.getProperty(annotation.name());
                    if (value == null) {
                        value = Stream.of(annotation.alias()).map(this.properties::getProperty).findFirst().orElse(null);
                        if (value == null) {
                            return;
                        }
                    }
                    value = transformers.apply(value);
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    Class<?> t = f.getType();
                    try {
                        if (t == String.class) {
                            f.set(instance, value);
                            break block9;
                        }
                        if (t == Integer.TYPE) {
                            f.set(instance, Integer.parseInt(value));
                            break block9;
                        }
                        if (t == Long.TYPE) {
                            f.set(instance, Long.parseLong(value));
                            break block9;
                        }
                        if (t == Boolean.TYPE) {
                            f.set(instance, Boolean.parseBoolean(value));
                            break block9;
                        }
                        throw new IllegalArgumentException("Unsupported type " + t);
                    }
                    catch (IllegalAccessException iae) {
                        throw new IllegalStateException(iae);
                    }
                }
            });
        } while ((type = type.getSuperclass()) != Object.class);
        return instance;
    }

    public boolean isInjectServletContainerInitializer() {
        return this.injectServletContainerInitializer;
    }

    public void setInjectServletContainerInitializer(boolean injectServletContainerInitializer) {
        this.injectServletContainerInitializer = injectServletContainerInitializer;
    }

    public String getMeecrowaveProperties() {
        return this.meecrowaveProperties;
    }

    public void setMeecrowaveProperties(String meecrowaveProperties) {
        this.meecrowaveProperties = meecrowaveProperties;
    }

    private Properties mergeProperties(String resource, List<Properties> sortedProperties) {
        Properties mergedProperties = new Properties();
        Properties master = null;
        for (Properties p : sortedProperties) {
            if (Boolean.parseBoolean(p.getProperty("configuration.complete", "false"))) {
                if (master != null) {
                    throw new IllegalArgumentException("Ambiguous '" + resource + "', multiple " + resource + " with configuration.complete=true");
                }
                master = p;
            }
            mergedProperties.putAll((Map<?, ?>)p);
        }
        if (master != null) {
            return master;
        }
        return mergedProperties;
    }

    public Configuration loadFrom(String resource) {
        File file;
        Properties config = PropertyLoader.getProperties((String)resource, sortedProperties -> this.mergeProperties(resource, (List<Properties>)sortedProperties), () -> {});
        if ((config == null || config.isEmpty()) && (file = new File(resource)).exists()) {
            config = new Properties();
            try (FileInputStream is = new FileInputStream(file);){
                config.load(is);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (config != null) {
            this.loadFromProperties(config);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!Configuration.class.isInstance(o)) {
            return false;
        }
        Configuration that = (Configuration)Configuration.class.cast(o);
        return this.watcherBouncing == that.watcherBouncing && this.httpPort == that.httpPort && this.httpsPort == that.httpsPort && this.stopPort == that.stopPort && this.keepServerXmlAsThis == that.keepServerXmlAsThis && this.quickSession == that.quickSession && this.skipHttp == that.skipHttp && this.ssl == that.ssl && this.http2 == that.http2 && this.webResourceCached == that.webResourceCached && this.deleteBaseOnStartup == that.deleteBaseOnStartup && this.cdiConversation == that.cdiConversation && this.jaxrsProviderSetup == that.jaxrsProviderSetup && this.jaxrsAutoActivateBeanValidation == that.jaxrsAutoActivateBeanValidation && this.jaxrsLogProviders == that.jaxrsLogProviders && this.jsonpMaxStringLen == that.jsonpMaxStringLen && this.jsonpMaxReadBufferLen == that.jsonpMaxReadBufferLen && this.jsonpMaxWriteBufferLen == that.jsonpMaxWriteBufferLen && this.jsonpSupportsComment == that.jsonpSupportsComment && this.jsonpPrettify == that.jsonpPrettify && this.jsonbNulls == that.jsonbNulls && this.jsonbIJson == that.jsonbIJson && this.jsonbPrettify == that.jsonbPrettify && this.loggingGlobalSetup == that.loggingGlobalSetup && this.tomcatScanning == that.tomcatScanning && this.tomcatAutoSetup == that.tomcatAutoSetup && this.tomcatJspDevelopment == that.tomcatJspDevelopment && this.useShutdownHook == that.useShutdownHook && this.useTomcatDefaults == that.useTomcatDefaults && this.tomcatWrapLoader == that.tomcatWrapLoader && this.tomcatNoJmx == that.tomcatNoJmx && this.useLog4j2JulLogManager == that.useLog4j2JulLogManager && this.injectServletContainerInitializer == that.injectServletContainerInitializer && this.jaxwsSupportIfAvailable == that.jaxwsSupportIfAvailable && this.initializeClientBus == that.initializeClientBus && this.antiResourceLocking == that.antiResourceLocking && Objects.equals(this.pidFile, that.pidFile) && Objects.equals(this.host, that.host) && Objects.equals(this.dir, that.dir) && Objects.equals(this.serverXml, that.serverXml) && Objects.equals(this.properties, that.properties) && Objects.equals(this.keystoreFile, that.keystoreFile) && Objects.equals(this.keystorePass, that.keystorePass) && Objects.equals(this.keystoreType, that.keystoreType) && Objects.equals(this.clientAuth, that.clientAuth) && Objects.equals(this.keyAlias, that.keyAlias) && Objects.equals(this.sslProtocol, that.sslProtocol) && Objects.equals(this.webXml, that.webXml) && Objects.equals(this.loginConfig, that.loginConfig) && Objects.equals(this.securityConstraints, that.securityConstraints) && Objects.equals(this.realm, that.realm) && Objects.equals(this.users, that.users) && Objects.equals(this.roles, that.roles) && Objects.equals(this.connectors, that.connectors) && Objects.equals(this.tempDir, that.tempDir) && Objects.equals(this.conf, that.conf) && Objects.equals(this.jaxrsMapping, that.jaxrsMapping) && Objects.equals(this.jaxrsDefaultProviders, that.jaxrsDefaultProviders) && Objects.equals(this.jsonpBufferStrategy, that.jsonpBufferStrategy) && Objects.equals(this.jsonbEncoding, that.jsonbEncoding) && Objects.equals(this.jsonbBinaryStrategy, that.jsonbBinaryStrategy) && Objects.equals(this.jsonbNamingStrategy, that.jsonbNamingStrategy) && Objects.equals(this.jsonbOrderStrategy, that.jsonbOrderStrategy) && Objects.equals(this.cxfServletParams, that.cxfServletParams) && Objects.equals(this.tomcatFilter, that.tomcatFilter) && Objects.equals(this.scanningIncludes, that.scanningIncludes) && Objects.equals(this.scanningExcludes, that.scanningExcludes) && Objects.equals(this.scanningPackageIncludes, that.scanningPackageIncludes) && Objects.equals(this.scanningPackageExcludes, that.scanningPackageExcludes) && Objects.equals(this.webSessionTimeout, that.webSessionTimeout) && Objects.equals(this.webSessionCookieConfig, that.webSessionCookieConfig) && Objects.equals(this.sharedLibraries, that.sharedLibraries) && Objects.equals(this.tomcatAccessLogPattern, that.tomcatAccessLogPattern) && Objects.equals(this.meecrowaveProperties, that.meecrowaveProperties) && Objects.equals(this.defaultSSLHostConfigName, that.defaultSSLHostConfigName) && Objects.equals(this.extensions, that.extensions) && Objects.equals(this.instanceCustomizers, that.instanceCustomizers) && Objects.equals(this.initializers, that.initializers) && Objects.equals(this.contextConfigurers, that.contextConfigurers);
    }

    public int hashCode() {
        return Objects.hash(this.pidFile, this.watcherBouncing, this.httpPort, this.httpsPort, this.stopPort, this.host, this.dir, this.serverXml, this.keepServerXmlAsThis, this.properties, this.quickSession, this.skipHttp, this.ssl, this.keystoreFile, this.keystorePass, this.keystoreType, this.clientAuth, this.keyAlias, this.sslProtocol, this.webXml, this.loginConfig, this.securityConstraints, this.realm, this.users, this.roles, this.http2, this.connectors, this.tempDir, this.webResourceCached, this.conf, this.deleteBaseOnStartup, this.jaxrsMapping, this.cdiConversation, this.jaxrsProviderSetup, this.jaxrsDefaultProviders, this.jaxrsAutoActivateBeanValidation, this.jaxrsLogProviders, this.jsonpBufferStrategy, this.jsonpMaxStringLen, this.jsonpMaxReadBufferLen, this.jsonpMaxWriteBufferLen, this.jsonpSupportsComment, this.jsonpPrettify, this.jsonbEncoding, this.jsonbNulls, this.jsonbIJson, this.jsonbPrettify, this.jsonbBinaryStrategy, this.jsonbNamingStrategy, this.jsonbOrderStrategy, this.loggingGlobalSetup, this.cxfServletParams, this.tomcatScanning, this.tomcatAutoSetup, this.tomcatJspDevelopment, this.useShutdownHook, this.tomcatFilter, this.scanningIncludes, this.scanningExcludes, this.scanningPackageIncludes, this.scanningPackageExcludes, this.webSessionTimeout, this.webSessionCookieConfig, this.useTomcatDefaults, this.tomcatWrapLoader, this.tomcatNoJmx, this.sharedLibraries, this.useLog4j2JulLogManager, this.injectServletContainerInitializer, this.tomcatAccessLogPattern, this.meecrowaveProperties, this.jaxwsSupportIfAvailable, this.defaultSSLHostConfigName, this.initializeClientBus, this.extensions, this.instanceCustomizers, this.initializers, this.antiResourceLocking, this.contextConfigurers);
    }

    private static ObjectRecipe newRecipe(String clazz) {
        ObjectRecipe recipe = new ObjectRecipe(clazz);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        return recipe;
    }
}

