/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.bus.managers.ClientLifeCycleManagerImpl;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.cxf.MeecrowaveClientLifecycleListener;

public class ConfigurableBus
extends ExtensionManagerBus {
    public void initProviders(final Configuration builder, ClassLoader loader) {
        List providers = Optional.ofNullable(builder.getJaxrsDefaultProviders()).map(s -> Stream.of(s.split(" *, *")).map(String::trim).filter(p -> !p.isEmpty()).map(name -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)name).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(name + " can't be created");
            }
        }).collect(Collectors.toList())).orElseGet(() -> {
            JsonProvider provider = JsonProvider.provider();
            JsonReaderFactory readerFactory = provider.createReaderFactory((Map)new HashMap<String, Object>(){
                {
                    this.put("org.apache.johnzon.supports-comments", builder.isJsonpSupportsComment());
                    Optional.of(builder.getJsonpMaxStringLen()).filter(v -> v > 0).ifPresent(s -> this.put("org.apache.johnzon.max-string-length", s));
                    Optional.of(builder.getJsonpMaxReadBufferLen()).filter(v -> v > 0).ifPresent(s -> this.put("org.apache.johnzon.default-char-buffer", s));
                    Optional.ofNullable(builder.getJsonpBufferStrategy()).ifPresent(s -> this.put("org.apache.johnzon.buffer-strategy", s));
                }
            });
            JsonWriterFactory writerFactory = provider.createWriterFactory((Map)new HashMap<String, Object>(){
                {
                    this.put("javax.json.stream.JsonGenerator.prettyPrinting", builder.isJsonpPrettify());
                    Optional.of(builder.getJsonpMaxWriteBufferLen()).filter(v -> v > 0).ifPresent(v -> this.put("org.apache.johnzon.default-char-buffer-generator", v));
                    Optional.ofNullable(builder.getJsonpBufferStrategy()).ifPresent(s -> this.put("org.apache.johnzon.buffer-strategy", s));
                }
            });
            return Stream.of(new ConfiguredJsonbJaxrsProvider(builder.getJsonbEncoding(), builder.isJsonbNulls(), builder.isJsonbIJson(), builder.isJsonbPrettify(), builder.getJsonbBinaryStrategy(), builder.getJsonbNamingStrategy(), builder.getJsonbOrderStrategy(), new DelegateJsonProvider(provider, readerFactory, writerFactory))).collect(Collectors.toList());
        });
        if (builder.isJaxrsAutoActivateBeanValidation()) {
            try {
                loader.loadClass("javax.validation.Validation");
                Object instance = loader.loadClass("org.apache.cxf.jaxrs.validation.ValidationExceptionMapper").getConstructor(new Class[0]).newInstance(new Object[0]);
                instance.getClass().getGenericInterfaces();
                providers.add(instance);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (this.getProperty("org.apache.cxf.jaxrs.bus.providers") == null) {
            this.setProperty("skip.default.json.provider.registration", "true");
            this.setProperty("org.apache.cxf.jaxrs.bus.providers", providers);
        }
    }

    public void addClientLifecycleListener() {
        ClientLifeCycleManager manager = (ClientLifeCycleManager)this.getExtension(ClientLifeCycleManager.class);
        if (manager == null) {
            manager = new ClientLifeCycleManagerImpl();
            this.setExtension(manager, ClientLifeCycleManager.class);
        }
        manager.registerListener((ClientLifeCycleListener)new MeecrowaveClientLifecycleListener());
    }

    private static class DelegateJsonProvider
    extends JsonProvider {
        private final JsonReaderFactory readerFactory;
        private final JsonWriterFactory writerFactory;
        private final JsonProvider provider;

        private DelegateJsonProvider(JsonProvider provider, JsonReaderFactory readerFactory, JsonWriterFactory writerFactory) {
            this.provider = provider;
            this.readerFactory = readerFactory;
            this.writerFactory = writerFactory;
        }

        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return this.writerFactory;
        }

        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return this.readerFactory;
        }

        public JsonParser createParser(Reader reader) {
            return this.provider.createParser(reader);
        }

        public JsonParser createParser(InputStream in) {
            return this.provider.createParser(in);
        }

        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return this.provider.createParserFactory(config);
        }

        public JsonGenerator createGenerator(Writer writer) {
            return this.provider.createGenerator(writer);
        }

        public JsonGenerator createGenerator(OutputStream out) {
            return this.provider.createGenerator(out);
        }

        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return this.provider.createGeneratorFactory(config);
        }

        public JsonReader createReader(Reader reader) {
            return this.provider.createReader(reader);
        }

        public JsonReader createReader(InputStream in) {
            return this.provider.createReader(in);
        }

        public JsonWriter createWriter(Writer writer) {
            return this.provider.createWriter(writer);
        }

        public JsonWriter createWriter(OutputStream out) {
            return this.provider.createWriter(out);
        }

        public JsonObjectBuilder createObjectBuilder() {
            return this.provider.createObjectBuilder();
        }

        public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
            return this.provider.createObjectBuilder(jsonObject);
        }

        public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
            return this.provider.createObjectBuilder(map);
        }

        public JsonArrayBuilder createArrayBuilder() {
            return this.provider.createArrayBuilder();
        }

        public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
            return this.provider.createArrayBuilder(initialData);
        }

        public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
            return this.provider.createArrayBuilder(initialData);
        }

        public JsonPointer createPointer(String path) {
            return this.provider.createPointer(path);
        }

        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return this.provider.createBuilderFactory(config);
        }

        public JsonString createValue(String value) {
            return this.provider.createValue(value);
        }

        public JsonNumber createValue(int value) {
            return this.provider.createValue(value);
        }

        public JsonNumber createValue(long value) {
            return this.provider.createValue(value);
        }

        public JsonNumber createValue(double value) {
            return this.provider.createValue(value);
        }

        public JsonNumber createValue(BigDecimal value) {
            return this.provider.createValue(value);
        }

        public JsonNumber createValue(BigInteger value) {
            return this.provider.createValue(value);
        }

        public JsonPatch createPatch(JsonArray array) {
            return this.provider.createPatch(array);
        }

        public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
            return this.provider.createDiff(source, target);
        }

        public JsonPatchBuilder createPatchBuilder() {
            return this.provider.createPatchBuilder();
        }

        public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
            return this.provider.createPatchBuilder(initialData);
        }

        public JsonMergePatch createMergePatch(JsonValue patch) {
            return this.provider.createMergePatch(patch);
        }

        public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
            return this.provider.createMergeDiff(source, target);
        }
    }

    @Provider
    @Produces(value={"application/json", "application/*+json"})
    @Consumes(value={"application/json", "application/*+json"})
    public static class ConfiguredJsonbJaxrsProvider<T>
    extends JsonbJaxrsProvider<T> {
        private final Jsonb jsonb;

        private ConfiguredJsonbJaxrsProvider(String encoding, boolean nulls, boolean iJson, boolean pretty, String binaryStrategy, String namingStrategy, String orderStrategy, JsonProvider provider) {
            super(Collections.singletonList("[B"));
            Optional.ofNullable(encoding).ifPresent(arg_0 -> ((ConfiguredJsonbJaxrsProvider)this).setEncoding(arg_0));
            Optional.ofNullable(namingStrategy).ifPresent(arg_0 -> ((ConfiguredJsonbJaxrsProvider)this).setPropertyNamingStrategy(arg_0));
            Optional.ofNullable(orderStrategy).ifPresent(arg_0 -> ((ConfiguredJsonbJaxrsProvider)this).setPropertyOrderStrategy(arg_0));
            Optional.ofNullable(binaryStrategy).ifPresent(arg_0 -> ((ConfiguredJsonbJaxrsProvider)this).setBinaryDataStrategy(arg_0));
            this.setNullValues(nulls);
            this.setIJson(iJson);
            this.setPretty(pretty);
            this.jsonb = JsonbBuilder.newBuilder().withProvider(provider).withConfig(this.config).build();
        }

        protected Jsonb createJsonb() {
            return this.jsonb;
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return super.isReadable(type, genericType, annotations, mediaType) || JsonValue.class.isAssignableFrom(type);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return super.isWriteable(type, genericType, annotations, mediaType) || JsonValue.class.isAssignableFrom(type);
        }
    }
}

