/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTracingConfigSource
implements ConfigSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTracingConfigSource.class);
    private final Map<String, String> configuration = new HashMap<String, String>(){
        {
            int tracingRate;
            try {
                tracingRate = Optional.ofNullable(System.getenv("TRACING_SAMPLING_RATE")).map(Integer::parseInt).orElse(1);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Can't parse value of environment property TRACING_SAMPLING_RATE", (Object)e.getMessage());
                tracingRate = 1;
            }
            String isTracingOn = String.valueOf(Boolean.parseBoolean(System.getenv("TRACING_ON")) && tracingRate == 1);
            this.put("geronimo.opentracing.filter.active", isTracingOn);
            this.put("span.converter.zipkin.active", isTracingOn);
            this.put("span.converter.zipkin.logger.active", isTracingOn);
        }
    };

    public Map<String, String> getProperties() {
        return this.configuration;
    }

    public int getOrdinal() {
        return 2000;
    }

    public String getValue(String propertyName) {
        return this.configuration.get(propertyName);
    }

    public String getName() {
        return "talend-opentracing";
    }
}

