/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.server.api.DocumentationResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.front.model.DocumentationContent;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.jcache.FrontCacheKeyGenerator;
import org.talend.sdk.component.server.service.jcache.FrontCacheResolver;

@ApplicationScoped
@CacheDefaults(cacheResolverFactory=FrontCacheResolver.class, cacheKeyGenerator=FrontCacheKeyGenerator.class)
public class DocumentationResourceImpl
implements DocumentationResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentationResourceImpl.class);
    private static final DocumentationContent NO_DOC = new DocumentationContent("asciidoc", "");
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentManager manager;
    @Inject
    private Instance<Object> instance;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private ExtensionComponentMetadataManager virtualComponents;
    private Path i18nBase;

    @PostConstruct
    private void init() {
        this.i18nBase = PathFactory.get((String)this.configuration.getDocumentationI18nTranslations().replace("${home}", System.getProperty("meecrowave.home", "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CacheResult
    public DocumentationContent getDocumentation(String id, String language, DocumentationResource.DocumentationSegment segment) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return NO_DOC;
        }
        Locale locale = this.localeMapper.mapLocale(language);
        Container container = Optional.ofNullable(this.componentDao.findById(id)).map(meta -> (Container)this.manager.findPlugin(meta.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin '" + meta.getParent().getPlugin() + "'")).build()))).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
        DocumentationCache cache = (DocumentationCache)container.get(DocumentationCache.class);
        if (cache == null) {
            Container container2 = container;
            synchronized (container2) {
                cache = (DocumentationCache)container.get(DocumentationCache.class);
                if (cache == null) {
                    cache = new DocumentationCache();
                    container.set(DocumentationCache.class, (Object)cache);
                }
            }
        }
        return cache.documentations.computeIfAbsent(new DocKey(id, language, segment), key -> {
            String content = Stream.of("documentation_" + locale.getLanguage() + ".adoc", "documentation_" + language + ".adoc", "documentation.adoc").flatMap(name -> {
                try {
                    return Optional.ofNullable(container.getLoader().getResources("TALEND-INF/" + name)).filter(Enumeration::hasMoreElements).map(e -> Collections.list(e).stream()).orElseGet(() -> Optional.ofNullable(this.findLocalI18n(locale, container)).map(Stream::of).orElseGet(Stream::empty));
                }
                catch (IOException e2) {
                    throw new IllegalStateException(e2);
                }
            }).filter(Objects::nonNull).map(url -> {
                String string;
                BufferedReader stream = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                try {
                    string = stream.lines().collect(Collectors.joining("\n"));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).build());
                    }
                }
                stream.close();
                return string;
            }).map(value -> Optional.ofNullable((ContainerComponentRegistry)container.get(ContainerComponentRegistry.class)).flatMap(r -> r.getComponents().values().stream().flatMap(f -> Stream.of(f.getPartitionMappers().values().stream(), f.getProcessors().values().stream(), f.getDriverRunners().values().stream()).flatMap(t -> t)).filter(c -> c.getId().equals(id)).findFirst().map(c -> this.selectById(c.getName(), (String)value, segment))).orElse(value)).map(String::trim).filter(it -> !it.isEmpty()).findFirst().orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'")).build()));
            return new DocumentationContent("asciidoc", content);
        });
    }

    private URL findLocalI18n(Locale locale, Container container) {
        if (!Files.exists(this.i18nBase, new LinkOption[0])) {
            return null;
        }
        Path file = this.i18nBase.resolve("documentation_" + container.getId() + "_" + locale.getLanguage() + ".adoc");
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return file.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    String selectById(String name, String value, DocumentationResource.DocumentationSegment segment) {
        List<String> lines;
        try (BufferedReader reader = new BufferedReader(new StringReader(value));){
            lines = reader.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this.extractUsingComments(name, lines, segment).orElseGet(() -> this.noMarkingCommentFallbackExtraction(name, lines, segment, value));
    }

    private Optional<String> extractUsingComments(String name, List<String> lines, DocumentationResource.DocumentationSegment segment) {
        HashMap linesPerComponents = new HashMap();
        ArrayList<String> currentCapture = null;
        for (String line : lines) {
            if (line.startsWith("//component_start:")) {
                currentCapture = new ArrayList<String>();
                linesPerComponents.put(line.substring("//component_start:".length()), currentCapture);
                continue;
            }
            if (line.startsWith("//component_end:")) {
                currentCapture = null;
                continue;
            }
            if (currentCapture == null || line.isEmpty() && currentCapture.isEmpty()) continue;
            currentCapture.add(line);
        }
        List componentDoc = (List)linesPerComponents.get(name);
        return Optional.ofNullable(componentDoc).filter(componentLines -> componentLines.stream().filter(it -> !it.isEmpty()).count() > 1L).map(componentLines -> this.extractSegmentFromComments(segment, componentDoc)).filter(it -> !it.trim().isEmpty());
    }

    private String noMarkingCommentFallbackExtraction(String name, List<String> lines, DocumentationResource.DocumentationSegment segment, String fallback) {
        TreeMap configurationLevels = lines.stream().filter(it -> it.endsWith("= Configuration")).map(it -> it.indexOf(32)).collect(Collectors.groupingBy(it -> it, TreeMap::new, Collectors.toList()));
        if (configurationLevels.isEmpty()) {
            return fallback;
        }
        int titleLevels = Math.max(1, (Integer)configurationLevels.lastKey() - 1);
        String prefixTitle = IntStream.range(0, titleLevels).mapToObj(i -> "=").collect(Collectors.joining()) + " ";
        int titleIndex = lines.indexOf(prefixTitle + name);
        if (titleIndex < 0) {
            return fallback;
        }
        List<String> endOfLines = lines.subList(titleIndex, lines.size());
        int lineIdx = 0;
        for (String line : endOfLines) {
            if (lineIdx > 0 && line.startsWith(prefixTitle)) {
                endOfLines = endOfLines.subList(0, lineIdx);
                break;
            }
            ++lineIdx;
        }
        if (!endOfLines.isEmpty()) {
            return this.extractSegmentFromTitles(segment, prefixTitle, endOfLines);
        }
        return fallback;
    }

    private String extractSegmentFromTitles(DocumentationResource.DocumentationSegment segment, String prefixTitle, List<String> endOfLines) {
        if (endOfLines.isEmpty()) {
            return "";
        }
        switch (segment) {
            case DESCRIPTION: {
                int firstIndex;
                String configTitle = this.getConfigTitle(prefixTitle);
                int configIndex = endOfLines.indexOf(configTitle);
                boolean skipFirst = endOfLines.get(0).startsWith(prefixTitle);
                int lastIndex = configIndex < 0 ? endOfLines.size() : configIndex;
                int n = firstIndex = skipFirst ? 1 : 0;
                if (lastIndex - firstIndex <= 0) {
                    return "";
                }
                return String.join((CharSequence)"\n", endOfLines.subList(firstIndex, lastIndex));
            }
            case CONFIGURATION: {
                String configTitle = this.getConfigTitle(prefixTitle);
                int configIndex = endOfLines.indexOf(configTitle);
                if (configIndex < 0 || configIndex + 1 >= endOfLines.size()) {
                    return "";
                }
                return String.join((CharSequence)"\n", endOfLines.subList(configIndex + 1, endOfLines.size()));
            }
        }
        return String.join((CharSequence)"\n", endOfLines);
    }

    private String extractSegmentFromComments(DocumentationResource.DocumentationSegment segment, List<String> lines) {
        if (lines.isEmpty()) {
            return "";
        }
        switch (segment) {
            case DESCRIPTION: {
                int start;
                int configStartIndex = lines.indexOf("//configuration_start");
                int n = start = lines.get(0).startsWith("=") ? 1 : 0;
                if (configStartIndex > start) {
                    return String.join((CharSequence)"\n", lines.subList(start, configStartIndex)).trim();
                }
                if (lines.get(0).startsWith("=")) {
                    return String.join((CharSequence)"\n", lines.subList(1, lines.size()));
                }
                return String.join((CharSequence)"\n", lines);
            }
            case CONFIGURATION: {
                int configEndIndex;
                int configStartIndex = lines.indexOf("//configuration_start");
                if (configStartIndex > 0 && (configEndIndex = lines.indexOf("//configuration_end")) > ++configStartIndex) {
                    while (configStartIndex > 0 && configStartIndex < configEndIndex && (lines.get(configStartIndex).isEmpty() || lines.get(configStartIndex).startsWith("="))) {
                        ++configStartIndex;
                    }
                    if (configStartIndex > 0 && configEndIndex > configStartIndex + 2) {
                        return String.join((CharSequence)"\n", lines.subList(configStartIndex, configEndIndex)).trim();
                    }
                }
                return "";
            }
        }
        return String.join((CharSequence)"\n", lines);
    }

    private String getConfigTitle(String prefixTitle) {
        return '=' + prefixTitle + "Configuration";
    }

    private static class DocumentationCache {
        private final ConcurrentMap<DocKey, DocumentationContent> documentations = new ConcurrentHashMap<DocKey, DocumentationContent>();

        private DocumentationCache() {
        }
    }

    private static class DocKey {
        private final String id;
        private final String language;
        private final DocumentationResource.DocumentationSegment segment;
        private final int hash;

        private DocKey(String id, String language, DocumentationResource.DocumentationSegment segment) {
            this.id = id;
            this.language = language;
            this.segment = segment;
            this.hash = Objects.hash(id, language, segment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocKey docKey = (DocKey)DocKey.class.cast(o);
            return this.id.equals(docKey.id) && this.language.equals(docKey.language) && this.segment == docKey.segment;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

