/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;

@ApplicationScoped
public class VirtualDependenciesService {
    private static final Logger log = LoggerFactory.getLogger(VirtualDependenciesService.class);
    private final String virtualGroupId = "virtual.talend.component.server.generated.";
    private final String configurationArtifactIdPrefix = "user-local-configuration-";
    private final Enrichment noCustomization = new Enrichment(false, null, null, null);
    @Inject
    private ComponentServerConfiguration configuration;
    private final Map<String, Enrichment> enrichmentsPerContainer = new HashMap<String, Enrichment>();
    private final Map<Artifact, Path> artifactMapping = new ConcurrentHashMap<Artifact, Path>();
    private final Map<Artifact, Supplier<InputStream>> configurationArtifactMapping = new ConcurrentHashMap<Artifact, Supplier<InputStream>>();
    private Path provisioningM2Base;

    @PostConstruct
    private void init() {
        String m2;
        switch (m2 = this.configuration.getUserExtensionsAutoM2Provisioning()) {
            case "skip": {
                this.provisioningM2Base = null;
                break;
            }
            case "auto": {
                this.provisioningM2Base = this.findStudioM2();
                break;
            }
            default: {
                this.provisioningM2Base = PathFactory.get((String)m2);
            }
        }
        log.debug("m2 provisioning base: {}", (Object)this.provisioningM2Base);
    }

    public void onDeploy(String pluginId) {
        Map<Artifact, Path> userJars;
        if (!this.configuration.getUserExtensions().isPresent()) {
            this.enrichmentsPerContainer.put(pluginId, this.noCustomization);
            return;
        }
        Path extensions = PathFactory.get((String)this.configuration.getUserExtensions().orElseThrow(IllegalArgumentException::new)).resolve(pluginId);
        if (!Files.exists(extensions, new LinkOption[0])) {
            log.debug("'{}' does not exist so no extension will be added to family '{}'", (Object)extensions, (Object)pluginId);
            this.enrichmentsPerContainer.put(pluginId, this.noCustomization);
            return;
        }
        Path userConfig = extensions.resolve("user-configuration.properties");
        Properties userConfiguration = this.loadUserConfiguration(pluginId, userConfig, userJars = this.findJars(extensions, pluginId));
        if (userConfiguration.isEmpty() && userJars.isEmpty()) {
            log.debug("No customization for container '{}'", (Object)pluginId);
            this.enrichmentsPerContainer.put(pluginId, this.noCustomization);
            return;
        }
        Map<String, String> customConfigAsMap = userConfiguration.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), userConfiguration::getProperty));
        log.debug("Set up customization for container '{}' (has-configuration={}, jars={})", new Object[]{pluginId, !userConfiguration.isEmpty(), userJars});
        if (userConfiguration.isEmpty()) {
            this.enrichmentsPerContainer.put(pluginId, new Enrichment(true, customConfigAsMap, null, userJars.keySet()));
        } else {
            Artifact configurationArtifact;
            byte[] localConfigurationJar = this.generateConfigurationJar(pluginId, userConfiguration);
            try {
                configurationArtifact = new Artifact(this.groupIdFor(pluginId), "user-local-configuration-" + pluginId, "jar", "", Long.toString(Files.getLastModifiedTime(userConfig, new LinkOption[0]).toMillis()), "compile");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.doProvision(configurationArtifact, () -> new ByteArrayInputStream(localConfigurationJar));
            this.enrichmentsPerContainer.put(pluginId, new Enrichment(true, customConfigAsMap, configurationArtifact, userJars.keySet()));
            this.configurationArtifactMapping.put(configurationArtifact, () -> new ByteArrayInputStream(localConfigurationJar));
        }
        userJars.forEach((artifact, file) -> this.doProvision((Artifact)artifact, () -> {
            try {
                return Files.newInputStream(file, StandardOpenOption.READ);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }));
        this.artifactMapping.putAll(userJars);
    }

    public void onUnDeploy(Container plugin) {
        Enrichment enrichment = this.enrichmentsPerContainer.remove(plugin.getId());
        if (enrichment == null || enrichment == this.noCustomization) {
            return;
        }
        if (enrichment.userArtifacts != null) {
            enrichment.userArtifacts.forEach(this.artifactMapping::remove);
            enrichment.userArtifacts.clear();
        }
        if (enrichment.configurationArtifact != null) {
            this.configurationArtifactMapping.remove(enrichment.configurationArtifact);
        }
    }

    public boolean isVirtual(String gav) {
        return gav.startsWith("virtual.talend.component.server.generated.");
    }

    public Enrichment getEnrichmentFor(String pluginId) {
        return this.enrichmentsPerContainer.get(pluginId);
    }

    public Stream<Artifact> userArtifactsFor(String pluginId) {
        Enrichment enrichment = this.enrichmentsPerContainer.get(pluginId);
        if (enrichment == null || !enrichment.customized) {
            return Stream.empty();
        }
        Stream<Artifact> userJars = enrichment.userArtifacts.stream();
        if (enrichment.configurationArtifact != null) {
            return Stream.concat(userJars, Stream.of(enrichment.configurationArtifact));
        }
        return userJars;
    }

    public Supplier<InputStream> retrieveArtifact(Artifact artifact) {
        return Optional.ofNullable(this.artifactMapping.get(artifact)).map(it -> () -> {
            try {
                return Files.newInputStream(it, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseGet(() -> this.configurationArtifactMapping.get(artifact));
    }

    public String groupIdFor(String family) {
        return "virtual.talend.component.server.generated." + this.sanitizedForGav(family);
    }

    private byte[] generateConfigurationJar(String family, Properties userConfiguration) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.putValue("Created-By", "Talend Component Kit Server");
        mainAttributes.putValue("Talend-Time", Long.toString(System.currentTimeMillis()));
        mainAttributes.putValue("Talend-Family-Name", family);
        try (JarOutputStream jar = new JarOutputStream((OutputStream)new BufferedOutputStream(outputStream), manifest);){
            jar.putNextEntry(new JarEntry("TALEND-INF/local-configuration.properties"));
            userConfiguration.store(jar, "Configuration of the family " + family);
            jar.closeEntry();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return outputStream.toByteArray();
    }

    private Properties loadUserConfiguration(String plugin, Path userConfig, Map<Artifact, Path> userJars) {
        String content;
        Properties properties = new Properties();
        if (!Files.exists(userConfig, new LinkOption[0])) {
            return properties;
        }
        try (BufferedReader stream = Files.newBufferedReader(userConfig);){
            content = stream.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try (StringReader reader = new StringReader(this.replaceByGav(plugin, content, userJars));){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return properties;
    }

    String replaceByGav(String plugin, String content, Map<Artifact, Path> userJars) {
        StringBuilder output = new StringBuilder();
        String prefixFn = "userJar(";
        int fnIdx = content.indexOf("userJar(");
        int previousEnd = 0;
        if (fnIdx < 0) {
            output.append(content);
        } else {
            while (fnIdx >= 0) {
                int end = content.indexOf(41, fnIdx);
                output.append(content, previousEnd, fnIdx);
                output.append(this.toGav(plugin, content.substring(fnIdx + "userJar(".length(), end), userJars));
                fnIdx = content.indexOf("userJar(", end);
                if (fnIdx < 0) {
                    if (end >= content.length() - 1) continue;
                    output.append(content, end + 1, content.length());
                    continue;
                }
                previousEnd = end + 1;
            }
        }
        return output.toString();
    }

    private String toGav(String plugin, String jarNameWithoutExtension, Map<Artifact, Path> userJars) {
        return this.groupIdFor(plugin) + ':' + jarNameWithoutExtension + ":jar:" + userJars.keySet().stream().filter(it -> it.getArtifact().equals(jarNameWithoutExtension)).findFirst().map(Artifact::getVersion).orElse("unknown");
    }

    private Map<Artifact, Path> findJars(Path familyFolder, String family) {
        if (!Files.isDirectory(familyFolder, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try {
            return Files.list(familyFolder).filter(file -> file.getFileName().toString().endsWith(".jar")).collect(Collectors.toMap(it -> {
                try {
                    return new Artifact(this.groupIdFor(family), this.toArtifact((Path)it), "jar", "", Long.toString(Files.getLastModifiedTime(it, new LinkOption[0]).toMillis()), "compile");
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }, Function.identity()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toArtifact(Path file) {
        String name = file.getFileName().toString();
        return name.substring(0, name.length() - ".jar".length());
    }

    private String sanitizedForGav(String name) {
        return name.replace(' ', '_').toLowerCase(Locale.ROOT);
    }

    private Path findStudioM2() {
        Path localM2;
        if (System.getProperty("talend.studio.version") != null && System.getProperty("osgi.bundles") != null && Files.isDirectory(localM2 = PathFactory.get((String)System.getProperty("talend.component.server.maven.repository", "")), new LinkOption[0])) {
            return localM2;
        }
        return null;
    }

    private void doProvision(Artifact artifact, Supplier<InputStream> newInputStream) {
        if (this.provisioningM2Base == null) {
            log.debug("No m2 to provision, skipping {}", (Object)artifact);
            return;
        }
        Path target = this.provisioningM2Base.resolve(artifact.toPath());
        if (target.toFile().exists()) {
            log.debug("{} already exists, skipping", (Object)target);
            return;
        }
        Path parentFile = target.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't create " + parentFile, e);
            }
        }
        try (BufferedInputStream stream = new BufferedInputStream(newInputStream.get());){
            Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    String getVirtualGroupId() {
        return this.virtualGroupId;
    }

    String getConfigurationArtifactIdPrefix() {
        return this.configurationArtifactIdPrefix;
    }

    public Map<Artifact, Path> getArtifactMapping() {
        return this.artifactMapping;
    }

    public static class UserContainerClasspathContributor
    implements ComponentManager.ContainerClasspathContributor {
        private final VirtualDependenciesService delegate = (VirtualDependenciesService)CDI.current().select(VirtualDependenciesService.class, new Annotation[0]).get();

        public Collection<Artifact> findContributions(String pluginId) {
            this.delegate.onDeploy(pluginId);
            return this.delegate.userArtifactsFor(pluginId).collect(Collectors.toList());
        }

        public boolean canResolve(String path) {
            return this.delegate.isVirtual(path.replace('/', '.'));
        }

        public Path resolve(String path) {
            if (path.contains('/' + this.delegate.getConfigurationArtifactIdPrefix())) {
                return null;
            }
            String[] segments = path.split("/");
            if (segments.length < 9) {
                return null;
            }
            String group = this.delegate.groupIdFor(Stream.of(segments).skip(5L).limit(segments.length - 5 - 3).collect(Collectors.joining(".")));
            String artifact = segments[segments.length - 3];
            return this.delegate.getArtifactMapping().entrySet().stream().filter(it -> ((Artifact)it.getKey()).getGroup().equals(group) && ((Artifact)it.getKey()).getArtifact().equals(artifact)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
    }

    public static class LocalConfigurationImpl
    implements LocalConfiguration {
        private final VirtualDependenciesService delegate = (VirtualDependenciesService)CDI.current().select(VirtualDependenciesService.class, new Annotation[0]).get();

        public String get(String key) {
            if (key == null || !key.contains(".")) {
                return null;
            }
            String plugin = key.substring(0, key.indexOf(46));
            Enrichment enrichment = this.delegate.getEnrichmentFor(plugin);
            if (enrichment == null || enrichment.customConfiguration == null) {
                return null;
            }
            return (String)enrichment.customConfiguration.get(key.substring(plugin.length() + 1));
        }

        public Set<String> keys() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (!ConfigurableClassLoader.class.isInstance(loader)) {
                return Collections.emptySet();
            }
            String id = ((ConfigurableClassLoader)ConfigurableClassLoader.class.cast(loader)).getId();
            Enrichment enrichment = this.delegate.getEnrichmentFor(id);
            if (enrichment == null || enrichment.customConfiguration == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(enrichment.customConfiguration.keySet());
        }
    }

    private static class Enrichment {
        private final boolean customized;
        private final Map<String, String> customConfiguration;
        private final Artifact configurationArtifact;
        private final Collection<Artifact> userArtifacts;

        public Enrichment(boolean customized, Map<String, String> customConfiguration, Artifact configurationArtifact, Collection<Artifact> userArtifacts) {
            this.customized = customized;
            this.customConfiguration = customConfiguration;
            this.configurationArtifact = configurationArtifact;
            this.userArtifacts = userArtifacts;
        }
    }
}

