/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.impl;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import org.apache.geronimo.microprofile.opentracing.common.impl.ScopeImpl;

public class ScopeManagerImpl
implements ScopeManager {
    private final ThreadLocal<Scope> current = new ThreadLocal();

    public Scope activate(Span span, boolean finishSpanOnClose) {
        Thread thread = Thread.currentThread();
        Scope oldScope = this.current.get();
        ScopeImpl newScope = new ScopeImpl(() -> {
            if (Thread.currentThread() == thread) {
                this.current.set(oldScope);
            }
        }, span, finishSpanOnClose);
        this.current.set(newScope);
        return newScope;
    }

    public Scope active() {
        Scope scope = this.current.get();
        if (scope == null) {
            this.current.remove();
        }
        return scope;
    }

    public void clear() {
        this.current.remove();
    }
}

