/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import org.apache.geronimo.jcache.simple.cdi.CDIJCacheHelper;
import org.apache.geronimo.jcache.simple.cdi.CachePutInterceptor;
import org.apache.geronimo.jcache.simple.cdi.CacheRemoveAllInterceptor;
import org.apache.geronimo.jcache.simple.cdi.CacheRemoveInterceptor;
import org.apache.geronimo.jcache.simple.cdi.CacheResultInterceptor;

public class MakeJCacheCDIInterceptorFriendly
implements Extension {
    private static final AtomicInteger id = new AtomicInteger();
    private static final boolean USE_ID = !Boolean.getBoolean("org.apache.geronimo.jcache.simple.skip-id");
    private static final boolean SKIP = Boolean.getBoolean("org.apache.geronimo.jcache.simple.skip-cdi");
    private boolean needHelper = true;

    public void discoverInterceptorBindings(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager bm) {
        if (SKIP) {
            return;
        }
        Stream.of(CachePut.class, CacheRemove.class, CacheRemoveAll.class, CacheResult.class).forEach(it -> beforeBeanDiscovery.addInterceptorBinding(bm.createAnnotatedType(it)));
        Stream.of(CDIJCacheHelper.class, CachePutInterceptor.class, CacheResultInterceptor.class, CacheRemoveAllInterceptor.class, CacheRemoveInterceptor.class).forEach(it -> beforeBeanDiscovery.addAnnotatedType(bm.createAnnotatedType(it)));
    }

    public void addHelper(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager bm) {
        if (SKIP) {
            return;
        }
        if (!this.needHelper) {
            return;
        }
        AnnotatedType annotatedType = bm.createAnnotatedType(CDIJCacheHelper.class);
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        HelperBean bean = new HelperBean((AnnotatedType<CDIJCacheHelper>)annotatedType, (InjectionTarget<CDIJCacheHelper>)injectionTarget, this.findIdSuffix());
        afterBeanDiscovery.addBean((Bean)bean);
    }

    public void vetoScannedCDIJCacheHelperQualifiers(@Observes ProcessAnnotatedType<CDIJCacheHelper> pat) {
        if (SKIP) {
            return;
        }
        if (!this.needHelper && !ProcessSyntheticAnnotatedType.class.isInstance(pat)) {
            pat.veto();
        }
        this.needHelper = false;
    }

    private String findIdSuffix() {
        if (USE_ID) {
            return "lib" + id.incrementAndGet();
        }
        return "default";
    }

    public static class HelperBean
    implements Bean<CDIJCacheHelper>,
    PassivationCapable {
        private final AnnotatedType<CDIJCacheHelper> at;
        private final InjectionTarget<CDIJCacheHelper> it;
        private final HashSet<Annotation> qualifiers;
        private final String id;

        public HelperBean(AnnotatedType<CDIJCacheHelper> annotatedType, InjectionTarget<CDIJCacheHelper> injectionTarget, String id) {
            this.at = annotatedType;
            this.it = injectionTarget;
            this.id = "JCache#CDIHelper#" + id;
            this.qualifiers = new HashSet();
            this.qualifiers.add((Annotation)Default.Literal.INSTANCE);
            this.qualifiers.add((Annotation)Any.Literal.INSTANCE);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.it.getInjectionPoints();
        }

        public Class<?> getBeanClass() {
            return this.at.getJavaClass();
        }

        public boolean isNullable() {
            return false;
        }

        public Set<Type> getTypes() {
            return this.at.getTypeClosure();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public CDIJCacheHelper create(CreationalContext<CDIJCacheHelper> context) {
            CDIJCacheHelper produce = (CDIJCacheHelper)this.it.produce(context);
            this.it.inject((Object)produce, context);
            this.it.postConstruct((Object)produce);
            return produce;
        }

        public void destroy(CDIJCacheHelper instance, CreationalContext<CDIJCacheHelper> context) {
            this.it.preDestroy((Object)instance);
            this.it.dispose((Object)instance);
            context.release();
        }

        public String getId() {
            return this.id;
        }
    }
}

