/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;

public class PropertiesSetup
implements Meecrowave.ConfigurationCustomizer {
    public void accept(Configuration configuration) {
        System.setProperty("geronimo.opentracing.client.filter.request.skip", "true");
        System.setProperty("geronimo.opentracing.filter.skippedTracing.urls", ".*/login$,.*/decrypt/.*");
        System.setProperty("geronimo.opentracing.filter.skippedTracing.matcherType", "regex");
        String httpPort = System.getenv("TALEND_COMPONENT_SERVER_PORT");
        if (httpPort != null) {
            System.setProperty("http", httpPort);
            configuration.setHttpPort(Integer.parseInt(httpPort));
        }
        String log4jLayout = System.getenv("LOGGING_LAYOUT");
        String appHome = System.getenv("TALEND_APP_HOME");
        if (log4jLayout != null && appHome != null) {
            String initialConfig = System.getProperty("log4j.configurationFile", "default.properties");
            String newConfig = String.format("%s/conf/log4j2-component-server-%s.xml", appHome, log4jLayout);
            if (!newConfig.equals(initialConfig)) {
                System.setProperty("log4j.configurationFile", newConfig);
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                ctx.setConfigLocation(new File(newConfig).toURI());
                ctx.reconfigure();
                ctx.updateLoggers();
            }
        }
        configuration.loadFromProperties(System.getProperties());
        if (configuration.getProperties() == null) {
            configuration.setProperties(new Properties());
        }
        configuration.getProperties().putAll((Map<?, ?>)System.getProperties());
        configuration.getProperties().stringPropertyNames().stream().filter(k -> System.getProperty(k) == null).forEach(k -> System.setProperty(k, configuration.getProperties().getProperty((String)k)));
    }
}

