/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.builtinparams;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.manager.ParameterMeta;

public class StreamingLongParamBuilder {
    private final ParameterMeta root;
    private final String componentClassName;
    private final String name;
    private final String layoutType;
    private final Long defaultValue;
    private final LocalConfiguration configuration;

    public StreamingLongParamBuilder(ParameterMeta root, String componentClassName, String parameterName, LocalConfiguration configuration) {
        this.root = root;
        this.componentClassName = componentClassName;
        this.name = parameterName;
        this.configuration = configuration;
        this.layoutType = this.findLayoutType();
        this.defaultValue = Long.parseLong(Optional.ofNullable(configuration.get(componentClassName + this.name)).orElseGet(() -> Optional.ofNullable(configuration.get(this.name)).orElse("-1")).trim());
    }

    public ParameterMeta newBulkParameter() {
        return new ParameterMeta(new ParameterMeta.Source(){

            @Override
            public String name() {
                return StreamingLongParamBuilder.this.name;
            }

            @Override
            public Class<?> declaringClass() {
                return StreamingLongParamBuilder.class;
            }
        }, (Type)((Object)Long.class), ParameterMeta.Type.NUMBER, this.root.getPath() + "." + this.name, this.name, (String[])Stream.concat(Stream.of(StreamingLongParamBuilder.class.getPackage().getName()), Stream.of(Optional.ofNullable(this.root.getI18nPackages()).orElse(new String[0]))).toArray(String[]::new), Collections.emptyList(), (Collection<String>)Collections.emptyList(), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tcomp::ui::defaultvalue::value", String.valueOf(StreamingLongParamBuilder.this.defaultValue));
                this.put("tcomp::validation::min", "-1");
            }
        }, true);
    }

    public String getLayoutType() {
        return this.layoutType;
    }

    private String findLayoutType() {
        if (this.root == null) {
            return "tcomp::ui::gridlayout::Advanced::value";
        }
        String rootLayoutType = this.root.getMetadata().keySet().stream().filter(k -> k.contains("tcomp::ui") && (k.contains("layout") || k.contains("optionsorder"))).map(k -> k.split("::")).filter(s -> ((String[])s).length > 2).map(s -> s[2]).findFirst().orElse("default");
        switch (rootLayoutType.toLowerCase(Locale.ROOT)) {
            case "verticallayout": {
                return "tcomp::ui::verticallayout";
            }
            case "horizontallayout": {
                return "tcomp::ui::horizontallayout";
            }
            case "autolayout": {
                return "tcomp::ui::autolayout";
            }
            case "optionsorder": {
                return "tcomp::ui::optionsorder";
            }
            case "default": {
                return null;
            }
        }
        return "tcomp::ui::gridlayout::Advanced::value";
    }

    public static class StreamingMaxDurationMsParamBuilder
    extends StreamingLongParamBuilder {
        public StreamingMaxDurationMsParamBuilder(ParameterMeta root, String componentClassName, LocalConfiguration configuration) {
            super(root, componentClassName, "$maxDurationMs", configuration);
        }
    }

    public static class StreamingMaxRecordsParamBuilder
    extends StreamingLongParamBuilder {
        public StreamingMaxRecordsParamBuilder(ParameterMeta root, String componentClassName, LocalConfiguration configuration) {
            super(root, componentClassName, "$maxRecords", configuration);
        }
    }
}

