/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.server;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.impl.ScopeManagerImpl;
import org.apache.geronimo.microprofile.opentracing.common.impl.ServletHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.common.spi.Container;

public class OpenTracingFilter
implements Filter {
    private Tracer tracer;
    private GeronimoOpenTracingConfig config;
    private ScopeManager manager;
    private Container container;
    private Collection<Predicate<String>> forcedUrls;
    private List<Predicate<String>> skipUrls;
    private boolean skipDefaultTags;
    private boolean forceStackLog;

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void setConfig(GeronimoOpenTracingConfig config) {
        this.config = config;
    }

    public void setManager(ScopeManager manager) {
        this.manager = manager;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void init(FilterConfig filterConfig) {
        if (this.container == null) {
            this.container = Container.get();
        }
        if (this.tracer == null) {
            this.tracer = this.container.lookup(Tracer.class);
        }
        if (this.manager == null) {
            this.manager = this.container.lookup(ScopeManager.class);
        }
        if (this.config == null) {
            this.config = this.container.lookup(GeronimoOpenTracingConfig.class);
        }
        this.skipDefaultTags = Boolean.parseBoolean(this.config.read("filter.forcedTracing.skipDefaultTags", "false"));
        this.forceStackLog = Boolean.parseBoolean(this.config.read("filter.error.forceStackLog", "false"));
        this.forcedUrls = Optional.ofNullable(this.config.read("filter.forcedTracing.urls", null)).map(String::trim).filter(v -> !v.isEmpty()).map(v -> this.toMatchingPredicates((String)v, "forcedTracing")).orElse(null);
        this.skipUrls = Optional.ofNullable(this.config.read("filter.skippedTracing.urls", null)).map(String::trim).filter(v -> !v.isEmpty()).map(v -> this.toMatchingPredicates((String)v, "skippedTracing")).orElse(null);
    }

    private List<Predicate<String>> toMatchingPredicates(String v, String keyMarker) {
        Function<String, Predicate> matcherFactory;
        String matchingType;
        switch (matchingType = this.config.read("filter." + keyMarker + ".matcherType", "prefix")) {
            case "regex": {
                matcherFactory = from -> {
                    Pattern compiled = Pattern.compile(from);
                    return url -> compiled.matcher((CharSequence)url).matches();
                };
                break;
            }
            default: {
                matcherFactory = from -> url -> url.startsWith((String)from);
            }
        }
        return Stream.of(v.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(matcherFactory).collect(Collectors.toList());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String matching;
        HttpServletRequest req;
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        if (this.forcedUrls != null && !this.forcedUrls.isEmpty()) {
            req = (HttpServletRequest)HttpServletRequest.class.cast(request);
            matching = req.getRequestURI().substring(req.getContextPath().length());
            if (this.forcedUrls.stream().anyMatch(p -> p.test(matching))) {
                Tracer.SpanBuilder builder = this.tracer.buildSpan(this.buildServletOperationName(req));
                builder.withTag(Tags.SPAN_KIND.getKey(), "server");
                builder.withTag("component", "servlet");
                Optional.ofNullable(Optional.ofNullable(this.tracer.activeSpan()).map(Span::context).orElseGet(() -> this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new ServletHeaderTextMap(req, (HttpServletResponse)HttpServletResponse.class.cast(response))))).ifPresent(arg_0 -> ((Tracer.SpanBuilder)builder).asChildOf(arg_0));
                Scope scope2 = builder.startActive(true);
                Span span = scope2.span();
                if (!this.skipDefaultTags) {
                    Tags.HTTP_METHOD.set(span, req.getMethod());
                    Tags.HTTP_URL.set(span, req.getRequestURL().toString());
                }
                request.setAttribute(OpenTracingFilter.class.getName(), (Object)scope2);
            }
        }
        if (this.skipUrls != null && !this.skipUrls.isEmpty()) {
            req = (HttpServletRequest)HttpServletRequest.class.cast(request);
            matching = req.getRequestURI().substring(req.getContextPath().length());
            if (this.skipUrls.stream().anyMatch(p -> p.test(matching))) {
                chain.doFilter(request, response);
                return;
            }
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Exception ex) {
            this.getCurrentScope(request).ifPresent(scope -> this.onError(response, ex, (Scope)scope));
            throw ex;
        }
        finally {
            this.getCurrentScope(request).ifPresent(scope -> {
                if (request.isAsyncStarted()) {
                    InvocationHandler handler;
                    request.getAsyncContext().addListener(new AsyncListener((Scope)scope){
                        final /* synthetic */ Scope val$scope;
                        {
                            this.val$scope = scope;
                        }

                        public void onComplete(AsyncEvent event) {
                            this.val$scope.close();
                        }

                        public void onTimeout(AsyncEvent event) {
                            OpenTracingFilter.this.onError(event.getSuppliedResponse(), Optional.ofNullable(event.getThrowable()).orElseGet(TimeoutException::new), this.val$scope);
                        }

                        public void onError(AsyncEvent event) {
                            OpenTracingFilter.this.onError(event.getSuppliedResponse(), event.getThrowable(), this.val$scope);
                        }

                        public void onStartAsync(AsyncEvent event) {
                        }
                    });
                    ScopeManager managerImpl = this.manager;
                    if (!ScopeManagerImpl.class.isInstance(managerImpl) && Proxy.isProxyClass(this.manager.getClass()) && Container.Unwrappable.class.isInstance(handler = Proxy.getInvocationHandler(this.manager))) {
                        managerImpl = (ScopeManager)ScopeManager.class.cast(((Container.Unwrappable)Container.Unwrappable.class.cast(handler)).unwrap());
                    }
                    if (ScopeManagerImpl.class.isInstance(managerImpl)) {
                        ((ScopeManagerImpl)ScopeManagerImpl.class.cast(managerImpl)).clear();
                    }
                } else {
                    scope.close();
                }
            });
        }
    }

    private void onError(ServletResponse response, Throwable ex, Scope scope) {
        int status = ((HttpServletResponse)HttpServletResponse.class.cast(response)).getStatus();
        Span span = scope.span();
        Tags.HTTP_STATUS.set(span, Integer.valueOf(status == 200 ? 500 : status));
        if (this.forceStackLog) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
            LinkedHashMap<String, Object> logs = new LinkedHashMap<String, Object>();
            logs.put("event", Tags.ERROR.getKey());
            logs.put("error.object", ex);
            span.log(logs);
        }
    }

    private Optional<Scope> getCurrentScope(ServletRequest request) {
        return Optional.ofNullable(Optional.ofNullable(request.getAttribute(OpenTracingFilter.class.getName())).orElseGet(() -> this.tracer.scopeManager().active())).map(Scope.class::cast);
    }

    protected String buildServletOperationName(HttpServletRequest req) {
        return req.getMethod() + ":" + req.getRequestURL();
    }
}

