/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.thread;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.concurrent.Callable;

public class ScopePropagatingCallable<B>
implements Callable<B> {
    private final Callable<B> delegate;
    private final Tracer tracer;

    public ScopePropagatingCallable(Callable<B> delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    private Span before() {
        return this.tracer.activeSpan();
    }

    private void after(Span span, RuntimeException error) {
        if (span != null && error != null) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
            if (error.getMessage() != null) {
                span.setTag("errorMessage", error.getMessage());
                span.setTag("errorType", error.getClass().getName());
            }
        }
    }

    @Override
    public B call() throws Exception {
        RuntimeException error = null;
        Span span = this.before();
        try {
            B b = this.delegate.call();
            return b;
        }
        catch (RuntimeException re) {
            error = re;
            throw re;
        }
        finally {
            this.after(span, error);
        }
    }
}

