/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.impl;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.impl.FinishedSpan;
import org.apache.geronimo.microprofile.opentracing.common.impl.IdGenerator;
import org.apache.geronimo.microprofile.opentracing.common.impl.JaxRsHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.common.impl.ServletHeaderTextMap;
import org.apache.geronimo.microprofile.opentracing.common.impl.SpanBuilderImpl;
import org.apache.geronimo.microprofile.opentracing.common.impl.SpanContextImpl;
import org.apache.geronimo.microprofile.opentracing.common.impl.SpanImpl;
import org.apache.geronimo.microprofile.opentracing.common.spi.Bus;

public class GeronimoTracer
implements Tracer {
    private ScopeManager scopeManager;
    private IdGenerator idGenerator;
    private Bus<FinishedSpan> finishedSpanEvent;
    private GeronimoOpenTracingConfig config;
    private String parentSpanIdHeader;
    private String spanIdHeader;
    private String traceIdHeader;
    private String baggageHeaderPrefix;

    public void init() {
        this.parentSpanIdHeader = this.config.read("propagation.headers.parentSpanId", "X-B3-ParentSpanId");
        this.spanIdHeader = this.config.read("propagation.headers.spanId", "X-B3-SpanId");
        this.traceIdHeader = this.config.read("propagation.headers.traceId", "X-B3-TraceId");
        this.baggageHeaderPrefix = this.config.read("propagation.headers.baggagePrefix", "baggage-");
    }

    public void setScopeManager(ScopeManager scopeManager) {
        this.scopeManager = scopeManager;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setFinishedSpanEvent(Bus<FinishedSpan> finishedSpanEvent) {
        this.finishedSpanEvent = finishedSpanEvent;
    }

    public void setConfig(GeronimoOpenTracingConfig config) {
        this.config = config;
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return Optional.ofNullable(this.scopeManager.active()).map(Scope::span).orElse(null);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilderImpl(this, span -> this.finishedSpanEvent.fire(new FinishedSpan(this.processNewSpan((SpanImpl)span))), operationName, this.idGenerator);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (!TextMap.class.isInstance(carrier)) {
            throw new IllegalArgumentException("Only TextMap are supported");
        }
        TextMap textMap = (TextMap)TextMap.class.cast(carrier);
        SpanContextImpl context = (SpanContextImpl)SpanContextImpl.class.cast(spanContext);
        textMap.put(this.traceIdHeader, String.valueOf(context.getTraceId()));
        textMap.put(this.spanIdHeader, String.valueOf(context.getSpanId()));
        context.getBaggageItems().forEach((k, v) -> textMap.put(this.baggageHeaderPrefix + k, v));
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (JaxRsHeaderTextMap.class.isInstance(carrier)) {
            MultivaluedMap<String, ?> map = ((JaxRsHeaderTextMap)JaxRsHeaderTextMap.class.cast(carrier)).getMap();
            String traceid = (String)map.getFirst((Object)this.traceIdHeader);
            String spanid = (String)map.getFirst((Object)this.spanIdHeader);
            String parentspanid = (String)map.getFirst((Object)this.parentSpanIdHeader);
            if (traceid != null && spanid != null) {
                return this.newContext(traceid, parentspanid, spanid, map.keySet().stream().filter(it -> it.startsWith(this.baggageHeaderPrefix)).collect(Collectors.toMap(Function.identity(), k -> String.valueOf(map.getFirst(k)))));
            }
            return null;
        }
        if (ServletHeaderTextMap.class.isInstance(carrier)) {
            HttpServletRequest req = ((ServletHeaderTextMap)ServletHeaderTextMap.class.cast(carrier)).getRequest();
            String traceid = req.getHeader(this.traceIdHeader);
            String spanid = req.getHeader(this.spanIdHeader);
            String parentspanid = req.getHeader(this.parentSpanIdHeader);
            if (traceid != null && spanid != null) {
                return this.newContext(traceid, parentspanid, spanid, Collections.list(req.getHeaderNames()).stream().filter(it -> it.startsWith(this.baggageHeaderPrefix)).collect(Collectors.toMap(Function.identity(), k -> String.valueOf(req.getHeader(k)))));
            }
            return null;
        }
        if (!TextMap.class.isInstance(carrier)) {
            throw new IllegalArgumentException("Only TextMap are supported");
        }
        Iterator textMap = ((TextMap)TextMap.class.cast(carrier)).iterator();
        String traceId = null;
        String spanId = null;
        String parentSpanId = null;
        HashMap<String, String> baggages = new HashMap<String, String>();
        while (textMap.hasNext()) {
            Map.Entry next = (Map.Entry)textMap.next();
            if (((String)next.getKey()).startsWith(this.baggageHeaderPrefix)) {
                baggages.put((String)next.getKey(), (String)next.getValue());
                continue;
            }
            if (this.spanIdHeader.equals(next.getKey())) {
                spanId = (String)next.getValue();
                continue;
            }
            if (this.traceIdHeader.equals(next.getKey())) {
                traceId = (String)next.getValue();
                continue;
            }
            if (!this.parentSpanIdHeader.equals(next.getKey())) continue;
            parentSpanId = (String)next.getValue();
        }
        if (traceId != null && spanId != null) {
            return this.newContext(traceId, parentSpanId, spanId, baggages);
        }
        return null;
    }

    protected Span processNewSpan(SpanImpl span) {
        return span;
    }

    protected SpanContextImpl newContext(Object traceId, Object parentSpanId, Object spanId, Map<String, String> baggages) {
        return new SpanContextImpl(traceId, parentSpanId, spanId, baggages);
    }
}

