/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.cdi;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.geronimo.jcache.simple.cdi.CDIJCacheHelper;
import org.apache.geronimo.jcache.simple.cdi.CacheKeyInvocationContextImpl;

@CacheRemove
@Interceptor
@Priority(value=1000)
public class CacheRemoveInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CDIJCacheHelper.MethodMeta methodMeta = this.helper.findMeta(ic);
        String cacheName = methodMeta.getCacheRemoveCacheName();
        CacheResolverFactory cacheResolverFactory = methodMeta.getCacheRemoveResolverFactory();
        CacheKeyInvocationContextImpl<CacheRemove> context = new CacheKeyInvocationContextImpl<CacheRemove>(ic, methodMeta.getCacheRemove(), cacheName, methodMeta);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        GeneratedCacheKey cacheKey = methodMeta.getCacheRemoveKeyGenerator().generateCacheKey(context);
        CacheRemove cacheRemove = methodMeta.getCacheRemove();
        boolean afterInvocation = methodMeta.isCacheRemoveAfter();
        if (!afterInvocation) {
            cache.remove((Object)cacheKey);
        }
        try {
            result = ic.proceed();
            if (CompletionStage.class.isInstance(result)) {
                CompletionStage completionStage = (CompletionStage)CompletionStage.class.cast(result);
                completionStage.exceptionally(t -> {
                    if (afterInvocation && this.helper.isIncluded(t.getClass(), cacheRemove.evictFor(), cacheRemove.noEvictFor())) {
                        cache.remove((Object)cacheKey);
                    }
                    if (RuntimeException.class.isInstance(t)) {
                        throw (RuntimeException)RuntimeException.class.cast(t);
                    }
                    throw new IllegalStateException((Throwable)t);
                });
            }
        }
        catch (Throwable t2) {
            if (afterInvocation && this.helper.isIncluded(t2.getClass(), cacheRemove.evictFor(), cacheRemove.noEvictFor())) {
                cache.remove((Object)cacheKey);
            }
            throw t2;
        }
        if (afterInvocation) {
            cache.remove((Object)cacheKey);
        }
        return result;
    }
}

