/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import org.apache.geronimo.config.ConfigImpl;
import org.apache.geronimo.config.ConfigValueImpl;
import org.apache.geronimo.config.cdi.ConfigExtension;
import org.apache.geronimo.config.cdi.ConfigInjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigInjectionBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>();
    private final BeanManager bm;
    private final Class rawType;
    private final Set<Type> types;
    private final String id;
    private ConfigImpl _config;

    public ConfigInjectionBean(BeanManager bm, Type type) {
        this.bm = bm;
        this.types = new HashSet<Type>();
        this.types.add(type);
        this.rawType = this.getRawType(type);
        this.id = "ConfigInjectionBean_" + this.types;
    }

    private Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            return (Class)paramType.getRawType();
        }
        throw new UnsupportedOperationException("No idea how to handle " + type);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this.rawType;
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> context) {
        InjectionPoint ip = (InjectionPoint)this.bm.getInjectableReference((InjectionPoint)new ConfigInjectionPoint(this), context);
        if (ip == null) {
            throw new IllegalStateException("Could not retrieve InjectionPoint");
        }
        Annotated annotated = ip.getAnnotated();
        ConfigProperty configProperty = (ConfigProperty)annotated.getAnnotation(ConfigProperty.class);
        String key = ConfigInjectionBean.getConfigKey(ip, configProperty);
        String defaultValue = configProperty.defaultValue();
        return this.toInstance(annotated.getBaseType(), key, defaultValue, true, false);
    }

    private T toInstance(Type baseType, String key, String defaultValue, boolean skipProviderLevel, boolean acceptNull) {
        if (baseType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)baseType;
            Type rawType = paramType.getRawType();
            if (paramType.getActualTypeArguments().length == 0) {
                throw new IllegalArgumentException("No argument to " + paramType);
            }
            Type arg = paramType.getActualTypeArguments()[0];
            if (!Class.class.isInstance(arg)) {
                if (ParameterizedType.class.isInstance(arg)) {
                    ParameterizedType nested = (ParameterizedType)ParameterizedType.class.cast(arg);
                    if (rawType == Optional.class) {
                        return (T)Optional.of(this.toInstance(nested, key, defaultValue, false, acceptNull));
                    }
                    if (rawType == Provider.class) {
                        if (nested.getActualTypeArguments().length != 1) {
                            throw new IllegalArgumentException("Invalid arguments for " + paramType);
                        }
                        return (T)(skipProviderLevel ? this.toInstance(nested, key, defaultValue, false, acceptNull) : () -> this.toInstance(nested, key, defaultValue, false, acceptNull));
                    }
                    if (rawType == Supplier.class) {
                        if (nested.getActualTypeArguments().length != 1) {
                            throw new IllegalArgumentException("Invalid arguments for " + paramType);
                        }
                        return (T)((Supplier<Object>)() -> this.toInstance(nested, key, defaultValue, false, true));
                    }
                }
                throw new IllegalArgumentException("Unsupported multiple generics level: " + paramType);
            }
            Class clazzParam = (Class)arg;
            if (rawType instanceof Class && rawType == Provider.class && paramType.getActualTypeArguments().length == 1) {
                return (T)(skipProviderLevel ? this.toInstance(clazzParam, key, defaultValue, false, acceptNull) : () -> this.toInstance(clazzParam, key, defaultValue, false, acceptNull));
            }
            if (rawType instanceof Class && rawType == Optional.class && paramType.getActualTypeArguments().length == 1) {
                return (T)this.getConfig().getOptionalValue(key, clazzParam);
            }
            if (rawType instanceof Class && rawType == Supplier.class && paramType.getActualTypeArguments().length == 1) {
                return (T)((Supplier<Object>)() -> this.toInstance(clazzParam, key, defaultValue, false, true));
            }
            if (Set.class.equals((Object)rawType)) {
                return (T)new HashSet(this.getList(key, clazzParam, defaultValue));
            }
            if (List.class.equals((Object)rawType)) {
                return (T)this.getList(key, clazzParam, defaultValue);
            }
            throw new IllegalStateException("unhandled ConfigProperty");
        }
        Class clazz = (Class)baseType;
        return this.getConfigValue(key, defaultValue, clazz, acceptNull);
    }

    private List getList(String key, Class clazzParam, String defaultValue) {
        ConfigValueImpl configValue = this.getConfig().access(key).as(clazzParam).asList().evaluateVariables(true);
        if (!ConfigExtension.isDefaultUnset(defaultValue)) {
            configValue.withStringDefault(defaultValue);
        }
        return configValue.get();
    }

    private T getConfigValue(String key, String defaultValue, Class clazz, boolean canBeNull) {
        if (ConfigExtension.isDefaultUnset(defaultValue)) {
            if (canBeNull) {
                return this.getConfig().getOptionalValue(key, clazz).orElse(null);
            }
            return this.getConfig().getValue(key, clazz);
        }
        ConfigImpl config = this.getConfig();
        return config.getOptionalValue(key, clazz).orElse(config.convert(defaultValue, clazz));
    }

    static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (key.length() > 0) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            return declaringType.getJavaClass().getCanonicalName() + "." + member.getJavaMember().getName();
        }
        throw new IllegalStateException("Could not find default name for @ConfigProperty InjectionPoint " + ip);
    }

    public ConfigImpl getConfig() {
        if (this._config == null) {
            this._config = (ConfigImpl)ConfigProvider.getConfig();
        }
        return this._config;
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return QUALIFIERS;
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.id;
    }

    static {
        QUALIFIERS.add((Annotation)((Object)new ConfigPropertyLiteral()));
    }

    private static class ConfigPropertyLiteral
    extends AnnotationLiteral<ConfigProperty>
    implements ConfigProperty {
        private ConfigPropertyLiteral() {
        }

        public String name() {
            return "";
        }

        public String defaultValue() {
            return "";
        }
    }
}

