/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.security;

import java.io.IOException;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.service.security.event.OnCommand;

@Provider
@Dependent
public class CommandSecurityProvider
implements ContainerRequestFilter {
    public static final String SKIP = CommandSecurityProvider.class.getName() + ".skip";
    @Context
    private HttpServletRequest request;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private Event<OnCommand> onConnectionEvent;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (Boolean.TRUE.equals(this.request.getAttribute(SKIP))) {
            return;
        }
        OnCommand onCommand = new OnCommand(this.resourceInfo.getResourceClass(), this.resourceInfo.getResourceMethod());
        this.onConnectionEvent.fire((Object)onCommand);
        if (!onCommand.isValid()) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new ErrorPayload(ErrorDictionary.UNAUTHORIZED, "Invalid command credentials")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

