/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service.jcache;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.configuration.Configuration;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.geronimo.jcache.simple.cdi.CacheResolverImpl;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.server.front.EnvironmentResourceImpl;
import org.talend.sdk.component.server.front.model.Environment;
import org.talend.sdk.components.vault.jcache.CacheConfigurationFactory;
import org.talend.sdk.components.vault.jcache.CacheSizeManager;

@ApplicationScoped
public class FrontCacheResolver
implements CacheResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(FrontCacheResolver.class);
    @Inject
    private CacheManager cacheManager;
    @Inject
    private CacheConfigurationFactory cacheConfiguration;
    @Inject
    @Documentation(value="How often (in ms) should we invalidate the credentials caches.")
    @ConfigProperty(name="talend.vault.cache.jcache.refresh.period", defaultValue="30000")
    private Long refreshPeriod;
    @Inject
    EnvironmentResourceImpl env;
    private long lastUpdated;
    private volatile boolean running = true;
    private Thread thread;

    @PostConstruct
    private void startRefresh() {
        this.lastUpdated = System.currentTimeMillis();
        this.thread = new Thread(() -> this.refreshThread(this.refreshPeriod));
        this.thread.setName(this.getClass().getName() + "-refresher");
        this.thread.setPriority(5);
        this.thread.setDaemon(false);
        this.thread.setUncaughtExceptionHandler((t, e) -> log.error(e.getMessage(), e));
        this.thread.start();
    }

    @PreDestroy
    private void stopRefresh() {
        this.running = false;
        Optional.ofNullable(this.thread).ifPresent(it -> {
            try {
                it.interrupt();
                it.join(TimeUnit.SECONDS.toMillis(5L));
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage());
                Thread.currentThread().interrupt();
            }
        });
    }

    private void refreshThread(long delay) {
        try {
            while (this.running) {
                try {
                    this.updateIfNeeded();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private void updateIfNeeded() {
        Environment environment = this.env.get();
        if (this.lastUpdated < environment.getLastUpdated().getTime()) {
            this.clearCaches();
            this.lastUpdated = System.currentTimeMillis();
        }
    }

    public void clearCaches() {
        StreamSupport.stream(this.cacheManager.getCacheNames().spliterator(), false).filter(name -> name.startsWith("org.talend.sdk.component.server.front.")).peek(c -> log.info("[clearCaches] clear cache {}.", c)).forEach(r -> this.cacheManager.getCache(r).clear());
    }

    public CacheResolver getCacheResolver(CacheMethodDetails<? extends Annotation> cacheMethodDetails) {
        return this.findCacheResolver(cacheMethodDetails.getCacheName());
    }

    public CacheResolver getExceptionCacheResolver(CacheMethodDetails<CacheResult> cacheMethodDetails) {
        return this.findCacheResolver(((CacheResult)cacheMethodDetails.getCacheAnnotation()).exceptionCacheName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResolver findCacheResolver(String exceptionCacheName) {
        Cache cache = this.cacheManager.getCache(exceptionCacheName);
        if (cache == null) {
            try {
                FrontCacheResolver frontCacheResolver = this;
                synchronized (frontCacheResolver) {
                    cache = this.createCache(exceptionCacheName);
                }
            }
            catch (Exception ce) {
                log.warn("[findCacheResolver] createCache failed: {}.", (Object)ce.getMessage());
                cache = this.cacheManager.getCache(exceptionCacheName);
            }
        }
        return new CacheResolverImpl(cache);
    }

    private Cache<?, ?> createCache(String exceptionCacheName) {
        log.debug("[createCache] {}", (Object)exceptionCacheName);
        CacheSizeManager listener = new CacheSizeManager(this.cacheConfiguration.maxSize());
        Configuration configuration = this.cacheConfiguration.createConfiguration(listener);
        Cache instance = this.cacheManager.createCache(exceptionCacheName, configuration);
        listener.accept(instance);
        return instance;
    }
}

