/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.design.extension.DesignModel;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.internationalization.ComponentBundle;
import org.talend.sdk.component.runtime.internationalization.FamilyBundle;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.server.api.ComponentResource;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.dao.ComponentDao;
import org.talend.sdk.component.server.dao.ComponentFamilyDao;
import org.talend.sdk.component.server.front.base.internal.RequestKey;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ComponentId;
import org.talend.sdk.component.server.front.model.ComponentIndex;
import org.talend.sdk.component.server.front.model.ComponentIndices;
import org.talend.sdk.component.server.front.model.Dependencies;
import org.talend.sdk.component.server.front.model.DependencyDefinition;
import org.talend.sdk.component.server.front.model.ErrorDictionary;
import org.talend.sdk.component.server.front.model.Icon;
import org.talend.sdk.component.server.front.model.IconSymbol;
import org.talend.sdk.component.server.front.model.Link;
import org.talend.sdk.component.server.front.model.SimplePropertyDefinition;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.server.front.security.SecurityUtils;
import org.talend.sdk.component.server.lang.MapCache;
import org.talend.sdk.component.server.service.ActionsService;
import org.talend.sdk.component.server.service.ComponentManagerService;
import org.talend.sdk.component.server.service.ExtensionComponentMetadataManager;
import org.talend.sdk.component.server.service.IconResolver;
import org.talend.sdk.component.server.service.LocaleMapper;
import org.talend.sdk.component.server.service.PropertiesService;
import org.talend.sdk.component.server.service.SimpleQueryLanguageCompiler;
import org.talend.sdk.component.server.service.VirtualDependenciesService;
import org.talend.sdk.component.server.service.event.DeployedComponent;
import org.talend.sdk.component.server.service.jcache.FrontCacheKeyGenerator;
import org.talend.sdk.component.server.service.jcache.FrontCacheResolver;
import org.talend.sdk.component.spi.component.ComponentExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ApplicationScoped
@CacheDefaults(cacheResolverFactory=FrontCacheResolver.class, cacheKeyGenerator=FrontCacheKeyGenerator.class)
public class ComponentResourceImpl
implements ComponentResource {
    private static final Logger log = LoggerFactory.getLogger(ComponentResourceImpl.class);
    public static final String BASE64_PREFIX = "base64://";
    public static final String COMPONENT_TYPE_STANDALONE = "standalone";
    public static final String COMPONENT_TYPE_INPUT = "input";
    public static final String COMPONENT_TYPE_PROCESSOR = "processor";
    public static final String MSG_NO_PLUGIN = "No plugin '";
    public static final String MSG_NO_ICON_FOR_FAMILY = "No icon for family: ";
    public static final String MSG_NO_FAMILY_FOR_IDENTIFIER = "No family for identifier: ";
    public static final String THEME_DARK = "dark";
    public static final String THEME_LIGHT = "light";
    public static final String THEME_ALL = "all";
    public static final String IMAGE_SVG_XML_TYPE = "image/svg+xml";
    private final ConcurrentMap<RequestKey, ComponentIndices> indicesPerRequest = new ConcurrentHashMap<RequestKey, ComponentIndices>();
    @Inject
    private ComponentManager manager;
    @Inject
    private ComponentManagerService componentManagerService;
    @Inject
    private ComponentDao componentDao;
    @Inject
    private ComponentFamilyDao componentFamilyDao;
    @Inject
    private LocaleMapper localeMapper;
    @Inject
    private ActionsService actionsService;
    @Inject
    private PropertiesService propertiesService;
    @Inject
    private IconResolver iconResolver;
    @Inject
    private ComponentServerConfiguration configuration;
    @Inject
    private VirtualDependenciesService virtualDependenciesService;
    @Inject
    private ExtensionComponentMetadataManager virtualComponents;
    @Inject
    private MapCache caches;
    @Inject
    private SimpleQueryLanguageCompiler queryLanguageCompiler;
    @Inject
    @Context
    private HttpHeaders headers;
    @Inject
    private SecurityUtils secUtils;
    private String defaultTheme;
    private final Map<String, Function<ComponentIndex, Object>> componentEvaluators = new HashMap<String, Function<ComponentIndex, Object>>();

    @PostConstruct
    private void setupRuntime() {
        log.info("[setupRuntime] Initializing " + this.getClass());
        this.defaultTheme = this.configuration.getIconDefaultTheme();
        String themeMode = this.configuration.getSupportIconTheme() != false ? "themed" : "legacy";
        log.info("[setupRuntime] Icon mode: {}; default theme: {}.", (Object)themeMode, (Object)this.defaultTheme);
        this.getIndex("en", false, null, this.defaultTheme);
        this.componentEvaluators.put("plugin", c -> c.getId().getPlugin());
        this.componentEvaluators.put("id", c -> c.getId().getId());
        this.componentEvaluators.put("familyId", c -> c.getId().getFamilyId());
        this.componentEvaluators.put("name", c -> c.getId().getName());
        this.componentEvaluators.put("metadata", component -> {
            Iterator iterator = ((ComponentDetail)this.getDetail("en", new String[]{component.getId().getId()}).getDetails().iterator().next()).getProperties().iterator();
            if (iterator.hasNext()) {
                return ((SimplePropertyDefinition)iterator.next()).getMetadata();
            }
            return Collections.emptyMap();
        });
    }

    public void clearCache(@Observes DeployedComponent deployedComponent) {
        this.indicesPerRequest.clear();
    }

    @CacheResult
    public Dependencies getDependencies(String[] ids) {
        if (ids.length == 0) {
            return new Dependencies(Collections.emptyMap());
        }
        HashMap<String, DependencyDefinition> dependencies = new HashMap<String, DependencyDefinition>();
        for (String id : ids) {
            if (this.virtualComponents.isExtensionEntity(id)) {
                DependencyDefinition deps = Optional.ofNullable(this.virtualComponents.getDependenciesFor(id)).orElseGet(() -> new DependencyDefinition(Collections.emptyList()));
                dependencies.put(id, deps);
                continue;
            }
            ComponentFamilyMeta.BaseMeta meta = this.componentDao.findById(id);
            if (meta == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component matching the id: " + id)).build());
            }
            dependencies.put(meta.getId(), this.getDependenciesFor(meta));
        }
        return new Dependencies(dependencies);
    }

    @CacheResult
    public StreamingOutput getDependency(String id) {
        Supplier<InputStream> streamProvider;
        ComponentFamilyMeta.BaseMeta component = this.componentDao.findById(id);
        if (component != null) {
            Path file = (Path)((Container)this.componentManagerService.manager().findPlugin(component.getParent().getPlugin()).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No plugin matching the id: " + id)).build()))).getContainerFile().orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No dependency matching the id: " + id)).build()));
            if (!Files.exists(file, new LinkOption[0])) {
                return this.onMissingJar(id);
            }
            streamProvider = () -> {
                try {
                    return Files.newInputStream(file, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            };
        } else {
            Artifact artifact = Artifact.from((String)id);
            if (this.virtualDependenciesService.isVirtual(id)) {
                streamProvider = this.virtualDependenciesService.retrieveArtifact(artifact);
                if (streamProvider == null) {
                    return this.onMissingJar(id);
                }
            } else {
                Path file = this.componentManagerService.manager().getContainer().resolve(artifact.toPath());
                if (!Files.exists(file, new LinkOption[0])) {
                    return this.onMissingJar(id);
                }
                streamProvider = () -> {
                    try {
                        return Files.newInputStream(file, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                };
            }
        }
        return output -> {
            byte[] buffer = new byte[40960];
            try (BufferedInputStream stream = new BufferedInputStream((InputStream)streamProvider.get(), buffer.length);){
                int count;
                while ((count = ((InputStream)stream).read(buffer)) >= 0) {
                    if (count == 0) continue;
                    output.write(buffer, 0, count);
                }
            }
        };
    }

    @CacheResult
    public ComponentIndices getIndex(String language, boolean includeIconContent, String query, String theme) {
        Locale locale = this.localeMapper.mapLocale(language);
        String themedIcon = theme == null ? this.defaultTheme : theme;
        this.caches.evictIfNeeded(this.indicesPerRequest, this.configuration.getMaxCacheSize() - 1);
        return this.indicesPerRequest.computeIfAbsent(new RequestKey(locale, includeIconContent, query, themedIcon), k -> {
            Predicate filter = this.queryLanguageCompiler.compile(query, this.componentEvaluators);
            return new ComponentIndices(Stream.concat(this.findDeployedComponents(includeIconContent, locale, themedIcon), this.virtualComponents.getDetails().stream().map(detail -> new ComponentIndex(detail.getId(), detail.getDisplayName(), detail.getId().getFamily(), detail.getType(), new Icon(detail.getIcon(), null, null, themedIcon), new Icon(this.virtualComponents.getFamilyIconFor(detail.getId().getFamilyId()), null, null, themedIcon), detail.getVersion(), Collections.singletonList(detail.getId().getFamily()), detail.getLinks(), detail.getMetadata()))).filter(filter).collect(Collectors.toList()));
        });
    }

    @CacheResult
    public Response familyIcon(String id, String theme) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, MSG_NO_ICON_FOR_FAMILY + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ComponentFamilyMeta meta = this.componentFamilyDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.FAMILY_MISSING, MSG_NO_FAMILY_FOR_IDENTIFIER + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, MSG_NO_PLUGIN + meta.getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon(), theme);
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for family identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @CacheResult
    public Response icon(String familyId, String iconKey, String theme) {
        if (this.virtualComponents.isExtensionEntity(familyId)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, MSG_NO_ICON_FOR_FAMILY + familyId)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ComponentFamilyMeta meta = this.componentFamilyDao.findById(familyId);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.FAMILY_MISSING, MSG_NO_FAMILY_FOR_IDENTIFIER + familyId)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, MSG_NO_PLUGIN + meta.getPlugin() + "' for family identifier: " + familyId)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), iconKey, theme);
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for icon key: " + iconKey)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @CacheResult
    public Response icon(String id, String theme) {
        if (this.virtualComponents.isExtensionEntity(id)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, MSG_NO_ICON_FOR_FAMILY + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ComponentFamilyMeta.BaseMeta meta = this.componentDao.findById(id);
        if (meta == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
        if (!plugin.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, MSG_NO_PLUGIN + meta.getParent().getPlugin() + "' for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        IconResolver.Icon iconContent = this.iconResolver.resolve((Container)plugin.get(), meta.getIcon(), theme);
        if (iconContent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No icon for identifier: " + id)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.ok((Object)iconContent.getBytes()).type(iconContent.getType()).build();
    }

    @CacheResult
    public Response getIconIndex(String theme) {
        String themedIcon = theme == null ? this.defaultTheme : theme;
        try {
            Map<String, IconSymbol> icons = this.collectIcons(themedIcon);
            if (icons.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.ICON_MISSING, "No svg icon available")).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            Document doc = factory.newDocumentBuilder().newDocument();
            Element root = doc.createElement("svg");
            root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
            root.setAttribute("focusable", "false");
            root.setAttribute("class", "sr-only");
            root.setAttribute("data-theme", themedIcon);
            doc.appendChild(root);
            icons.values().forEach(icon -> {
                Element symbol = doc.createElement("symbol");
                symbol.setAttribute("id", String.format("%s-%s", icon.getIcon(), icon.getTheme()));
                symbol.setAttribute("data-theme", icon.getTheme());
                symbol.setAttribute("data-type", icon.getType());
                symbol.setAttribute("data-family", icon.getFamily());
                if ("connector".equals(icon.getType())) {
                    symbol.setAttribute("data-connector", icon.getConnector());
                }
                symbol.setTextContent(new String(icon.getContent()));
                root.appendChild(symbol);
            });
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String svgs = ((Object)writer).toString().replace("&lt;", "<").replace("&gt;", ">");
            return Response.ok((Object)svgs).type(IMAGE_SVG_XML_TYPE).build();
        }
        catch (Exception e) {
            log.error("[getIconIndex] {}", (Object)e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorPayload(ErrorDictionary.UNEXPECTED, e.getMessage())).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    public Map<String, String> migrate(String id, int version, Map<String, String> config) {
        Map<String, String> configuration = config.entrySet().stream().map(e -> {
            if (((String)e.getValue()).startsWith(BASE64_PREFIX)) {
                String value = new String(Base64.getUrlDecoder().decode(((String)e.getValue()).substring(BASE64_PREFIX.length()).getBytes(StandardCharsets.UTF_8)));
                e.setValue(value);
            }
            return e;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (this.virtualComponents.isExtensionEntity(id)) {
            return config;
        }
        ComponentFamilyMeta.BaseMeta comp = Optional.ofNullable(this.componentDao.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find component " + id)).build()));
        if (version > comp.getVersion()) {
            log.warn("[Component#migrate] Skipping {}#{} configuration migration due to incoming {} > registry {}.", new Object[]{comp.getParent().getName(), comp.getName(), version, comp.getVersion()});
            return config;
        }
        if (comp.getVersion() != version) {
            log.info("[Component#migrate] {}#{} registry version {} - incoming: {}.", new Object[]{comp.getParent().getName(), comp.getName(), comp.getVersion(), version});
        }
        return ((MigrationHandler)Optional.ofNullable(this.componentDao.findById(id)).orElseThrow(() -> new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "Didn't find component " + id)).build())).getMigrationHandler().get()).migrate(version, config);
    }

    @CacheResult
    public ComponentDetailList getDetail(String language, String[] ids) {
        if (ids == null || ids.length == 0) {
            return new ComponentDetailList(Collections.emptyList());
        }
        HashMap errors = new HashMap();
        List details = Stream.of(ids).map(id -> {
            if (this.virtualComponents.isExtensionEntity((String)id)) {
                return this.virtualComponents.findComponentById((String)id).orElseGet(() -> {
                    errors.put(id, new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No virtual component '" + id + "'"));
                    return null;
                });
            }
            return Optional.ofNullable(this.componentDao.findById((String)id)).map(meta -> {
                Optional plugin = this.manager.findPlugin(meta.getParent().getPlugin());
                if (!plugin.isPresent()) {
                    errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, MSG_NO_PLUGIN + meta.getParent().getPlugin() + "'"));
                    return null;
                }
                Container container = (Container)plugin.get();
                Optional<DesignModel> model = Optional.ofNullable((DesignModel)meta.get(DesignModel.class));
                if (!model.isPresent()) {
                    errors.put(meta.getId(), new ErrorPayload(ErrorDictionary.DESIGN_MODEL_MISSING, "No design model '" + meta.getId() + "'"));
                    return null;
                }
                Locale locale = this.localeMapper.mapLocale(language);
                String type = ComponentFamilyMeta.ProcessorMeta.class.isInstance(meta) ? COMPONENT_TYPE_PROCESSOR : (ComponentFamilyMeta.PartitionMapperMeta.class.isInstance(meta) ? COMPONENT_TYPE_INPUT : COMPONENT_TYPE_STANDALONE);
                ComponentBundle bundle = meta.findBundle((ClassLoader)container.getLoader(), locale);
                ComponentDetail componentDetail = new ComponentDetail();
                componentDetail.setLinks(Collections.emptyList());
                componentDetail.setId(this.createMetaId(container, (ComponentFamilyMeta.BaseMeta<Lifecycle>)meta));
                componentDetail.setVersion(meta.getVersion());
                componentDetail.setIcon(meta.getIcon());
                componentDetail.setInputFlows(model.get().getInputFlows());
                componentDetail.setOutputFlows(model.get().getOutputFlows());
                componentDetail.setType(type);
                componentDetail.setDisplayName(bundle.displayName().orElse(meta.getName()));
                componentDetail.setProperties((Collection)this.propertiesService.buildProperties((List)meta.getParameterMetas().get(), (ClassLoader)container.getLoader(), locale, null).collect(Collectors.toList()));
                componentDetail.setActions(this.actionsService.findActions(meta.getParent().getName(), container, locale, (ComponentFamilyMeta.BaseMeta<Lifecycle>)meta, meta.getParent().findBundle((ClassLoader)container.getLoader(), locale)));
                componentDetail.setMetadata(this.translateMetadata(meta.getMetadata(), bundle));
                return componentDetail;
            }).orElseGet(() -> {
                errors.put(id, new ErrorPayload(ErrorDictionary.COMPONENT_MISSING, "No component '" + id + "'"));
                return null;
            });
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build());
        }
        return new ComponentDetailList(details);
    }

    private Map<String, IconSymbol> collectIcons(String theme) {
        if (THEME_ALL.equals(theme)) {
            Map<String, IconSymbol> icons = this.getAllIconsForTheme(THEME_LIGHT);
            icons.putAll(this.getAllIconsForTheme(THEME_DARK));
            return icons;
        }
        return this.getAllIconsForTheme(theme);
    }

    private Map<String, IconSymbol> getAllIconsForTheme(String theme) {
        ComponentIndices index = this.getIndex(Locale.ROOT.getLanguage(), true, null, theme);
        try {
            List components = index.getComponents();
            Map<String, IconSymbol> icons = components.stream().filter(c -> c.getIconFamily().getCustomIcon() != null).filter(c -> IMAGE_SVG_XML_TYPE.equals(c.getIconFamily().getCustomIconType())).map(c -> new IconSymbol(c.getIconFamily().getIcon(), c.getFamilyDisplayName(), "family", "", theme, c.getIconFamily().getCustomIcon())).collect(Collectors.toMap(IconSymbol::getUid, UnaryOperator.identity(), (r1, r2) -> r1));
            icons.putAll(components.stream().filter(c -> c.getIcon().getCustomIcon() != null).filter(c -> IMAGE_SVG_XML_TYPE.equals(c.getIcon().getCustomIconType())).map(c -> new IconSymbol(c.getIcon().getIcon(), c.getFamilyDisplayName(), "connector", c.getDisplayName(), theme, c.getIcon().getCustomIcon())).collect(Collectors.toMap(IconSymbol::getUid, UnaryOperator.identity(), (r1, r2) -> r1)));
            return icons;
        }
        catch (Exception e) {
            log.error("[getAllIconsForTheme]", (Throwable)e);
            throw e;
        }
    }

    private Stream<ComponentIndex> findDeployedComponents(boolean includeIconContent, Locale locale, String theme) {
        return this.manager.find(c -> ((Stream)c.execute(() -> ((ContainerComponentRegistry)c.get(ContainerComponentRegistry.class)).getComponents().values().stream())).flatMap(component -> Stream.of(component.getPartitionMappers().values().stream().map(mapper -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)mapper, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent, COMPONENT_TYPE_INPUT, theme)), component.getProcessors().values().stream().map(proc -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)proc, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent, COMPONENT_TYPE_PROCESSOR, theme)), component.getDriverRunners().values().stream().map(runner -> this.toComponentIndex((Container)c, locale, c.getId(), (ComponentFamilyMeta.BaseMeta)runner, (ComponentManager.OriginalId)c.get(ComponentManager.OriginalId.class), includeIconContent, COMPONENT_TYPE_STANDALONE, theme))).flatMap(Function.identity())));
    }

    private DependencyDefinition getDependenciesFor(ComponentFamilyMeta.BaseMeta<?> meta) {
        ComponentFamilyMeta familyMeta = meta.getParent();
        Optional container = this.componentManagerService.manager().findPlugin(familyMeta.getPlugin());
        return new DependencyDefinition((Collection)container.map(c -> {
            Stream<Artifact> artifacts;
            ComponentExtension.ComponentContext context = (ComponentExtension.ComponentContext)((ComponentContexts)c.get(ComponentContexts.class)).getContexts().get(meta.getType());
            ComponentExtension extension = context.owningExtension();
            Stream<Artifact> deps = c.findDependencies();
            if (this.configuration.getAddExtensionDependencies().booleanValue() && extension != null) {
                List<Artifact> dependencies = deps.collect(Collectors.toList());
                Stream<Artifact> addDeps = this.getExtensionDependencies(extension, dependencies);
                artifacts = Stream.concat(dependencies.stream(), addDeps);
            } else {
                artifacts = deps;
            }
            return artifacts.map(Artifact::toCoordinate).collect(Collectors.toList());
        }).orElseThrow(() -> new IllegalArgumentException("Can't find container '" + meta.getId() + "'")));
    }

    private Stream<Artifact> getExtensionDependencies(ComponentExtension extension, List<Artifact> filtered) {
        return extension.getAdditionalDependencies().stream().map(Artifact::from).filter(extArtifact -> filtered.stream().map(d -> d.getGroup() + ":" + d.getArtifact()).noneMatch(ga -> ga.equals(extArtifact.getGroup() + ":" + extArtifact.getArtifact())));
    }

    private ComponentId createMetaId(Container container, ComponentFamilyMeta.BaseMeta<Lifecycle> meta) {
        return new ComponentId(meta.getId(), meta.getParent().getId(), meta.getParent().getPlugin(), Optional.ofNullable((ComponentManager.OriginalId)container.get(ComponentManager.OriginalId.class)).map(ComponentManager.OriginalId::getValue).orElse(container.getId()), meta.getParent().getName(), meta.getName());
    }

    private ComponentIndex toComponentIndex(Container container, Locale locale, String plugin, ComponentFamilyMeta.BaseMeta meta, ComponentManager.OriginalId originalId, boolean includeIcon, String type, String theme) {
        ConfigurableClassLoader loader = container.getLoader();
        String iconTheme = theme == null ? this.defaultTheme : theme;
        String icon = meta.getIcon();
        String familyIcon = meta.getParent().getIcon();
        IconResolver.Icon iconContent = this.iconResolver.resolve(container, icon, iconTheme);
        IconResolver.Icon iconFamilyContent = this.iconResolver.resolve(container, familyIcon, iconTheme);
        FamilyBundle parentBundle = meta.getParent().findBundle((ClassLoader)loader, locale);
        ComponentBundle bundle = meta.findBundle((ClassLoader)loader, locale);
        String familyDisplayName = parentBundle.displayName().orElse(meta.getParent().getName());
        List categories = Optional.ofNullable(meta.getParent().getCategories()).map(vals -> vals.stream().map(this::normalizeCategory).map(category -> category.replace("${family}", meta.getParent().getName())).map(category -> parentBundle.category(category).orElseGet(() -> category.replace("/" + meta.getParent().getName() + "/", "/" + familyDisplayName + "/"))).collect(Collectors.toList())).orElseGet(Collections::emptyList);
        return new ComponentIndex(new ComponentId(meta.getId(), meta.getParent().getId(), plugin, Optional.ofNullable(originalId).map(ComponentManager.OriginalId::getValue).orElse(plugin), meta.getParent().getName(), meta.getName()), bundle.displayName().orElse(meta.getName()), familyDisplayName, type, new Icon(icon, iconContent == null ? null : iconContent.getType(), !includeIcon ? null : (iconContent == null ? null : iconContent.getBytes()), iconTheme), new Icon(familyIcon, iconFamilyContent == null ? null : iconFamilyContent.getType(), !includeIcon ? null : (iconFamilyContent == null ? null : iconFamilyContent.getBytes()), iconTheme), meta.getVersion(), (Collection)categories, Collections.singletonList(new Link("Detail", "/component/details?identifiers=" + meta.getId(), "application/json")), this.translateMetadata(meta.getMetadata(), bundle));
    }

    private String normalizeCategory(String category) {
        if (!category.contains("${family}")) {
            return category + "/${family}";
        }
        return category;
    }

    private Map<String, String> translateMetadata(Map<String, String> source, ComponentBundle bundle) {
        return source.entrySet().stream().map(e -> bundle.displayName(((String)e.getKey()).replaceAll("::", ".")).map(it -> new AbstractMap.SimpleEntry(e.getKey(), (String)it)).orElse((Map.Entry)e)).map(t -> {
            String bundleDoc;
            if (((String)t.getKey()).equals("documentation::value") && (bundleDoc = (String)bundle.documentation().orElse(null)) != null) {
                t.setValue(bundleDoc);
            }
            return t;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private StreamingOutput onMissingJar(String id) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorPayload(ErrorDictionary.PLUGIN_MISSING, "No file found for: " + id)).build());
    }
}

