/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import lombok.Generated;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationCallback;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.ContinuationProviderFactory;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.front.cxf.CxfExtractor;
import org.talend.sdk.component.server.front.memory.InMemoryRequest;
import org.talend.sdk.component.server.front.memory.InMemoryResponse;
import org.talend.sdk.component.server.front.memory.MemoryInputStream;
import org.talend.sdk.component.server.front.memory.SimpleServletConfig;

@Dependent
@WebListener
public class WebSocketBroadcastSetup
implements ServletContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketBroadcastSetup.class);
    private static final String EOM = "^@";
    @Inject
    private Bus bus;
    @Inject
    private CxfExtractor cxf;
    @Inject
    private Instance<Application> applications;

    public void contextInitialized(ServletContextEvent sce) {
        ServerContainer container = (ServerContainer)ServerContainer.class.cast(sce.getServletContext().getAttribute(ServerContainer.class.getName()));
        JAXRSServiceFactoryBean factory = (JAXRSServiceFactoryBean)JAXRSServiceFactoryBean.class.cast(((Server)((ServerRegistry)this.bus.getExtension(ServerRegistry.class)).getServers().iterator().next()).getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName()));
        final String appBase = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.applications.iterator(), 1024), false).filter(a -> a.getClass().isAnnotationPresent(ApplicationPath.class)).map(a -> a.getClass().getAnnotation(ApplicationPath.class)).map(ApplicationPath::value).findFirst().map(s -> !s.startsWith("/") ? "/" + s : s).orElse("/api/v1");
        String version = appBase.replaceFirst("/api", "");
        DestinationRegistry registry = this.cxf.getRegistry();
        final ServletContext servletContext = sce.getServletContext();
        WebSocketRegistry webSocketRegistry = new WebSocketRegistry(registry);
        final ServletController controller = new ServletController((DestinationRegistry)webSocketRegistry, (ServletConfig)new SimpleServletConfig(servletContext, "Talend Component Kit Websocket Transport"), (HttpServlet)new ServiceListGeneratorServlet(registry, this.bus));
        webSocketRegistry.controller = controller;
        Stream.concat(factory.getClassResourceInfo().stream().flatMap(cri -> cri.getMethodDispatcher().getOperationResourceInfos().stream()).filter(cri -> cri.getAnnotatedMethod().getDeclaringClass().getName().startsWith("org.talend.")).map(ori -> {
            String uri = ori.getClassResourceInfo().getURITemplate().getValue() + ori.getURITemplate().getValue();
            return ServerEndpointConfig.Builder.create(Endpoint.class, (String)("/websocket" + version + "/" + String.valueOf(ori.getHttpMethod()).toLowerCase(Locale.ENGLISH) + uri)).configurator(new ServerEndpointConfig.Configurator((OperationResourceInfo)ori, appBase, controller, servletContext, uri){
                final /* synthetic */ OperationResourceInfo val$ori;
                final /* synthetic */ String val$appBase;
                final /* synthetic */ ServletController val$controller;
                final /* synthetic */ ServletContext val$servletContext;
                final /* synthetic */ String val$uri;
                {
                    this.val$ori = operationResourceInfo;
                    this.val$appBase = string;
                    this.val$controller = servletController;
                    this.val$servletContext = servletContext;
                    this.val$uri = string2;
                }

                public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
                    HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                    if (!this.val$ori.getProduceTypes().isEmpty()) {
                        headers.put("Content-Type", Collections.singletonList(((MediaType)this.val$ori.getProduceTypes().iterator().next()).toString()));
                    }
                    if (!this.val$ori.getConsumeTypes().isEmpty()) {
                        headers.put("Accept", Collections.singletonList(((MediaType)this.val$ori.getConsumeTypes().iterator().next()).toString()));
                    }
                    return (T)((Object)new JAXRSEndpoint(this.val$appBase, this.val$controller, this.val$servletContext, this.val$ori.getHttpMethod(), this.val$uri, headers));
                }
            }).build();
        }), Stream.of(ServerEndpointConfig.Builder.create(Endpoint.class, (String)("/websocket" + version + "/bus")).configurator(new ServerEndpointConfig.Configurator(){

            public <T> T getEndpointInstance(Class<T> clazz) throws InstantiationException {
                return (T)((Object)new JAXRSEndpoint(appBase, controller, servletContext, "GET", "/", Collections.emptyMap()));
            }
        }).build())).sorted(Comparator.comparing(ServerEndpointConfig::getPath)).peek(e -> log.info("Deploying WebSocket(path={})", (Object)e.getPath())).forEach(config -> {
            try {
                container.addEndpoint(config);
            }
            catch (DeploymentException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private static class WebSocketRegistry
    implements DestinationRegistry {
        private final DestinationRegistry delegate;
        private ServletController controller;

        private WebSocketRegistry(DestinationRegistry registry) {
            this.delegate = registry;
        }

        public void addDestination(AbstractHTTPDestination destination) {
            throw new UnsupportedOperationException();
        }

        public void removeDestination(String path) {
            throw new UnsupportedOperationException();
        }

        public AbstractHTTPDestination getDestinationForPath(String path) {
            return this.wrap(this.delegate.getDestinationForPath(path));
        }

        public AbstractHTTPDestination getDestinationForPath(String path, boolean tryDecoding) {
            return this.wrap(this.delegate.getDestinationForPath(path, tryDecoding));
        }

        public AbstractHTTPDestination checkRestfulRequest(String address) {
            return this.wrap(this.delegate.checkRestfulRequest(address));
        }

        public Collection<AbstractHTTPDestination> getDestinations() {
            return this.delegate.getDestinations();
        }

        public AbstractDestination[] getSortedDestinations() {
            return this.delegate.getSortedDestinations();
        }

        public Set<String> getDestinationsPaths() {
            return this.delegate.getDestinationsPaths();
        }

        private AbstractHTTPDestination wrap(AbstractHTTPDestination destination) {
            try {
                return destination == null ? null : new WebSocketDestination(destination, this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class WebSocketContinuation
    implements ContinuationProvider,
    Continuation {
        private final Message message;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final WebSocketRegistry registry;
        private final ContinuationCallback callback;
        private Object object;
        private boolean resumed;
        private boolean pending;
        private boolean isNew;

        private WebSocketContinuation(Message message, HttpServletRequest request, HttpServletResponse response, WebSocketRegistry registry) {
            this.message = message;
            this.request = request;
            this.response = response;
            this.registry = registry;
            this.request.setAttribute("cxf.continuation.message", (Object)message.getExchange().getInMessage());
            this.callback = (ContinuationCallback)message.getExchange().get(ContinuationCallback.class);
        }

        public Continuation getContinuation() {
            return this;
        }

        public void complete() {
            this.message.getExchange().getInMessage().remove((Object)"cxf.continuation.message");
            if (this.callback != null) {
                Exception ex = (Exception)this.message.getExchange().get(Exception.class);
                if (ex == null) {
                    this.callback.onComplete();
                } else {
                    this.callback.onError((Throwable)ex);
                }
            }
            try {
                this.response.getWriter().close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean suspend(long timeout) {
            this.isNew = false;
            this.resumed = false;
            this.pending = true;
            this.message.getExchange().getInMessage().getInterceptorChain().suspend();
            return true;
        }

        public void resume() {
            this.resumed = true;
            try {
                this.registry.controller.invoke(this.request, this.response);
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }

        public void reset() {
            this.pending = false;
            this.resumed = false;
            this.isNew = false;
            this.object = null;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean isPending() {
            return this.pending;
        }

        public boolean isResumed() {
            return this.resumed;
        }

        public boolean isTimeout() {
            return false;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object o) {
            this.object = o;
        }

        public boolean isReadyForWrite() {
            return true;
        }
    }

    private static class WebSocketContinuationFactory
    implements ContinuationProviderFactory {
        private static final String KEY = WebSocketContinuationFactory.class.getName();
        private final WebSocketRegistry registry;

        private WebSocketContinuationFactory(WebSocketRegistry registry) {
            this.registry = registry;
        }

        public ContinuationProvider createContinuationProvider(Message inMessage, HttpServletRequest req, HttpServletResponse resp) {
            return new WebSocketContinuation(inMessage, req, resp, this.registry);
        }

        public Message retrieveFromContinuation(HttpServletRequest req) {
            return (Message)Message.class.cast(req.getAttribute(KEY));
        }
    }

    private static class WebSocketDestination
    extends AbstractHTTPDestination {
        static final java.util.logging.Logger LOG = LogUtils.getL7dLogger(ServletDestination.class);
        private final AbstractHTTPDestination delegate;

        private WebSocketDestination(AbstractHTTPDestination delegate, WebSocketRegistry registry) throws IOException {
            super(delegate.getBus(), (DestinationRegistry)registry, new EndpointInfo(), delegate.getPath(), false);
            this.delegate = delegate;
            this.cproviderFactory = new WebSocketContinuationFactory(registry);
        }

        public EndpointReferenceType getAddress() {
            return this.delegate.getAddress();
        }

        public Conduit getBackChannel(Message inMessage) throws IOException {
            return this.delegate.getBackChannel(inMessage);
        }

        public EndpointInfo getEndpointInfo() {
            return this.delegate.getEndpointInfo();
        }

        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        public void setMessageObserver(MessageObserver observer) {
            throw new UnsupportedOperationException();
        }

        public MessageObserver getMessageObserver() {
            return this.delegate.getMessageObserver();
        }

        protected java.util.logging.Logger getLogger() {
            return LOG;
        }

        public Bus getBus() {
            return this.delegate.getBus();
        }

        public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Message inMessage = this.retrieveFromContinuation(req);
            if (inMessage == null) {
                inMessage = new MessageImpl();
                ExchangeImpl exchange = new ExchangeImpl();
                exchange.setInMessage(inMessage);
                this.setupMessage(inMessage, config, context, req, resp);
                exchange.setSession((org.apache.cxf.transport.Session)new HTTPSession(req));
                ((MessageImpl)MessageImpl.class.cast(inMessage)).setDestination((Destination)this);
            }
            this.delegate.invoke(config, context, req, resp);
        }

        public void finalizeConfig() {
            this.delegate.finalizeConfig();
        }

        public String getBeanName() {
            return this.delegate.getBeanName();
        }

        public EndpointReferenceType getAddressWithId(String id) {
            return this.delegate.getAddressWithId(id);
        }

        public String getId(Map<String, Object> context) {
            return this.delegate.getId(context);
        }

        public String getContextMatchStrategy() {
            return this.delegate.getContextMatchStrategy();
        }

        public boolean isFixedParameterOrder() {
            return this.delegate.isFixedParameterOrder();
        }

        public boolean isMultiplexWithAddress() {
            return this.delegate.isMultiplexWithAddress();
        }

        public HTTPServerPolicy getServer() {
            return this.delegate.getServer();
        }

        public void assertMessage(Message message) {
            this.delegate.assertMessage(message);
        }

        public boolean canAssert(QName type) {
            return this.delegate.canAssert(type);
        }

        public String getPath() {
            return this.delegate.getPath();
        }
    }

    private static class WebSocketInputStream
    extends MemoryInputStream {
        private int previous = Integer.MAX_VALUE;
        private final Queue<InputStream> queue = new LinkedList<InputStream>();

        private WebSocketInputStream(InputStream delegate) {
            super(delegate);
            this.queue.add(delegate);
        }

        @Override
        public int read() throws IOException {
            if (this.finished) {
                return -1;
            }
            if (this.previous != Integer.MAX_VALUE) {
                int result = this.previous;
                this.previous = Integer.MAX_VALUE;
                return result;
            }
            int read = this.delegate().read();
            if (read == 94) {
                this.previous = this.delegate().read();
                if (this.previous == 64) {
                    this.finished = true;
                    return -1;
                }
            }
            if (read < 0) {
                this.finished = true;
            }
            return read;
        }

        private InputStream delegate() throws IOException {
            if (this.queue.isEmpty()) {
                throw new IOException("Don't have an input stream.");
            }
            if (this.queue.peek().available() == 0) {
                this.queue.remove();
            }
            return this.queue.peek();
        }

        public void addStream(InputStream stream) {
            this.queue.add(stream);
        }
    }

    private static class JAXRSEndpoint
    extends Endpoint {
        private final String appBase;
        private final ServletController controller;
        private final ServletContext context;
        private final String defaultMethod;
        private final String defaultUri;
        private final Map<String, List<String>> baseHeaders;

        public void onOpen(Session session, EndpointConfig endpointConfig) {
            log.debug("Opened session {}", (Object)session.getId());
            session.addMessageHandler(byte[].class, (MessageHandler.Partial)new PartialMessageHandler(session));
        }

        public void onClose(Session session, CloseReason closeReason) {
            log.debug("Closed session {}", (Object)session.getId());
        }

        public void onError(Session session, Throwable throwable) {
            log.warn("Error for session {}", (Object)session.getId(), (Object)throwable);
        }

        private static String readLine(StringBuilder buffer, InputStream in) throws IOException {
            int c;
            while ((c = in.read()) != -1 && c != 10) {
                if (c == 13) continue;
                buffer.append((char)c);
            }
            if (buffer.length() == 0) {
                return null;
            }
            String string = buffer.toString();
            buffer.setLength(0);
            return string;
        }

        @Generated
        public JAXRSEndpoint(String appBase, ServletController controller, ServletContext context, String defaultMethod, String defaultUri, Map<String, List<String>> baseHeaders) {
            this.appBase = appBase;
            this.controller = controller;
            this.context = context;
            this.defaultMethod = defaultMethod;
            this.defaultUri = defaultUri;
            this.baseHeaders = baseHeaders;
        }

        @Generated
        public String getAppBase() {
            return this.appBase;
        }

        @Generated
        public ServletController getController() {
            return this.controller;
        }

        @Generated
        public ServletContext getContext() {
            return this.context;
        }

        @Generated
        public String getDefaultMethod() {
            return this.defaultMethod;
        }

        @Generated
        public String getDefaultUri() {
            return this.defaultUri;
        }

        @Generated
        public Map<String, List<String>> getBaseHeaders() {
            return this.baseHeaders;
        }

        @Generated
        public String toString() {
            return "WebSocketBroadcastSetup.JAXRSEndpoint(appBase=" + this.getAppBase() + ", controller=" + this.getController() + ", context=" + this.getContext() + ", defaultMethod=" + this.getDefaultMethod() + ", defaultUri=" + this.getDefaultUri() + ", baseHeaders=" + this.getBaseHeaders() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JAXRSEndpoint)) {
                return false;
            }
            JAXRSEndpoint other = (JAXRSEndpoint)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$appBase = this.getAppBase();
            String other$appBase = other.getAppBase();
            if (this$appBase == null ? other$appBase != null : !this$appBase.equals(other$appBase)) {
                return false;
            }
            ServletController this$controller = this.getController();
            ServletController other$controller = other.getController();
            if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
                return false;
            }
            ServletContext this$context = this.getContext();
            ServletContext other$context = other.getContext();
            if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
                return false;
            }
            String this$defaultMethod = this.getDefaultMethod();
            String other$defaultMethod = other.getDefaultMethod();
            if (this$defaultMethod == null ? other$defaultMethod != null : !this$defaultMethod.equals(other$defaultMethod)) {
                return false;
            }
            String this$defaultUri = this.getDefaultUri();
            String other$defaultUri = other.getDefaultUri();
            if (this$defaultUri == null ? other$defaultUri != null : !this$defaultUri.equals(other$defaultUri)) {
                return false;
            }
            Map<String, List<String>> this$baseHeaders = this.getBaseHeaders();
            Map<String, List<String>> other$baseHeaders = other.getBaseHeaders();
            return !(this$baseHeaders == null ? other$baseHeaders != null : !((Object)this$baseHeaders).equals(other$baseHeaders));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JAXRSEndpoint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appBase = this.getAppBase();
            result = result * 59 + ($appBase == null ? 43 : $appBase.hashCode());
            ServletController $controller = this.getController();
            result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
            ServletContext $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : $context.hashCode());
            String $defaultMethod = this.getDefaultMethod();
            result = result * 59 + ($defaultMethod == null ? 43 : $defaultMethod.hashCode());
            String $defaultUri = this.getDefaultUri();
            result = result * 59 + ($defaultUri == null ? 43 : $defaultUri.hashCode());
            Map<String, List<String>> $baseHeaders = this.getBaseHeaders();
            result = result * 59 + ($baseHeaders == null ? 43 : ((Object)$baseHeaders).hashCode());
            return result;
        }

        private class PartialMessageHandler
        implements MessageHandler.Partial<byte[]> {
            private final Session session;
            private InMemoryRequest request;
            private InMemoryResponse response;

            private void handleStart(StringBuilder buffer, InputStream message) {
                String path;
                String queryString;
                TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                headers.putAll(JAXRSEndpoint.this.baseHeaders);
                try {
                    String line;
                    while ((line = JAXRSEndpoint.readLine(buffer, message)) != null) {
                        boolean done = line.endsWith(WebSocketBroadcastSetup.EOM);
                        if (done) {
                            line = line.substring(0, line.length() - WebSocketBroadcastSetup.EOM.length());
                        }
                        if (!line.isEmpty()) {
                            int del = line.indexOf(58);
                            if (del < 0) {
                                headers.put(line.trim(), Collections.emptyList());
                            } else {
                                headers.put(line.substring(0, del).trim(), Collections.singletonList(line.substring(del + 1).trim()));
                            }
                        }
                        if (!done) continue;
                        break;
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
                List uris = (List)headers.get("destination");
                String uri = uris == null || uris.isEmpty() ? JAXRSEndpoint.this.defaultUri : (String)uris.iterator().next();
                List methods = (List)headers.get("destinationMethod");
                String method = methods == null || methods.isEmpty() ? JAXRSEndpoint.this.defaultMethod : (String)methods.iterator().next();
                int query = uri.indexOf(63);
                if (query > 0) {
                    queryString = uri.substring(query + 1);
                    path = uri.substring(0, query);
                } else {
                    queryString = null;
                    path = uri;
                }
                this.request = new InMemoryRequest(method.toUpperCase(Locale.ENGLISH), headers, path, JAXRSEndpoint.this.appBase + path, JAXRSEndpoint.this.appBase, queryString, 8080, JAXRSEndpoint.this.context, new WebSocketInputStream(message), () -> ((Session)this.session).getUserPrincipal(), JAXRSEndpoint.this.controller);
                this.response = new InMemoryResponse(() -> ((Session)this.session).isOpen(), () -> {
                    if (this.session.getBasicRemote().getBatchingAllowed()) {
                        try {
                            this.session.getBasicRemote().flushBatch();
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }, bytes -> {
                    try {
                        this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }, (status, responseHeaders) -> {
                    StringBuilder top = new StringBuilder("MESSAGE\r\n");
                    top.append("status: ").append(status).append("\r\n");
                    responseHeaders.forEach((k, v) -> top.append((String)k).append(": ").append(String.join((CharSequence)",", v)).append("\r\n"));
                    top.append("\r\n");
                    return top.toString();
                }){

                    @Override
                    protected void onClose(OutputStream stream) throws IOException {
                        stream.write(WebSocketBroadcastSetup.EOM.getBytes(StandardCharsets.UTF_8));
                    }
                };
                this.request.setResponse(this.response);
            }

            public void onMessage(byte[] byteBuffer, boolean last) {
                block10: {
                    ByteArrayInputStream message = new ByteArrayInputStream(byteBuffer);
                    StringBuilder buffer = new StringBuilder(128);
                    try {
                        if (this.request != null) {
                            ((WebSocketInputStream)this.request.getInputStream()).addStream(message);
                            break block10;
                        }
                        if ("SEND".equalsIgnoreCase(JAXRSEndpoint.readLine(buffer, message))) {
                            this.handleStart(buffer, message);
                            break block10;
                        }
                        throw new IllegalArgumentException("not a message");
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (last) {
                    try {
                        JAXRSEndpoint.this.controller.invoke((HttpServletRequest)this.request, (HttpServletResponse)this.response);
                    }
                    catch (ServletException e) {
                        throw new IllegalArgumentException(e);
                    }
                    finally {
                        this.request = null;
                        this.response = null;
                    }
                }
            }

            @Generated
            public PartialMessageHandler(Session session) {
                this.session = session;
            }
        }
    }
}

