/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.front;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.rrd4j.core.FetchData;
import org.talend.sdk.component.starter.server.model.ErrorMessage;
import org.talend.sdk.component.starter.server.service.rrd.RRDConfig;
import org.talend.sdk.component.starter.server.service.rrd.RRDStorage;

@ApplicationScoped
@Path(value="statistics")
public class RRDEndpoint {
    @Inject
    private RRDStorage rrd;
    @Inject
    private RRDConfig config;
    private Semaphore concurrentCalls;

    @PostConstruct
    private void init() {
        this.concurrentCalls = new Semaphore(this.config.getAcceptedConcurrentCalls());
    }

    @GET
    @Path(value="image")
    @Produces(value={"image/png"})
    public CompletionStage<InputStream> getPng(@QueryParam(value="from") @DefaultValue(value="-1") long from, @QueryParam(value="to") @DefaultValue(value="-1") long to, @QueryParam(value="width") @DefaultValue(value="1440") int width, @QueryParam(value="height") @DefaultValue(value="900") int height) {
        if (!this.concurrentCalls.tryAcquire()) {
            return this.failAcquire();
        }
        try {
            return this.rrd.render(from, to, width, height).handle(this::handle);
        }
        catch (IllegalStateException ise) {
            throw this.onError(ise);
        }
    }

    @GET
    @Path(value="json")
    @Produces(value={"application/json"})
    public CompletionStage<Points> getPoints(@QueryParam(value="from") @DefaultValue(value="-1") long from, @QueryParam(value="to") @DefaultValue(value="-1") long to, @QueryParam(value="skipNan") @DefaultValue(value="true") boolean skipNan) {
        if (!this.concurrentCalls.tryAcquire()) {
            return this.failAcquire();
        }
        try {
            return this.rrd.fetch(from, to).handle(this::handle).thenApply(data -> new Points(Stream.of(data.getDsNames()).collect(Collectors.toMap(this::getMetricName, ds -> this.mapPoints(skipNan, (FetchData)data, (String)ds)))));
        }
        catch (IllegalStateException ise) {
            throw this.onError(ise);
        }
    }

    private Collection<Point> mapPoints(boolean skipNan, FetchData data, String ds) {
        double[] values = data.getValues(ds);
        long[] timestamps = data.getTimestamps();
        return IntStream.range(0, timestamps.length).filter(idx -> !skipNan || !Double.isNaN(values[idx])).mapToObj(idx -> new Point(timestamps[idx], Double.isNaN(values[idx]) ? 0.0 : values[idx])).collect(Collectors.toList());
    }

    private String getMetricName(String it) {
        if (it.endsWith("!")) {
            return it.substring(0, it.length() - 1);
        }
        return it;
    }

    private <T> T handle(T r, Throwable t) {
        this.concurrentCalls.release();
        if (t != null) {
            throw this.onError(t);
        }
        return r;
    }

    private WebApplicationException onError(Throwable ise) {
        return new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(ise.getMessage())).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    private <T> CompletionStage<T> failAcquire() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)new WebApplicationException(Response.Status.PRECONDITION_FAILED));
        return future;
    }

    public static class Point {
        private long timestamp;
        private double value;

        public long getTimestamp() {
            return this.timestamp;
        }

        public double getValue() {
            return this.value;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            return Double.compare(this.getValue(), other.getValue()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Point;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            long $value = Double.doubleToLongBits(this.getValue());
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }

        public String toString() {
            return "RRDEndpoint.Point(timestamp=" + this.getTimestamp() + ", value=" + this.getValue() + ")";
        }

        public Point() {
        }

        public Point(long timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }

    public static class Points {
        private Map<String, Collection<Point>> points;

        public Map<String, Collection<Point>> getPoints() {
            return this.points;
        }

        public void setPoints(Map<String, Collection<Point>> points) {
            this.points = points;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Points)) {
                return false;
            }
            Points other = (Points)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Collection<Point>> this$points = this.getPoints();
            Map<String, Collection<Point>> other$points = other.getPoints();
            return !(this$points == null ? other$points != null : !((Object)this$points).equals(other$points));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Points;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Collection<Point>> $points = this.getPoints();
            result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
            return result;
        }

        public String toString() {
            return "RRDEndpoint.Points(points=" + this.getPoints() + ")";
        }

        public Points() {
        }

        public Points(Map<String, Collection<Point>> points) {
            this.points = points;
        }
    }
}

