/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.service.Resources;
import org.talend.sdk.component.starter.server.service.build.BuildGenerator;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class GradleBuildGenerator
implements BuildGenerator {
    @Inject
    private TemplateRenderer tpl;

    public void register(@Observes GeneratorRegistration init) {
        init.registerBuildType("Gradle", this);
    }

    @Override
    public Build createBuild(ProjectRequest.BuildConfiguration buildConfiguration, String packageBase, Collection<Dependency> dependencies, Collection<String> facets, ServerInfo.Snapshot versions) {
        TreeSet<String> buildDependencies = new TreeSet<String>();
        ArrayList<String> configurations = new ArrayList<String>();
        TreeSet<String> plugins = new TreeSet<String>();
        ArrayList<String> tasks = new ArrayList<String>();
        TreeSet<String> imports = new TreeSet<String>();
        TreeSet<String> javaMainSourceSets = new TreeSet<String>();
        if (facets.contains("WADL Client Generation")) {
            buildDependencies.add("org.apache.cxf:cxf-tools-wadlto-jaxrs:" + versions.getCxf());
            imports.add("org.apache.cxf.tools.common.ToolContext");
            imports.add("org.apache.cxf.tools.wadlto.WADLToJava");
            tasks.add("def wadlGeneratedFolder = \"$buildDir/generated-sources/cxf\"\ntask generateWadlClient {\n  def wadl = \"$projectDir/src/main/resources/wadl/client.xml\"\n\n  inputs.file(wadl)\n  outputs.dir(wadlGeneratedFolder)\n\n  doLast {\n    new File(wadlGeneratedFolder).mkdirs()\n\n    new WADLToJava([\n      \"-d\", wadlGeneratedFolder,\n      \"-p\", \"com.application.client.wadl\",\n      wadl\n    ] as String[]).run(new ToolContext())\n  }\n}");
            javaMainSourceSets.add("srcDir wadlGeneratedFolder");
            javaMainSourceSets.add("project.tasks.compileJava.dependsOn project.tasks.generateWadlClient");
        }
        GradleBuild model = new GradleBuild(versions.getKit(), buildConfiguration, dependencies.stream().map(d -> "test".equals(d.getScope()) ? new Dependency((Dependency)d, "testCompile") : d).map(d -> "runtime".equals(d.getScope()) ? new Dependency((Dependency)d, "compile") : d).collect(Collectors.toList()), buildDependencies, configurations, plugins, tasks, imports, javaMainSourceSets);
        return new Build(buildConfiguration.getArtifact(), buildConfiguration.getGroup(), buildConfiguration.getVersion(), "src/main/java", "src/test/java", "src/main/resources", "src/test/resources", "src/main/webapp", "build.gradle", this.tpl.render("generator/gradle/build.mustache", model), "build", this.generateWrapperFiles());
    }

    private List<FacetGenerator.InMemoryFile> generateWrapperFiles() {
        FacetGenerator.InMemoryFile mvnw = new FacetGenerator.InMemoryFile("gradlew", Resources.resourceFileToString("generator/gradle/gradlew"));
        FacetGenerator.InMemoryFile mvnwCmd = new FacetGenerator.InMemoryFile("gradlew.bat", Resources.resourceFileToString("generator/gradle/gradlew.bat"));
        FacetGenerator.InMemoryFile mvnwWrapperProps = new FacetGenerator.InMemoryFile("gradle/wrapper/gradle-wrapper.properties", Resources.resourceFileToString("generator/gradle/gradle-wrapper.properties"));
        FacetGenerator.InMemoryFile mvnwWrapperJar = new FacetGenerator.InMemoryFile("gradle/wrapper/gradle-wrapper.jar", Resources.resourceFileToBytes("generator/gradle/gradle-wrapper.jar"));
        return Arrays.asList(mvnw, mvnwCmd, mvnwWrapperProps, mvnwWrapperJar);
    }

    public static class GradleBuild {
        private final String tckVersion;
        private final ProjectRequest.BuildConfiguration build;
        private final Collection<Dependency> dependencies;
        private final Collection<String> buildDependencies;
        private final Collection<String> configurations;
        private final Collection<String> plugins;
        private final Collection<String> tasks;
        private final Collection<String> imports;
        private final Collection<String> javaMainSourceSets;

        public GradleBuild(String tckVersion, ProjectRequest.BuildConfiguration build, Collection<Dependency> dependencies, Collection<String> buildDependencies, Collection<String> configurations, Collection<String> plugins, Collection<String> tasks, Collection<String> imports, Collection<String> javaMainSourceSets) {
            this.tckVersion = tckVersion;
            this.build = build;
            this.dependencies = dependencies;
            this.buildDependencies = buildDependencies;
            this.configurations = configurations;
            this.plugins = plugins;
            this.tasks = tasks;
            this.imports = imports;
            this.javaMainSourceSets = javaMainSourceSets;
        }

        public String getTckVersion() {
            return this.tckVersion;
        }

        public ProjectRequest.BuildConfiguration getBuild() {
            return this.build;
        }

        public Collection<Dependency> getDependencies() {
            return this.dependencies;
        }

        public Collection<String> getBuildDependencies() {
            return this.buildDependencies;
        }

        public Collection<String> getConfigurations() {
            return this.configurations;
        }

        public Collection<String> getPlugins() {
            return this.plugins;
        }

        public Collection<String> getTasks() {
            return this.tasks;
        }

        public Collection<String> getImports() {
            return this.imports;
        }

        public Collection<String> getJavaMainSourceSets() {
            return this.javaMainSourceSets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleBuild)) {
                return false;
            }
            GradleBuild other = (GradleBuild)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tckVersion = this.getTckVersion();
            String other$tckVersion = other.getTckVersion();
            if (this$tckVersion == null ? other$tckVersion != null : !this$tckVersion.equals(other$tckVersion)) {
                return false;
            }
            ProjectRequest.BuildConfiguration this$build = this.getBuild();
            ProjectRequest.BuildConfiguration other$build = other.getBuild();
            if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
                return false;
            }
            Collection<Dependency> this$dependencies = this.getDependencies();
            Collection<Dependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            Collection<String> this$buildDependencies = this.getBuildDependencies();
            Collection<String> other$buildDependencies = other.getBuildDependencies();
            if (this$buildDependencies == null ? other$buildDependencies != null : !((Object)this$buildDependencies).equals(other$buildDependencies)) {
                return false;
            }
            Collection<String> this$configurations = this.getConfigurations();
            Collection<String> other$configurations = other.getConfigurations();
            if (this$configurations == null ? other$configurations != null : !((Object)this$configurations).equals(other$configurations)) {
                return false;
            }
            Collection<String> this$plugins = this.getPlugins();
            Collection<String> other$plugins = other.getPlugins();
            if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
                return false;
            }
            Collection<String> this$tasks = this.getTasks();
            Collection<String> other$tasks = other.getTasks();
            if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
                return false;
            }
            Collection<String> this$imports = this.getImports();
            Collection<String> other$imports = other.getImports();
            if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
                return false;
            }
            Collection<String> this$javaMainSourceSets = this.getJavaMainSourceSets();
            Collection<String> other$javaMainSourceSets = other.getJavaMainSourceSets();
            return !(this$javaMainSourceSets == null ? other$javaMainSourceSets != null : !((Object)this$javaMainSourceSets).equals(other$javaMainSourceSets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GradleBuild;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tckVersion = this.getTckVersion();
            result = result * 59 + ($tckVersion == null ? 43 : $tckVersion.hashCode());
            ProjectRequest.BuildConfiguration $build = this.getBuild();
            result = result * 59 + ($build == null ? 43 : $build.hashCode());
            Collection<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            Collection<String> $buildDependencies = this.getBuildDependencies();
            result = result * 59 + ($buildDependencies == null ? 43 : ((Object)$buildDependencies).hashCode());
            Collection<String> $configurations = this.getConfigurations();
            result = result * 59 + ($configurations == null ? 43 : ((Object)$configurations).hashCode());
            Collection<String> $plugins = this.getPlugins();
            result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
            Collection<String> $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            Collection<String> $imports = this.getImports();
            result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
            Collection<String> $javaMainSourceSets = this.getJavaMainSourceSets();
            result = result * 59 + ($javaMainSourceSets == null ? 43 : ((Object)$javaMainSourceSets).hashCode());
            return result;
        }

        public String toString() {
            return "GradleBuildGenerator.GradleBuild(tckVersion=" + this.getTckVersion() + ", build=" + this.getBuild() + ", dependencies=" + this.getDependencies() + ", buildDependencies=" + this.getBuildDependencies() + ", configurations=" + this.getConfigurations() + ", plugins=" + this.getPlugins() + ", tasks=" + this.getTasks() + ", imports=" + this.getImports() + ", javaMainSourceSets=" + this.getJavaMainSourceSets() + ")";
        }
    }
}

