/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.service.Resources;
import org.talend.sdk.component.starter.server.service.build.BuildGenerator;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class MavenBuildGenerator
implements BuildGenerator {
    @Inject
    private TemplateRenderer renderer;
    private Map<String, Collection<Plugin>> plugins;

    public void register(@Observes GeneratorRegistration init) {
        init.registerBuildType("Maven", this);
        this.plugins = new HashMap<String, Collection<Plugin>>();
        this.plugins.put("jar", Collections.emptyList());
    }

    @Override
    public Build createBuild(ProjectRequest.BuildConfiguration buildConfiguration, String packageBase, Collection<Dependency> dependencies, Collection<String> facets, ServerInfo.Snapshot versions) {
        return new Build(buildConfiguration.getArtifact(), buildConfiguration.getGroup(), buildConfiguration.getVersion(), "src/main/java", "src/test/java", "src/main/resources", "src/test/resources", "src/main/webapp", "pom.xml", this.renderer.render("generator/maven/pom.xml", new Pom(buildConfiguration, dependencies, this.createPlugins(facets, packageBase, this.plugins.get(buildConfiguration.getPackaging()), versions), versions.getKit())), "target", this.generateWrapperFiles());
    }

    private Collection<Plugin> createPlugins(Collection<String> facets, final String packageBase, Collection<Plugin> plugins, ServerInfo.Snapshot versions) {
        ArrayList<Plugin> buildPlugins = new ArrayList<Plugin>(plugins);
        buildPlugins.add(new Plugin("org.apache.maven.plugins", "maven-surefire-plugin", versions.getSurefire(), Collections.emptySet(), new LinkedHashMap<String, String>(){
            {
                this.put("trimStackTrace", "false");
                this.put("runOrder", "alphabetical");
            }
        }.entrySet()));
        if (facets.contains("WADL Client Generation")) {
            buildPlugins.add(new Plugin("org.apache.cxf", "cxf-wadl2java-plugin", versions.getCxf(), Collections.singleton(new Execution("generate-http-client-from-wadl", "generate-sources", "wadl2java")), new LinkedHashMap<String, String>(){
                {
                    this.put("wadlOptions", "\n            <wadlOption>\n              <wadl>${project.basedir}/src/main/resources/wadl/client.xml</wadl>\n              <packagename>" + packageBase + ".client.wadl</packagename>\n            </wadlOption>\n          ");
                }
            }.entrySet()));
        }
        return buildPlugins;
    }

    private List<FacetGenerator.InMemoryFile> generateWrapperFiles() {
        FacetGenerator.InMemoryFile mvnw = new FacetGenerator.InMemoryFile("mvnw", Resources.resourceFileToString("generator/maven/mvnw"));
        FacetGenerator.InMemoryFile mvnwCmd = new FacetGenerator.InMemoryFile("mvnw.cmd", Resources.resourceFileToString("generator/maven/mvnw.cmd"));
        FacetGenerator.InMemoryFile mvnwWrapperProps = new FacetGenerator.InMemoryFile(".mvn/wrapper/maven-wrapper.properties", Resources.resourceFileToString("generator/maven/maven-wrapper.properties"));
        FacetGenerator.InMemoryFile mvnwWrapperJar = new FacetGenerator.InMemoryFile(".mvn/wrapper/maven-wrapper.jar", Resources.resourceFileToBytes("generator/maven/maven-wrapper.jar"));
        return Arrays.asList(mvnw, mvnwCmd, mvnwWrapperProps, mvnwWrapperJar);
    }

    public static class Pom {
        private final ProjectRequest.BuildConfiguration build;
        private final Collection<Dependency> dependencies;
        private final Collection<Plugin> plugins;
        private final String pluginVersion;

        public Pom(ProjectRequest.BuildConfiguration build, Collection<Dependency> dependencies, Collection<Plugin> plugins, String pluginVersion) {
            this.build = build;
            this.dependencies = dependencies;
            this.plugins = plugins;
            this.pluginVersion = pluginVersion;
        }

        public ProjectRequest.BuildConfiguration getBuild() {
            return this.build;
        }

        public Collection<Dependency> getDependencies() {
            return this.dependencies;
        }

        public Collection<Plugin> getPlugins() {
            return this.plugins;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pom)) {
                return false;
            }
            Pom other = (Pom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProjectRequest.BuildConfiguration this$build = this.getBuild();
            ProjectRequest.BuildConfiguration other$build = other.getBuild();
            if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
                return false;
            }
            Collection<Dependency> this$dependencies = this.getDependencies();
            Collection<Dependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            Collection<Plugin> this$plugins = this.getPlugins();
            Collection<Plugin> other$plugins = other.getPlugins();
            if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
                return false;
            }
            String this$pluginVersion = this.getPluginVersion();
            String other$pluginVersion = other.getPluginVersion();
            return !(this$pluginVersion == null ? other$pluginVersion != null : !this$pluginVersion.equals(other$pluginVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pom;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProjectRequest.BuildConfiguration $build = this.getBuild();
            result = result * 59 + ($build == null ? 43 : $build.hashCode());
            Collection<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            Collection<Plugin> $plugins = this.getPlugins();
            result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
            String $pluginVersion = this.getPluginVersion();
            result = result * 59 + ($pluginVersion == null ? 43 : $pluginVersion.hashCode());
            return result;
        }

        public String toString() {
            return "MavenBuildGenerator.Pom(build=" + this.getBuild() + ", dependencies=" + this.getDependencies() + ", plugins=" + this.getPlugins() + ", pluginVersion=" + this.getPluginVersion() + ")";
        }
    }

    public static class Plugin {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Collection<Execution> executions;
        private final Collection<Map.Entry<String, String>> configuration;

        public Plugin(String groupId, String artifactId, String version, Collection<Execution> executions, Collection<Map.Entry<String, String>> configuration) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.executions = executions;
            this.configuration = configuration;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public Collection<Execution> getExecutions() {
            return this.executions;
        }

        public Collection<Map.Entry<String, String>> getConfiguration() {
            return this.configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plugin)) {
                return false;
            }
            Plugin other = (Plugin)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Collection<Execution> this$executions = this.getExecutions();
            Collection<Execution> other$executions = other.getExecutions();
            if (this$executions == null ? other$executions != null : !((Object)this$executions).equals(other$executions)) {
                return false;
            }
            Collection<Map.Entry<String, String>> this$configuration = this.getConfiguration();
            Collection<Map.Entry<String, String>> other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Plugin;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Collection<Execution> $executions = this.getExecutions();
            result = result * 59 + ($executions == null ? 43 : ((Object)$executions).hashCode());
            Collection<Map.Entry<String, String>> $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            return result;
        }

        public String toString() {
            return "MavenBuildGenerator.Plugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", executions=" + this.getExecutions() + ", configuration=" + this.getConfiguration() + ")";
        }
    }

    public static class Execution {
        private final String id;
        private final String phase;
        private final String goal;

        public Execution(String id, String phase, String goal) {
            this.id = id;
            this.phase = phase;
            this.goal = goal;
        }

        public String getId() {
            return this.id;
        }

        public String getPhase() {
            return this.phase;
        }

        public String getGoal() {
            return this.goal;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Execution)) {
                return false;
            }
            Execution other = (Execution)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$phase = this.getPhase();
            String other$phase = other.getPhase();
            if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
                return false;
            }
            String this$goal = this.getGoal();
            String other$goal = other.getGoal();
            return !(this$goal == null ? other$goal != null : !this$goal.equals(other$goal));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Execution;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $phase = this.getPhase();
            result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
            String $goal = this.getGoal();
            result = result * 59 + ($goal == null ? 43 : $goal.hashCode());
            return result;
        }

        public String toString() {
            return "MavenBuildGenerator.Execution(id=" + this.getId() + ", phase=" + this.getPhase() + ", goal=" + this.getGoal() + ")";
        }
    }
}

