/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.wadl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;

@ApplicationScoped
public class WADLFacet
implements FacetGenerator {
    private String specification;

    public void register(@Observes GeneratorRegistration init) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("generator/facet/wadl/specification.xml")));){
            this.specification = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        init.registerFacetType(this);
    }

    @Override
    public String readme() {
        return "Generates the needed classes to call HTTP endpoints defined by a WADL located at `src/main/resources/wadl/client.xml`.\nThe `wadl2java` CXF plugin generates interfaces representing the endpoints and you can create a client using CXF `JAXRSClientFactoryBean` class:\n\n[source,java]\n----\nimport org.talend.sdk.component.api.service.Service;\n\nimport org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;\n\n@Service\npublic class MyService {\n  public MyGeneratedEndpointApi newClient(final String url) {\n      return JAXRSClientFactoryBean.create(url, MyGeneratedEndpointApi.class);\n  }\n}\n----\n\nDon't forget you need to build once the project to have the generated interfaces and be able to write your client from the using the sources created in `generated-sources` folder.\n\nTIP: you can customize the way the client is created from the interface - including the providers/serializers used,\nmore details available at http://cxf.apache.org/docs/jax-rs-client-api.html.";
    }

    @Override
    public Stream<FacetGenerator.InMemoryFile> create(String packageBase, Build build, Collection<String> facets, Collection<ProjectRequest.SourceConfiguration> sources, Collection<ProjectRequest.ProcessorConfiguration> processors, ServerInfo.Snapshot versions) {
        return Stream.of(new FacetGenerator.InMemoryFile(build.getMainResourcesDirectory() + "/wadl/client.xml", this.specification));
    }

    @Override
    public Stream<Dependency> dependencies(Collection<String> facets, ServerInfo.Snapshot versions) {
        return Stream.of(new Dependency("org.apache.cxf", "cxf-rt-rs-client", versions.getCxf(), "compile"));
    }

    @Override
    public String description() {
        return "Generates a HTTP client from a WADL.";
    }

    @Override
    public String name() {
        return "WADL Client Generation";
    }

    @Override
    public FacetGenerator.Category category() {
        return FacetGenerator.Category.LIBRARIES;
    }

    public static interface Constants {
        public static final String NAME = "WADL Client Generation";
    }
}

