/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.info;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.starter.server.configuration.StarterConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

@ApplicationScoped
public class ServerInfo {
    private static final Logger log = LoggerFactory.getLogger(ServerInfo.class);
    private Date lastUpdate;
    private volatile Snapshot snapshot;
    @Inject
    private StarterConfiguration configuration;
    @Inject
    @ConfigProperty(name="git.build.version")
    private String release;
    @Inject
    @ConfigProperty(name="git.branch")
    private String branch;
    @Inject
    @ConfigProperty(name="git.commit.id")
    private String commit;
    @Inject
    @ConfigProperty(name="git.build.time")
    private String buildTime;
    private ScheduledExecutorService thread;
    private ScheduledFuture<?> future;
    private SAXParserFactory saxFactory;

    @PostConstruct
    private void init() {
        this.saxFactory = SAXParserFactory.newInstance();
        try {
            this.saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            this.saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException exception) {
            // empty catch block
        }
        this.doUpdate(() -> Thread.currentThread().getContextClassLoader().getResourceAsStream("starter-versions.properties"));
        if (!this.configuration.getAutoRefresh().booleanValue()) {
            return;
        }
        this.thread = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, this.getClass().getName());
            }
        });
        this.future = this.thread.scheduleAtFixedRate(this::refresh, 0L, this.configuration.getRefreshDelayMs(), TimeUnit.MILLISECONDS);
    }

    private void doUpdate(Supplier<InputStream> streamProvider) {
        Snapshot newSnapshot = new Snapshot();
        try (InputStream stream = streamProvider.get();){
            Properties properties = new Properties();
            properties.load(stream);
            properties.stringPropertyNames().forEach(name -> {
                try {
                    String property;
                    Field field = Snapshot.class.getDeclaredField((String)name);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (!(property = properties.getProperty((String)name)).trim().isEmpty()) {
                        field.set(newSnapshot, property);
                    }
                }
                catch (Exception ise) {
                    log.error(ise.getMessage(), (Throwable)ise);
                }
            });
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.snapshot = newSnapshot;
        this.lastUpdate = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        block14: {
            Client client = ClientBuilder.newClient();
            WebTarget base = client.target("https://repo.maven.apache.org/maven2/org/talend/sdk/component/component-starter-server/");
            QuickMvnMetadataParser handler = new QuickMvnMetadataParser();
            try (InputStream metadata = (InputStream)base.path("maven-metadata.xml").request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InputStream.class);){
                String release;
                SAXParser parser = this.saxFactory.newSAXParser();
                parser.parse(metadata, (DefaultHandler)handler);
                if (handler.release == null || (release = handler.release.toString()).equals(this.snapshot.getKit()) || "10.57.0".equals(release)) break block14;
                ServerInfo serverInfo = this;
                synchronized (serverInfo) {
                    log.info("Updating current version from {} to {}", (Object)this.snapshot.getKit(), (Object)release);
                    this.doUpdate(() -> (InputStream)base.path("{version}/component-starter-server-{version}-versions.properties").resolveTemplate("version", (Object)release).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(InputStream.class));
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            finally {
                client.close();
            }
        }
    }

    @PreDestroy
    private void destroy() {
        Optional.ofNullable(this.future).ifPresent(f -> f.cancel(true));
        Optional.ofNullable(this.thread).ifPresent(ExecutorService::shutdownNow);
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public String getRelease() {
        return this.release;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public ScheduledExecutorService getThread() {
        return this.thread;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public SAXParserFactory getSaxFactory() {
        return this.saxFactory;
    }

    public static class Snapshot {
        private String apiKit;
        private String kit;
        private String beam;
        private String avroJackson;
        private String surefire = "2.22.1";
        private String cxf;
        private String log4j2;

        public String getApiKit() {
            return this.apiKit;
        }

        public String getKit() {
            return this.kit;
        }

        public String getBeam() {
            return this.beam;
        }

        public String getAvroJackson() {
            return this.avroJackson;
        }

        public String getSurefire() {
            return this.surefire;
        }

        public String getCxf() {
            return this.cxf;
        }

        public String getLog4j2() {
            return this.log4j2;
        }

        public void setApiKit(String apiKit) {
            this.apiKit = apiKit;
        }

        public void setKit(String kit) {
            this.kit = kit;
        }

        public void setBeam(String beam) {
            this.beam = beam;
        }

        public void setAvroJackson(String avroJackson) {
            this.avroJackson = avroJackson;
        }

        public void setSurefire(String surefire) {
            this.surefire = surefire;
        }

        public void setCxf(String cxf) {
            this.cxf = cxf;
        }

        public void setLog4j2(String log4j2) {
            this.log4j2 = log4j2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot other = (Snapshot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$apiKit = this.getApiKit();
            String other$apiKit = other.getApiKit();
            if (this$apiKit == null ? other$apiKit != null : !this$apiKit.equals(other$apiKit)) {
                return false;
            }
            String this$kit = this.getKit();
            String other$kit = other.getKit();
            if (this$kit == null ? other$kit != null : !this$kit.equals(other$kit)) {
                return false;
            }
            String this$beam = this.getBeam();
            String other$beam = other.getBeam();
            if (this$beam == null ? other$beam != null : !this$beam.equals(other$beam)) {
                return false;
            }
            String this$avroJackson = this.getAvroJackson();
            String other$avroJackson = other.getAvroJackson();
            if (this$avroJackson == null ? other$avroJackson != null : !this$avroJackson.equals(other$avroJackson)) {
                return false;
            }
            String this$surefire = this.getSurefire();
            String other$surefire = other.getSurefire();
            if (this$surefire == null ? other$surefire != null : !this$surefire.equals(other$surefire)) {
                return false;
            }
            String this$cxf = this.getCxf();
            String other$cxf = other.getCxf();
            if (this$cxf == null ? other$cxf != null : !this$cxf.equals(other$cxf)) {
                return false;
            }
            String this$log4j2 = this.getLog4j2();
            String other$log4j2 = other.getLog4j2();
            return !(this$log4j2 == null ? other$log4j2 != null : !this$log4j2.equals(other$log4j2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Snapshot;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $apiKit = this.getApiKit();
            result = result * 59 + ($apiKit == null ? 43 : $apiKit.hashCode());
            String $kit = this.getKit();
            result = result * 59 + ($kit == null ? 43 : $kit.hashCode());
            String $beam = this.getBeam();
            result = result * 59 + ($beam == null ? 43 : $beam.hashCode());
            String $avroJackson = this.getAvroJackson();
            result = result * 59 + ($avroJackson == null ? 43 : $avroJackson.hashCode());
            String $surefire = this.getSurefire();
            result = result * 59 + ($surefire == null ? 43 : $surefire.hashCode());
            String $cxf = this.getCxf();
            result = result * 59 + ($cxf == null ? 43 : $cxf.hashCode());
            String $log4j2 = this.getLog4j2();
            result = result * 59 + ($log4j2 == null ? 43 : $log4j2.hashCode());
            return result;
        }

        public String toString() {
            return "ServerInfo.Snapshot(apiKit=" + this.getApiKit() + ", kit=" + this.getKit() + ", beam=" + this.getBeam() + ", avroJackson=" + this.getAvroJackson() + ", surefire=" + this.getSurefire() + ", cxf=" + this.getCxf() + ", log4j2=" + this.getLog4j2() + ")";
        }

        private Snapshot() {
        }
    }

    private static class QuickMvnMetadataParser
    extends DefaultHandler {
        private StringBuilder release;
        private StringBuilder text;

        private QuickMvnMetadataParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("release".equalsIgnoreCase(qName)) {
                this.text = this.release = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.text != null) {
                this.text.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.text = null;
        }
    }
}

