/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.openapi;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.starter.server.service.Strings;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.facet.util.NameConventions;
import org.talend.sdk.component.starter.server.service.openapi.model.ApiModel;
import org.talend.sdk.component.starter.server.service.openapi.model.openapi.OpenAPI;
import org.talend.sdk.component.starter.server.service.openapi.model.swagger.SwaggerAPI;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class OpenAPIGenerator {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIGenerator.class);
    @Inject
    private TemplateRenderer renderer;
    @Inject
    private NameConventions nameConventions;
    @Inject
    private Jsonb jsonb;

    public Collection<FacetGenerator.InMemoryFile> generate(String family, Build build, String basePackage, JsonObject openapi) {
        ApiType apiType = this.getApiType(openapi);
        ApiModel api = this.getApiModel(apiType, openapi);
        log.warn("[generate] {}", (Object)api.getInfo());
        String defaultUrl = api.getDefaultUrl();
        String pck = '/' + basePackage.replace('.', '/') + '/';
        String javaBase = build.getMainJavaDirectory() + pck;
        String resourcesBase = build.getMainResourcesDirectory() + pck;
        return Optional.ofNullable(openapi.getJsonObject("paths")).map(it -> this.toFiles(basePackage, family, javaBase, resourcesBase, (JsonObject)it)).orElseGet(Collections::emptyList);
    }

    private ApiType getApiType(JsonObject openapi) {
        String version = Optional.ofNullable(Optional.ofNullable(openapi.getJsonString("openapi")).orElse(openapi.getJsonString("swagger"))).map(JsonString::getString).orElse("");
        return ApiType.fromVersion(version);
    }

    private ApiModel getApiModel(ApiType api, JsonObject json) {
        switch (api) {
            case OAS20: {
                return (ApiModel)this.jsonb.fromJson(json.toString(), SwaggerAPI.class);
            }
            case OAS30: {
                return (ApiModel)this.jsonb.fromJson(json.toString(), OpenAPI.class);
            }
        }
        throw new IllegalArgumentException(String.format("UNKNOWN API! Only %s are supported", api.getSupportedAPIs()));
    }

    private Collection<FacetGenerator.InMemoryFile> toFiles(String basePackage, String family, String baseFolder, String resourcesBaseFolder, JsonObject paths) {
        List<Operation> operations = this.extractOperations(paths);
        ArrayList<FacetGenerator.InMemoryFile> payloads = new ArrayList<FacetGenerator.InMemoryFile>();
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "connection/APIConnection.java", this.renderer.render("generator/openapi/connection.mustache", new ConnectionModel(basePackage))));
        payloads.add(new FacetGenerator.InMemoryFile(resourcesBaseFolder + "connection/Messages.properties", "APIConnection.baseUrl._displayName = Base URL\nAPIConnection.baseUrl._placeholder = Base URL...\n"));
        Collection<Option> options = operations.stream().flatMap(operation -> operation.getParameters().stream().map(param -> new Option(param.getName(), "get" + Strings.capitalize(param.getName()), param.getJavaType(), param.getDefaultValue(), new ArrayList<String>(Collections.singletonList(operation.getName())), param.getWidget()))).collect(Collectors.toMap(Option::getName, Function.identity(), (a, b) -> {
            a.getSupportedAPI().addAll(b.getSupportedAPI());
            return a;
        })).values();
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "dataset/APIDataSet.java", this.renderer.render("generator/openapi/dataset.mustache", new DataSetModel(options.stream().anyMatch(it -> it.getDefaultValue() != null), basePackage, operations, options, options.stream().anyMatch(it -> it.getType().startsWith("List<")), options.stream().anyMatch(it -> it.getWidget() != null && it.getWidget().startsWith("@Code"))))));
        payloads.add(new FacetGenerator.InMemoryFile(resourcesBaseFolder + "dataset/Messages.properties", "APIDataSet.api._displayName = API\nAPIDataSet.connection._displayName = API connection\n" + options.stream().flatMap(opt -> {
            Stream<String> displayName = Stream.of("APIDataSet." + opt.getName() + "._displayName = <" + opt.getName() + ">");
            if ("string".equalsIgnoreCase(((Option)opt).type)) {
                return Stream.concat(displayName, Stream.of("APIDataSet." + opt.getName() + "._placeholder = " + opt.getName() + "..."));
            }
            return displayName;
        }).sorted().collect(Collectors.joining("\n", "", "\n\n")) + operations.stream().flatMap(op -> Stream.of("APIType." + op.getName() + "._displayName = " + op.getName(), "APIType." + op.getName() + "._placeholder = " + op.getName() + "...")).sorted().collect(Collectors.joining("\n", "", "\n"))));
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "client/APIClient.java", this.renderer.render("generator/openapi/client.mustache", new ClientModel(basePackage, operations.stream().flatMap(it -> it.getParameters().stream()).anyMatch(it -> ((Parameter)it).javaType.startsWith("List<")), operations.stream().flatMap(it -> it.getParameters().stream()).map(Parameter::getJavaImport).distinct().collect(Collectors.toList()), "JsonObject", operations))));
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "source/APIConfiguration.java", this.renderer.render("generator/openapi/configuration.mustache", new ConfigurationModel(basePackage))));
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "source/APISource.java", this.renderer.render("generator/openapi/source.mustache", new ConnectionModel(basePackage))));
        payloads.add(new FacetGenerator.InMemoryFile(resourcesBaseFolder + "source/Messages.properties", "APIConfiguration.dataset._displayName = API Dataset\n\n" + family + ".Source._displayName = " + family + " Input\n"));
        payloads.add(new FacetGenerator.InMemoryFile(baseFolder + "package-info.java", this.renderer.render("generator/openapi/package-info.mustache", new PackageModel(basePackage, family))));
        payloads.add(new FacetGenerator.InMemoryFile(resourcesBaseFolder + "Messages.properties", family + "._displayName = " + family + "\n\n" + family + ".datastore.APIConnection._displayName = " + family + " Connection\n" + family + ".dataset.APIDataSet._displayName = " + family + " DataSet\n"));
        return payloads;
    }

    private List<Operation> extractOperations(JsonObject paths) {
        return paths.entrySet().stream().filter(path -> ((JsonValue)path.getValue()).getValueType() == JsonValue.ValueType.OBJECT).flatMap(path -> ((JsonValue)path.getValue()).asJsonObject().entrySet().stream().filter(jsonValue -> ((JsonValue)jsonValue.getValue()).getValueType() == JsonValue.ValueType.OBJECT).map(operation -> new Operation(this.getString((JsonValue)operation.getValue(), "operationId").map(this.nameConventions::toJavaName).map(Introspector::decapitalize).orElseGet(() -> this.nameConventions.toJavaName((String)operation.getKey() + "_" + (String)path.getKey())), Optional.ofNullable((String)operation.getKey()).orElse("GET").toUpperCase(Locale.ROOT), (String)path.getKey(), Stream.concat(this.getObject((JsonValue)operation.getValue(), "requestBody").map(body -> Stream.of(new Parameter("body", "getBody", "string", "", null, "String", "\\\"{}\\\"", "@Code(\"javascript\")"))).orElseGet(Stream::empty), this.getObjectList((JsonValue)operation.getValue(), "parameters").orElseGet(Stream::empty).map(it -> {
            String type = this.getString((JsonValue)it, "in").orElse("query");
            String name = it.getString("name");
            return this.mapParameter((JsonObject)it, type, name);
        })).collect(Collectors.toList())))).collect(Collectors.toList());
    }

    private Parameter mapParameter(JsonObject it, String type, String name) {
        String javaName = Introspector.decapitalize(this.nameConventions.toJavaName(name));
        return new Parameter(javaName, "get" + Strings.capitalize(javaName), type, this.getJavaMarkerForParameter(name, type), this.getMarkerImportForParameter(name, type), this.getObject((JsonValue)it, "schema").map(this::mapJavaType).orElse("String"), this.getObject((JsonValue)it, "schema").map(schema -> (JsonValue)schema.get((Object)"default")).map(defaultValue -> {
            switch (defaultValue.getValueType()) {
                case TRUE: 
                case FALSE: 
                case NUMBER: {
                    return String.valueOf(defaultValue);
                }
                case STRING: {
                    return ((JsonString)JsonString.class.cast(defaultValue)).getString();
                }
            }
            return null;
        }).orElse(null), null);
    }

    private String getMarkerImportForParameter(String name, String type) {
        switch (type) {
            case "query": {
                return "org.talend.sdk.component.api.service.http.Query";
            }
            case "path": {
                return "org.talend.sdk.component.api.service.http.Path";
            }
            case "header": {
                return "org.talend.sdk.component.api.service.http.Header";
            }
            case "body": 
            case "formData": {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported parameter: " + type + "(" + name + ")");
    }

    private String getJavaMarkerForParameter(String name, String type) {
        switch (type) {
            case "query": {
                return "@Query(\"" + name + "\") ";
            }
            case "path": {
                return "@Path(\"" + name + "\") ";
            }
            case "header": {
                return "@Header(\"" + name + "\") ";
            }
            case "body": 
            case "formData": {
                return "";
            }
        }
        throw new IllegalArgumentException("Unsupported parameter: " + type + "(" + name + ")");
    }

    private String mapJavaType(JsonObject jsonObject) {
        String jsonType;
        switch (jsonType = jsonObject.getString("type", "unknown")) {
            case "number": {
                return "double";
            }
            case "integer": {
                return "int";
            }
            case "boolean": {
                return "boolean";
            }
            case "string": {
                return "String";
            }
            case "array": {
                JsonObject subSchema = jsonObject.getJsonObject("items");
                return "List<" + this.mapJavaType(subSchema) + ">";
            }
            case "object": {
                return "List<JsonObject>";
            }
            case "unknown": {
                System.out.println("Maybe a ref: " + jsonObject.getString("$ref", "noref"));
                return "JsonObject";
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + jsonObject);
    }

    private Optional<Stream<JsonObject>> getObjectList(JsonValue value, String key) {
        this.ensureObject(value);
        return Optional.ofNullable(value.asJsonObject().getJsonArray(key)).map(array -> array.stream().filter(this::ensureObject).map(JsonValue::asJsonObject));
    }

    private Optional<String> getString(JsonValue value, String key) {
        this.ensureObject(value);
        return Optional.ofNullable(value.asJsonObject().getJsonString(key)).map(JsonString::getString);
    }

    private Optional<JsonObject> getObject(JsonValue value, String key) {
        this.ensureObject(value);
        return Optional.ofNullable(value.asJsonObject().getJsonObject(key));
    }

    private boolean ensureObject(JsonValue value) {
        if (value.getValueType() != JsonValue.ValueType.OBJECT) {
            throw new IllegalArgumentException("Not an object: " + value);
        }
        return true;
    }

    private void validateVersion(JsonObject openapi) {
        Optional.ofNullable(Optional.ofNullable(openapi.getJsonString("openapi")).orElse(openapi.getJsonString("version"))).map(JsonString::getString).filter(it -> it.startsWith("3.0.")).orElseThrow(() -> new IllegalArgumentException("Only OpenAPI version 3.0 are supported"));
    }

    static enum ApiType {
        OAS20("2.0"),
        OAS30("3.0"),
        TALEND_API_CREATOR("apic-1.0"),
        TALEND_API_TESTER("apit-1.0"),
        UNKNOWN("");

        private final String key;

        public static ApiType fromVersion(String version) {
            for (ApiType api : ApiType.values()) {
                if (!version.startsWith(api.key)) continue;
                return api;
            }
            return UNKNOWN;
        }

        public List<ApiType> getSupportedAPIs() {
            return Arrays.asList(OAS30, OAS20);
        }

        private ApiType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    private static class ConnectionModel {
        private final String packageName;

        public ConnectionModel(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectionModel)) {
                return false;
            }
            ConnectionModel other = (ConnectionModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            return !(this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConnectionModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.ConnectionModel(packageName=" + this.getPackageName() + ")";
        }
    }

    private static class DataSetModel {
        private final boolean importDefaultValue;
        private final String packageName;
        private final Collection<Operation> operations;
        private final Collection<Option> options;
        private final boolean importList;
        private final boolean importCode;

        public DataSetModel(boolean importDefaultValue, String packageName, Collection<Operation> operations, Collection<Option> options, boolean importList, boolean importCode) {
            this.importDefaultValue = importDefaultValue;
            this.packageName = packageName;
            this.operations = operations;
            this.options = options;
            this.importList = importList;
            this.importCode = importCode;
        }

        public boolean isImportDefaultValue() {
            return this.importDefaultValue;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public Collection<Operation> getOperations() {
            return this.operations;
        }

        public Collection<Option> getOptions() {
            return this.options;
        }

        public boolean isImportList() {
            return this.importList;
        }

        public boolean isImportCode() {
            return this.importCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSetModel)) {
                return false;
            }
            DataSetModel other = (DataSetModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isImportDefaultValue() != other.isImportDefaultValue()) {
                return false;
            }
            if (this.isImportList() != other.isImportList()) {
                return false;
            }
            if (this.isImportCode() != other.isImportCode()) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            Collection<Operation> this$operations = this.getOperations();
            Collection<Operation> other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Collection<Option> this$options = this.getOptions();
            Collection<Option> other$options = other.getOptions();
            return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSetModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isImportDefaultValue() ? 79 : 97);
            result = result * 59 + (this.isImportList() ? 79 : 97);
            result = result * 59 + (this.isImportCode() ? 79 : 97);
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            Collection<Operation> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Collection<Option> $options = this.getOptions();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.DataSetModel(importDefaultValue=" + this.isImportDefaultValue() + ", packageName=" + this.getPackageName() + ", operations=" + this.getOperations() + ", options=" + this.getOptions() + ", importList=" + this.isImportList() + ", importCode=" + this.isImportCode() + ")";
        }
    }

    private static class ClientModel {
        private final String packageName;
        private final boolean importList;
        private final Collection<String> importAPI;
        private final String responsePayloadType;
        private final Collection<Operation> operations;

        public ClientModel(String packageName, boolean importList, Collection<String> importAPI, String responsePayloadType, Collection<Operation> operations) {
            this.packageName = packageName;
            this.importList = importList;
            this.importAPI = importAPI;
            this.responsePayloadType = responsePayloadType;
            this.operations = operations;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean isImportList() {
            return this.importList;
        }

        public Collection<String> getImportAPI() {
            return this.importAPI;
        }

        public String getResponsePayloadType() {
            return this.responsePayloadType;
        }

        public Collection<Operation> getOperations() {
            return this.operations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientModel)) {
                return false;
            }
            ClientModel other = (ClientModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isImportList() != other.isImportList()) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            Collection<String> this$importAPI = this.getImportAPI();
            Collection<String> other$importAPI = other.getImportAPI();
            if (this$importAPI == null ? other$importAPI != null : !((Object)this$importAPI).equals(other$importAPI)) {
                return false;
            }
            String this$responsePayloadType = this.getResponsePayloadType();
            String other$responsePayloadType = other.getResponsePayloadType();
            if (this$responsePayloadType == null ? other$responsePayloadType != null : !this$responsePayloadType.equals(other$responsePayloadType)) {
                return false;
            }
            Collection<Operation> this$operations = this.getOperations();
            Collection<Operation> other$operations = other.getOperations();
            return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClientModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isImportList() ? 79 : 97);
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            Collection<String> $importAPI = this.getImportAPI();
            result = result * 59 + ($importAPI == null ? 43 : ((Object)$importAPI).hashCode());
            String $responsePayloadType = this.getResponsePayloadType();
            result = result * 59 + ($responsePayloadType == null ? 43 : $responsePayloadType.hashCode());
            Collection<Operation> $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.ClientModel(packageName=" + this.getPackageName() + ", importList=" + this.isImportList() + ", importAPI=" + this.getImportAPI() + ", responsePayloadType=" + this.getResponsePayloadType() + ", operations=" + this.getOperations() + ")";
        }
    }

    private static class ConfigurationModel {
        private final String packageName;

        public ConfigurationModel(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurationModel)) {
                return false;
            }
            ConfigurationModel other = (ConfigurationModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            return !(this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigurationModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.ConfigurationModel(packageName=" + this.getPackageName() + ")";
        }
    }

    private static class PackageModel {
        private final String packageName;
        private final String family;

        public PackageModel(String packageName, String family) {
            this.packageName = packageName;
            this.family = family;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getFamily() {
            return this.family;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackageModel)) {
                return false;
            }
            PackageModel other = (PackageModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$family = this.getFamily();
            String other$family = other.getFamily();
            return !(this$family == null ? other$family != null : !this$family.equals(other$family));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PackageModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $family = this.getFamily();
            result = result * 59 + ($family == null ? 43 : $family.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.PackageModel(packageName=" + this.getPackageName() + ", family=" + this.getFamily() + ")";
        }
    }

    private static class Parameter {
        private final String name;
        private final String getter;
        private final String type;
        private final String javaMarker;
        private final String javaImport;
        private final String javaType;
        private final String defaultValue;
        private final String widget;

        public Parameter(String name, String getter, String type, String javaMarker, String javaImport, String javaType, String defaultValue, String widget) {
            this.name = name;
            this.getter = getter;
            this.type = type;
            this.javaMarker = javaMarker;
            this.javaImport = javaImport;
            this.javaType = javaType;
            this.defaultValue = defaultValue;
            this.widget = widget;
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.getter;
        }

        public String getType() {
            return this.type;
        }

        public String getJavaMarker() {
            return this.javaMarker;
        }

        public String getJavaImport() {
            return this.javaImport;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getWidget() {
            return this.widget;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter other = (Parameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$getter = this.getGetter();
            String other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$javaMarker = this.getJavaMarker();
            String other$javaMarker = other.getJavaMarker();
            if (this$javaMarker == null ? other$javaMarker != null : !this$javaMarker.equals(other$javaMarker)) {
                return false;
            }
            String this$javaImport = this.getJavaImport();
            String other$javaImport = other.getJavaImport();
            if (this$javaImport == null ? other$javaImport != null : !this$javaImport.equals(other$javaImport)) {
                return false;
            }
            String this$javaType = this.getJavaType();
            String other$javaType = other.getJavaType();
            if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            String this$widget = this.getWidget();
            String other$widget = other.getWidget();
            return !(this$widget == null ? other$widget != null : !this$widget.equals(other$widget));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $javaMarker = this.getJavaMarker();
            result = result * 59 + ($javaMarker == null ? 43 : $javaMarker.hashCode());
            String $javaImport = this.getJavaImport();
            result = result * 59 + ($javaImport == null ? 43 : $javaImport.hashCode());
            String $javaType = this.getJavaType();
            result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            String $widget = this.getWidget();
            result = result * 59 + ($widget == null ? 43 : $widget.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.Parameter(name=" + this.getName() + ", getter=" + this.getGetter() + ", type=" + this.getType() + ", javaMarker=" + this.getJavaMarker() + ", javaImport=" + this.getJavaImport() + ", javaType=" + this.getJavaType() + ", defaultValue=" + this.getDefaultValue() + ", widget=" + this.getWidget() + ")";
        }
    }

    private static class Operation {
        private final String name;
        private final String verb;
        private final String path;
        private final Collection<Parameter> parameters;

        public Operation(String name, String verb, String path, Collection<Parameter> parameters) {
            this.name = name;
            this.verb = verb;
            this.path = path;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public String getVerb() {
            return this.verb;
        }

        public String getPath() {
            return this.path;
        }

        public Collection<Parameter> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Operation)) {
                return false;
            }
            Operation other = (Operation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$verb = this.getVerb();
            String other$verb = other.getVerb();
            if (this$verb == null ? other$verb != null : !this$verb.equals(other$verb)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Collection<Parameter> this$parameters = this.getParameters();
            Collection<Parameter> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Operation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $verb = this.getVerb();
            result = result * 59 + ($verb == null ? 43 : $verb.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Collection<Parameter> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.Operation(name=" + this.getName() + ", verb=" + this.getVerb() + ", path=" + this.getPath() + ", parameters=" + this.getParameters() + ")";
        }
    }

    private static class Option {
        private final String name;
        private final String getter;
        private final String type;
        private final String defaultValue;
        private final Collection<String> supportedAPI;
        private final String widget;

        public Option(String name, String getter, String type, String defaultValue, Collection<String> supportedAPI, String widget) {
            this.name = name;
            this.getter = getter;
            this.type = type;
            this.defaultValue = defaultValue;
            this.supportedAPI = supportedAPI;
            this.widget = widget;
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.getter;
        }

        public String getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Collection<String> getSupportedAPI() {
            return this.supportedAPI;
        }

        public String getWidget() {
            return this.widget;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Option)) {
                return false;
            }
            Option other = (Option)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$getter = this.getGetter();
            String other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Collection<String> this$supportedAPI = this.getSupportedAPI();
            Collection<String> other$supportedAPI = other.getSupportedAPI();
            if (this$supportedAPI == null ? other$supportedAPI != null : !((Object)this$supportedAPI).equals(other$supportedAPI)) {
                return false;
            }
            String this$widget = this.getWidget();
            String other$widget = other.getWidget();
            return !(this$widget == null ? other$widget != null : !this$widget.equals(other$widget));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Option;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Collection<String> $supportedAPI = this.getSupportedAPI();
            result = result * 59 + ($supportedAPI == null ? 43 : ((Object)$supportedAPI).hashCode());
            String $widget = this.getWidget();
            result = result * 59 + ($widget == null ? 43 : $widget.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAPIGenerator.Option(name=" + this.getName() + ", getter=" + this.getGetter() + ", type=" + this.getType() + ", defaultValue=" + this.getDefaultValue() + ", supportedAPI=" + this.getSupportedAPI() + ", widget=" + this.getWidget() + ")";
        }
    }
}

