/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.openapi.model.swagger;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.json.JsonObject;
import org.talend.sdk.component.starter.server.service.openapi.model.ApiModel;
import org.talend.sdk.component.starter.server.service.openapi.model.common.ExternalDocs;
import org.talend.sdk.component.starter.server.service.openapi.model.common.Info;
import org.talend.sdk.component.starter.server.service.openapi.model.common.Tag;
import org.talend.sdk.component.starter.server.service.openapi.model.swagger.Operation;

public class SwaggerAPI
implements ApiModel {
    private String swagger;
    private Info info;
    private String host;
    private String basePath;
    private List<String> schemes;
    private List<String> consumes;
    private Map<String, Map<String, Operation>> paths;
    private Map<String, JsonObject> definitions;
    private List<Tag> tags;
    private ExternalDocs externalDocs;

    @Override
    public String getDefaultUrl() {
        String host = Optional.ofNullable(this.getHost()).orElse("localhost");
        String basePath = Optional.ofNullable(this.getBasePath()).orElse("");
        String protocol = this.getSchemes().stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).filter(s -> !s.startsWith("ws")).sorted(Comparator.reverseOrder()).findFirst().orElse("https");
        return String.format("%s://%s%s", protocol, host, basePath);
    }

    public String getSwagger() {
        return this.swagger;
    }

    @Override
    public Info getInfo() {
        return this.info;
    }

    public String getHost() {
        return this.host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public Map<String, Map<String, Operation>> getPaths() {
        return this.paths;
    }

    public Map<String, JsonObject> getDefinitions() {
        return this.definitions;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setSchemes(List<String> schemes) {
        this.schemes = schemes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setPaths(Map<String, Map<String, Operation>> paths) {
        this.paths = paths;
    }

    public void setDefinitions(Map<String, JsonObject> definitions) {
        this.definitions = definitions;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwaggerAPI)) {
            return false;
        }
        SwaggerAPI other = (SwaggerAPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$swagger = this.getSwagger();
        String other$swagger = other.getSwagger();
        if (this$swagger == null ? other$swagger != null : !this$swagger.equals(other$swagger)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$basePath = this.getBasePath();
        String other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        List<String> this$schemes = this.getSchemes();
        List<String> other$schemes = other.getSchemes();
        if (this$schemes == null ? other$schemes != null : !((Object)this$schemes).equals(other$schemes)) {
            return false;
        }
        List<String> this$consumes = this.getConsumes();
        List<String> other$consumes = other.getConsumes();
        if (this$consumes == null ? other$consumes != null : !((Object)this$consumes).equals(other$consumes)) {
            return false;
        }
        Map<String, Map<String, Operation>> this$paths = this.getPaths();
        Map<String, Map<String, Operation>> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Map<String, JsonObject> this$definitions = this.getDefinitions();
        Map<String, JsonObject> other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        ExternalDocs this$externalDocs = this.getExternalDocs();
        ExternalDocs other$externalDocs = other.getExternalDocs();
        return !(this$externalDocs == null ? other$externalDocs != null : !((Object)this$externalDocs).equals(other$externalDocs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwaggerAPI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $swagger = this.getSwagger();
        result = result * 59 + ($swagger == null ? 43 : $swagger.hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        List<String> $schemes = this.getSchemes();
        result = result * 59 + ($schemes == null ? 43 : ((Object)$schemes).hashCode());
        List<String> $consumes = this.getConsumes();
        result = result * 59 + ($consumes == null ? 43 : ((Object)$consumes).hashCode());
        Map<String, Map<String, Operation>> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Map<String, JsonObject> $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        ExternalDocs $externalDocs = this.getExternalDocs();
        result = result * 59 + ($externalDocs == null ? 43 : ((Object)$externalDocs).hashCode());
        return result;
    }

    public String toString() {
        return "SwaggerAPI(swagger=" + this.getSwagger() + ", info=" + this.getInfo() + ", host=" + this.getHost() + ", basePath=" + this.getBasePath() + ", schemes=" + this.getSchemes() + ", consumes=" + this.getConsumes() + ", paths=" + this.getPaths() + ", definitions=" + this.getDefinitions() + ", tags=" + this.getTags() + ", externalDocs=" + this.getExternalDocs() + ")";
    }
}

