/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.statistic;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.starter.server.service.event.CreateProject;

@ApplicationScoped
public class StatisticService {
    @Inject
    private Jsonb jsonb;
    @Inject
    private Event<Representation> representationEvent;
    private final Logger logger = LoggerFactory.getLogger((String)"talend.component.starter.statistics");

    public void save(CreateProject event) {
        String project = event.getRequest().getBuildConfiguration().getGroup() + ':' + event.getRequest().getBuildConfiguration().getArtifact();
        try {
            Representation representation = new Representation(project, event.getRequest().getSources() == null ? 0 : event.getRequest().getSources().size(), event.getRequest().getProcessors() == null ? 0 : event.getRequest().getProcessors().size(), event.getRequest().getOpenapi() != null ? Long.valueOf(this.countEndpoints(event.getRequest().getOpenapi())) : null, Optional.ofNullable(event.getRequest().getFacets()).orElseGet(Collections::emptyList));
            this.representationEvent.fire((Object)representation);
            this.logger.info(this.jsonb.toJson((Object)representation));
        }
        catch (RuntimeException re) {
            this.logger.error(re.getMessage(), (Throwable)re);
        }
    }

    private long countEndpoints(JsonObject openapi) {
        return Optional.ofNullable(openapi.getJsonObject("paths")).filter(p -> p.getValueType() == JsonValue.ValueType.OBJECT).map(JsonValue::asJsonObject).map(paths -> paths.values().stream().filter(path -> path.getValueType() == JsonValue.ValueType.OBJECT).flatMap(path -> path.asJsonObject().values().stream()).filter(endpoint -> endpoint.getValueType() == JsonValue.ValueType.OBJECT).count()).orElse(0L);
    }

    public static class Representation {
        private final String id;
        private final int sourcesCount;
        private final int processorsCount;
        private final Long openapiEndpoints;
        private final Collection<String> facets;

        public Representation(String id, int sourcesCount, int processorsCount, Long openapiEndpoints, Collection<String> facets) {
            this.id = id;
            this.sourcesCount = sourcesCount;
            this.processorsCount = processorsCount;
            this.openapiEndpoints = openapiEndpoints;
            this.facets = facets;
        }

        public String getId() {
            return this.id;
        }

        public int getSourcesCount() {
            return this.sourcesCount;
        }

        public int getProcessorsCount() {
            return this.processorsCount;
        }

        public Long getOpenapiEndpoints() {
            return this.openapiEndpoints;
        }

        public Collection<String> getFacets() {
            return this.facets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Representation)) {
                return false;
            }
            Representation other = (Representation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSourcesCount() != other.getSourcesCount()) {
                return false;
            }
            if (this.getProcessorsCount() != other.getProcessorsCount()) {
                return false;
            }
            Long this$openapiEndpoints = this.getOpenapiEndpoints();
            Long other$openapiEndpoints = other.getOpenapiEndpoints();
            if (this$openapiEndpoints == null ? other$openapiEndpoints != null : !((Object)this$openapiEndpoints).equals(other$openapiEndpoints)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Collection<String> this$facets = this.getFacets();
            Collection<String> other$facets = other.getFacets();
            return !(this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Representation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSourcesCount();
            result = result * 59 + this.getProcessorsCount();
            Long $openapiEndpoints = this.getOpenapiEndpoints();
            result = result * 59 + ($openapiEndpoints == null ? 43 : ((Object)$openapiEndpoints).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Collection<String> $facets = this.getFacets();
            result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
            return result;
        }

        public String toString() {
            return "StatisticService.Representation(id=" + this.getId() + ", sourcesCount=" + this.getSourcesCount() + ", processorsCount=" + this.getProcessorsCount() + ", openapiEndpoints=" + this.getOpenapiEndpoints() + ", facets=" + this.getFacets() + ")";
        }
    }

    @ApplicationScoped
    public static class ProjectListener {
        private static final Logger log = LoggerFactory.getLogger(ProjectListener.class);
        @Inject
        private StatisticService statistics;
        @Inject
        @ConfigProperty(name="talend.component.starter.statistics.threads", defaultValue="8")
        private Integer threads;
        @Inject
        @ConfigProperty(name="talend.component.starter.statistics.retries", defaultValue="3")
        private Integer retries;
        @Inject
        @ConfigProperty(name="talend.component.starter.statistics.retry-sleep", defaultValue="250")
        private Integer retrySleep;
        @Inject
        @ConfigProperty(name="talend.component.starter.statistics.shutdown-timeout", defaultValue="50000")
        private Integer shutdownTimeout;
        private ExecutorService executorService;
        private volatile boolean skip = false;

        @PostConstruct
        private void init() {
            AtomicInteger counter = new AtomicInteger(1);
            this.executorService = Executors.newFixedThreadPool(this.threads, r -> {
                Thread thread = new Thread(r);
                thread.setName("talend-starter-statistcs-" + counter.getAndIncrement());
                thread.setPriority(5);
                thread.setDaemon(false);
                return thread;
            });
        }

        public void capture(@Observes CreateProject createProject) {
            if (this.skip) {
                return;
            }
            this.executorService.submit(() -> {
                for (int i = 0; i < this.retries; ++i) {
                    try {
                        this.statistics.save(createProject);
                        return;
                    }
                    catch (Exception te) {
                        Throwable e = Optional.ofNullable(te.getCause()).orElse(te);
                        if (this.retries - 1 == i) {
                            this.failed(createProject);
                            throw RuntimeException.class.isInstance(e) ? (RuntimeException)RuntimeException.class.cast(e) : new IllegalStateException(e);
                        }
                        if (this.retrySleep <= 0) continue;
                        try {
                            Thread.sleep(this.retrySleep.intValue());
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                this.failed(createProject);
            });
        }

        private void failed(CreateProject createProject) {
            log.warn("Can't save statistics of " + createProject + " in " + this.retries + " retries.");
        }

        @PreDestroy
        private void tryToSaveCurrentTasks() {
            this.executorService.shutdown();
            this.skip = true;
            try {
                if (!this.executorService.awaitTermination(this.shutdownTimeout.intValue(), TimeUnit.MILLISECONDS)) {
                    log.warn("Some statistics have been missed, this is not important but reporting can not be 100% accurate");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                log.warn("interruption during statistics shutdown, {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }
}

