/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.template;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.DecoratedCollection;
import com.github.mustachejava.util.Wrapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class TemplateRenderer {
    private final ConcurrentMap<String, Mustache> templates = new ConcurrentHashMap<String, Mustache>();
    private final DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory(){
        {
            this.setObjectHandler((ObjectHandler)new ReflectionObjectHandler(){

                public Wrapper find(String name, List<Object> scopes) {
                    Wrapper wrapper = super.find(name, scopes);
                    return s -> {
                        Object call = wrapper.call(s);
                        if (Collection.class.isInstance(call) && !DecoratedCollection.class.isInstance(call)) {
                            return new DecoratedCollection((Collection)Collection.class.cast(call));
                        }
                        return call;
                    };
                }

                protected AccessibleObject findMember(Class sClass, String name) {
                    if (sClass == String.class && "value".equals(name)) {
                        return null;
                    }
                    return super.findMember(sClass, name);
                }
            });
        }

        public void encode(String value, Writer writer) {
            try {
                writer.write(value);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    public String render(String template, Object model) {
        StringWriter writer = new StringWriter();
        this.templates.computeIfAbsent(template, t -> this.mustacheFactory.compile(template)).execute((Writer)writer, model);
        return writer.toString().replace("\r", "");
    }
}

