/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp.standalone.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.tools.webapp.standalone.Route;

public class StaticResourceServlet
extends HttpServlet {
    private Collection<Route> routes;
    private Path repository;

    public void init() throws ServletException {
        super.init();
        try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withBinaryDataStrategy("BASE_64").setProperty("johnzon.cdi.activated", (Object)false));){
            this.routes = (Collection)jsonb.fromJson(this.findRoutes(), (Type)new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{Route.class};
                }

                @Override
                public Type getRawType() {
                    return List.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.repository = PathFactory.get((String)Objects.requireNonNull(System.getProperty("talend.component.server.static.repository"), "missing -Dtalend.component.server.static.repository value"));
    }

    private InputStream findRoutes() {
        return Optional.ofNullable(System.getProperty("talend.component.server.static.routes")).map(PathFactory::get).map(it -> {
            try {
                return Files.newInputStream(it, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseGet(() -> Thread.currentThread().getContextClassLoader().getResourceAsStream("routes.json"));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) {
        String path = req.getRequestURI().substring(req.getContextPath().length());
        Supplier<Map<String, String>> queryString = this.lazyParseQueryString(req.getQueryString());
        this.routes.stream().filter(it -> this.matches(path, queryString, (Route)it, req)).findFirst().map(route -> this.handle((Route)route, req, resp)).orElseGet(() -> this.onMissingRoute(resp));
    }

    private boolean matches(String path, Supplier<Map<String, String>> queryString, Route route, HttpServletRequest req) {
        return Objects.equals(route.getPath(), path) && Optional.ofNullable(route.getRequestHeaders()).map(h -> h.isEmpty() || h.entrySet().stream().allMatch(e -> Objects.equals(req.getHeader((String)e.getKey()), e.getValue()))).orElse(true) != false && Optional.ofNullable(route.getQueries()).map(q -> q.isEmpty() || q.entrySet().stream().allMatch(arg_0 -> StaticResourceServlet.lambda$matches$7((Supplier)queryString, arg_0))).orElse(true) != false;
    }

    private Route onMissingRoute(HttpServletResponse resp) {
        try {
            resp.sendError(400, "Not supported");
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Route handle(Route route, HttpServletRequest req, HttpServletResponse resp) {
        block8: {
            resp.setStatus(route.getStatus());
            try {
                Path file = this.repository.resolve(route.getId());
                FileTime lastModifiedTime = Files.getLastModifiedTime(file, new LinkOption[0]);
                long lastModifiedMs = lastModifiedTime.toMillis();
                if (lastModifiedMs > 0L) {
                    long ifModifiedSince;
                    try {
                        ifModifiedSince = req.getDateHeader("If-Modified-Since");
                    }
                    catch (IllegalArgumentException iae) {
                        ifModifiedSince = -1L;
                    }
                    if (ifModifiedSince < lastModifiedMs / 1000L * 1000L) {
                        if (!resp.containsHeader("Last-Modified")) {
                            resp.setDateHeader("Last-Modified", lastModifiedMs);
                        }
                        this.doSend(route, resp, file);
                    } else {
                        resp.setStatus(304);
                    }
                    break block8;
                }
                this.doSend(route, resp, file);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return route;
    }

    private void doSend(Route route, HttpServletResponse resp, Path file) throws IOException {
        Optional.ofNullable(route.getResponseHeaders()).ifPresent(h -> h.forEach((arg_0, arg_1) -> ((HttpServletResponse)resp).addHeader(arg_0, arg_1)));
        Files.copy(file, (OutputStream)resp.getOutputStream());
    }

    private Supplier<Map<String, String>> lazyParseQueryString(final String queryString) {
        return new Supplier<Map<String, String>>(){
            private Map<String, String> parsed;

            @Override
            public Map<String, String> get() {
                if (this.parsed == null) {
                    this.parsed = Optional.ofNullable(queryString).map(q -> Stream.of(q.split("&")).map(it -> {
                        int eq = it.indexOf(61);
                        if (eq >= 0) {
                            return new AbstractMap.SimpleEntry<String, String>(it.substring(0, eq), it.substring(eq + 1));
                        }
                        return new AbstractMap.SimpleEntry<String, String>((String)it, "");
                    }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(Collections::emptyMap);
                }
                return this.parsed;
            }
        };
    }

    private static /* synthetic */ boolean lambda$matches$7(Supplier queryString, Map.Entry e) {
        return Objects.equals(((Map)queryString.get()).get(e.getKey()), e.getValue());
    }
}

