/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Checkable;
import org.talend.sdk.component.api.configuration.action.Proposable;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.configuration.ui.widget.Structure;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Suggestions;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.runtime.visitor.ModelListener;
import org.talend.sdk.component.runtime.visitor.ModelVisitor;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class ComponentValidator
extends BaseTask {
    private final Configuration configuration;
    private final Log log;
    private final ParameterModelService parameterModelService = new ParameterModelService();

    public ComponentValidator(Configuration configuration, File[] classes, Object log) {
        super(classes);
        this.configuration = configuration;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        AnnotationFinder finder = this.newFinder();
        List<Class<?>> components = this.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream()).collect(Collectors.toList());
        components.forEach(c -> this.log.debug("Found component: " + c));
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        if (this.configuration.isValidateFamily()) {
            components.forEach(c -> {
                try {
                    this.findPackageOrFail((Class<?>)c, Icon.class);
                }
                catch (IllegalArgumentException iae) {
                    errors.add(iae.getMessage());
                }
            });
        }
        if (this.configuration.isValidateSerializable()) {
            ArrayList copy = new ArrayList(components);
            copy.removeIf(this::isSerializable);
            errors.addAll(copy.stream().map(c -> c + " is not Serializable").sorted().collect(ComponentValidator.toSet()));
        }
        if (this.configuration.isValidateInternationalization()) {
            this.validateInternationalization(finder, components, errors);
        }
        if (this.configuration.isValidateHttpClient()) {
            this.validateHttpClient(finder, errors);
        }
        if (this.configuration.isValidateModel()) {
            this.validateModel(finder, components, errors);
        }
        if (this.configuration.isValidateMetadata()) {
            this.validateMetadata(components, errors);
        }
        if (this.configuration.isValidateDataStore()) {
            this.validateDataStore(finder, errors);
        }
        if (this.configuration.isValidateDataSet()) {
            this.validateDataSet(finder, errors);
        }
        if (this.configuration.isValidateActions()) {
            this.validateActions(finder, errors);
        }
        if (this.configuration.isValidateDocumentation()) {
            this.validateDocumentation(finder, components, errors);
        }
        if (this.configuration.isValidateLayout()) {
            this.validateLayout(finder, components, errors);
        }
        if (this.configuration.isValidateOptionNames()) {
            this.validateOptionNames(finder, errors);
        }
        if (!errors.isEmpty()) {
            errors.forEach(this.log::error);
            throw new IllegalStateException("Some error were detected:" + errors.stream().collect(Collectors.joining("\n- ", "\n- ", "")));
        }
    }

    private boolean hasNestedDataSet(List<ParameterMeta> options) {
        return options.stream().anyMatch(option -> "dataset".equals(option.getMetadata().get("tcomp::configurationtype::type")) || this.hasNestedDataSet(option.getNestedParameters()));
    }

    private void validateLayout(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        components.stream().map(c -> this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)c), Optional.ofNullable(c.getPackage()).map(Package::getName).orElse(""))).flatMap(this::toFlatNonPrimitivConfig).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (p1, p2) -> p1)).entrySet().forEach(c -> this.visitLayout((Map.Entry<String, ParameterMeta>)c, errors));
    }

    private void visitLayout(Map.Entry<String, ParameterMeta> config, Set<String> errors) {
        Set fieldsInGridLayout = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::gridlayout")).flatMap(meta -> Stream.of(((String)meta.getValue()).split("\\|"))).flatMap(s -> Stream.of(s.split(","))).filter(s -> !s.isEmpty()).sorted().collect(ComponentValidator.toSet());
        Set fieldsInOptionOrder = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::optionsorder")).flatMap(meta -> Stream.of(((String)meta.getValue()).split(","))).sorted().collect(ComponentValidator.toSet());
        if (fieldsInGridLayout.isEmpty() && fieldsInOptionOrder.isEmpty()) {
            return;
        }
        if (!fieldsInGridLayout.isEmpty() && !fieldsInOptionOrder.isEmpty()) {
            this.log.error("Concurrent layout found for '" + config.getKey() + "', the @OptionsOrder will be ignored.");
        }
        if (!fieldsInGridLayout.isEmpty()) {
            errors.addAll(fieldsInGridLayout.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @GridLayout doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted().collect(ComponentValidator.toSet()));
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInGridLayout.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(this.log::error);
        } else {
            errors.addAll(fieldsInOptionOrder.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @OptionOrder doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted().collect(ComponentValidator.toSet()));
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInOptionOrder.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(this.log::error);
        }
    }

    private Stream<AbstractMap.SimpleEntry<String, ParameterMeta>> toFlatNonPrimitivConfig(List<ParameterMeta> config) {
        if (config == null || config.isEmpty()) {
            return Stream.empty();
        }
        return config.stream().filter(Objects::nonNull).filter(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p)).filter(p -> p.getNestedParameters() != null).flatMap(p -> Stream.concat(Stream.of(new AbstractMap.SimpleEntry<String, ParameterMeta>(this.toJavaType((ParameterMeta)p).getName(), (ParameterMeta)p)), this.toFlatNonPrimitivConfig(p.getNestedParameters())));
    }

    private Class<?> toJavaType(ParameterMeta p) {
        if (p.getType().equals((Object)ParameterMeta.Type.OBJECT) || p.getType().equals((Object)ParameterMeta.Type.ENUM)) {
            if (Class.class.isInstance(p.getJavaType())) {
                return (Class)Class.class.cast(p.getJavaType());
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a Class<?>");
        }
        if (p.getType().equals((Object)ParameterMeta.Type.ARRAY) && ParameterizedType.class.isInstance(p.getJavaType())) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(p.getJavaType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length == 1 && Class.class.isInstance(arguments[0])) {
                return (Class)Class.class.cast(arguments[0]);
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a ParameterizedType with one argument");
        }
        throw new IllegalStateException("Parameter '" + p.getName() + "' is not an object.");
    }

    private boolean isArrayOfObject(ParameterMeta param) {
        return ParameterMeta.Type.ARRAY.equals((Object)param.getType()) && param.getNestedParameters() != null && param.getNestedParameters().stream().anyMatch(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || ParameterMeta.Type.ENUM.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p));
    }

    private void validateOptionNames(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(finder.findAnnotatedFields(Option.class).stream().filter(field -> {
            String name = field.getAnnotation(Option.class).value();
            return name.contains(".") || name.startsWith("$");
        }).distinct().map(field -> {
            String name = field.getAnnotation(Option.class).value();
            return "Option name `" + name + "` is invalid, you can't start an option name with a '$' and it can't contain a '.'. Please fix it on field `" + field.getDeclaringClass().getName() + "#" + field.getName() + "`";
        }).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDocumentation(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().filter(c -> !c.isAnnotationPresent(Documentation.class)).map(c -> "No @Documentation on '" + c.getName() + "'").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Option.class).stream().filter(field -> !field.isAnnotationPresent(Documentation.class) && !field.getType().isAnnotationPresent(Documentation.class)).map(field -> "No @Documentation on '" + field + "'").sorted().collect(ComponentValidator.toSet()));
    }

    private void validateInternationalization(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().map(this::validateComponentResourceBundle).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Option.class).stream().map(Field::getType).filter(Class::isEnum).distinct().flatMap(enumType -> Stream.of(enumType.getFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())).filter(f -> {
            ResourceBundle bundle = Optional.ofNullable(this.findResourceBundle((Class<?>)enumType)).orElseGet(() -> this.findResourceBundle(f.getDeclaringClass()));
            String key = enumType.getSimpleName() + "." + f.getName() + "._displayName";
            return bundle == null || !bundle.containsKey(key);
        }).map(f -> "Missing key " + enumType.getSimpleName() + "." + f.getName() + "._displayName in " + enumType + " resource bundle")).sorted().collect(ComponentValidator.toSet()));
        for (Class i : finder.findAnnotatedClasses(Internationalized.class)) {
            ResourceBundle resourceBundle = this.findResourceBundle(i);
            if (resourceBundle != null) {
                Collection keys = Stream.of(i.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).map(m -> i.getName() + "." + m.getName()).sorted().collect(ComponentValidator.toSet());
                errors.addAll(keys.stream().filter(k -> !resourceBundle.containsKey((String)k)).map(k -> "Missing key " + k + " in " + i + " resource bundle").sorted().collect(ComponentValidator.toSet()));
                errors.addAll(resourceBundle.keySet().stream().filter(k -> k.startsWith(i.getName() + ".") && !keys.contains(k)).map(k -> "Key " + k + " from " + i + " is no more used").sorted().collect(ComponentValidator.toSet()));
                continue;
            }
            errors.add("No resource bundle for " + i);
        }
    }

    private void validateHttpClient(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(finder.findAnnotatedClasses(Request.class).stream().map(Class::getDeclaringClass).distinct().flatMap(c -> HttpClientFactoryImpl.createErrors((Class)c).stream()).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateModel(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().filter(c -> this.componentMarkers().filter(c::isAnnotationPresent).count() > 1L).map(i -> i + " has conflicting component annotations, ensure it has a single one").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(components.stream().filter(c -> this.countParameters(Constructors.findConstructor((Class)c).getParameters()) > 1).map(c -> "Component must use a single root option. '" + c.getName() + "'").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(components.stream().flatMap(c -> this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)c), Optional.ofNullable(c.getPackage()).map(Package::getName).orElse("")).stream()).filter(option -> this.hasNestedDataSet(option.getNestedParameters())).map(option -> "Root configuration can't contains a nested DataSet `" + option.getJavaType() + "`").sorted().collect(ComponentValidator.toSet()));
        ModelVisitor modelVisitor = new ModelVisitor();
        ModelListener noop = new ModelListener(){};
        errors.addAll(components.stream().map(c -> {
            try {
                modelVisitor.visit(c, noop, this.configuration.isValidateComponent());
                return null;
            }
            catch (RuntimeException re) {
                return re.getMessage();
            }
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Structure.class).stream().filter(f -> !ParameterizedType.class.isInstance(f.getGenericType()) || !this.isListString((Field)f) && !this.isMapString((Field)f)).map(f -> f.getDeclaringClass() + "#" + f.getName() + " uses @Structure but is not a List<String> nor a Map<String, String>").sorted().collect(ComponentValidator.toSet()));
    }

    private boolean isMapString(Field f) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(f.getGenericType());
        return Map.class == pt.getRawType() && pt.getActualTypeArguments().length == 2 && pt.getActualTypeArguments()[0] == String.class && pt.getActualTypeArguments()[1] == String.class;
    }

    private boolean isListString(Field f) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(f.getGenericType());
        return (List.class == pt.getRawType() || Collection.class == pt.getRawType()) && pt.getActualTypeArguments().length == 1 && pt.getActualTypeArguments()[0] == String.class;
    }

    private void validateMetadata(List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().map(component -> {
            if (!component.isAnnotationPresent(Version.class) || !component.isAnnotationPresent(Icon.class)) {
                return "Component " + component + " should use @Icon and @Version";
            }
            return null;
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDataStore(AnnotationFinder finder, Set<String> errors) {
        List datastoreClasses = finder.findAnnotatedClasses(DataStore.class);
        List datastores = datastoreClasses.stream().map(d -> d.getAnnotation(DataStore.class).value()).collect(Collectors.toList());
        HashSet uniqueDatastores = new HashSet(datastores);
        if (datastores.size() != uniqueDatastores.size()) {
            errors.add("Duplicated DataStore found : " + datastores.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
        List checkableClasses = finder.findAnnotatedClasses(Checkable.class);
        errors.addAll(checkableClasses.stream().filter(d -> !d.isAnnotationPresent(DataStore.class)).map(c -> c.getName() + " has @Checkable but is not a @DataStore").sorted().collect(ComponentValidator.toSet()));
        Map<String, String> checkableDataStoresMap = checkableClasses.stream().filter(d -> d.isAnnotationPresent(DataStore.class)).collect(Collectors.toMap(d -> d.getAnnotation(DataStore.class).value(), d -> d.getAnnotation(Checkable.class).value()));
        Set healthchecks = finder.findAnnotatedMethods(HealthCheck.class).stream().filter(h -> h.getDeclaringClass().isAnnotationPresent(Service.class)).map(m -> m.getAnnotation(HealthCheck.class).value()).sorted().collect(ComponentValidator.toSet());
        errors.addAll(checkableDataStoresMap.entrySet().stream().filter(e -> !healthchecks.contains(e.getValue())).map(e -> "No @HealthCheck for dataStore: '" + (String)e.getKey() + "' with checkable: '" + (String)e.getValue() + "'").sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDataSet(AnnotationFinder finder, Set<String> errors) {
        List datasets = finder.findAnnotatedClasses(DataSet.class).stream().map(d -> d.getAnnotation(DataSet.class).value()).collect(Collectors.toList());
        HashSet uniqueDatasets = new HashSet(datasets);
        if (datasets.size() != uniqueDatasets.size()) {
            errors.add("Duplicated DataSet found : " + datasets.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
    }

    private void validateActions(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(Stream.of(AsyncValidation.class, DynamicValues.class, HealthCheck.class, DiscoverSchema.class, Suggestions.class).flatMap(action -> {
            Class returnedType = action.getAnnotation(ActionType.class).expectedReturnedType();
            List annotatedMethods = finder.findAnnotatedMethods(action);
            return Stream.concat(annotatedMethods.stream().filter(m -> !returnedType.isAssignableFrom(m.getReturnType())).map(m -> m + " doesn't return a " + returnedType + ", please fix it"), annotatedMethods.stream().filter(m -> !m.getDeclaringClass().isAnnotationPresent(Service.class) && !Modifier.isAbstract(m.getDeclaringClass().getModifiers())).map(m -> m + " is not declared into a service class"));
        }).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(DynamicValues.class).stream().filter(m -> this.countParameters((Method)m) != 0).map(m -> m + " should have no parameter").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(HealthCheck.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataStore.class)).map(m -> m + " should have its first parameter being a datastore (marked with @DataStore)").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(DiscoverSchema.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataSet.class)).map(m -> m + " should have its first parameter being a dataset (marked with @Config)").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Proposable.class).stream().filter(f -> f.getType().isEnum()).map(f -> f.toString() + " must not define @Proposable since it is an enum").sorted().collect(ComponentValidator.toSet()));
        Set proposables = finder.findAnnotatedFields(Proposable.class).stream().map(f -> f.getAnnotation(Proposable.class).value()).sorted().collect(ComponentValidator.toSet());
        Set dynamicValues = finder.findAnnotatedMethods(DynamicValues.class).stream().map(f -> f.getAnnotation(DynamicValues.class).value()).sorted().collect(ComponentValidator.toSet());
        proposables.removeAll(dynamicValues);
        errors.addAll(proposables.stream().map(p -> "No @DynamicValues(\"" + p + "\"), add a service with this method: @DynamicValues(\"" + p + "\") Values proposals();").sorted().collect(ComponentValidator.toSet()));
    }

    private int countParameters(Method m) {
        return this.countParameters(m.getParameters());
    }

    private int countParameters(Parameter[] params) {
        return (int)Stream.of(params).filter(p -> !this.parameterModelService.isService(p)).count();
    }

    private String validateComponentResourceBundle(Class<?> component) {
        String baseName = Optional.ofNullable(component.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.findResourceBundle(component);
        if (bundle == null) {
            return "No resource bundle for " + component.getName() + ", you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        String prefix = this.components(component).map(c -> this.findFamily((BaseTask.Component)c, component) + "." + c.name()).orElseThrow(() -> new IllegalStateException(component.getName()));
        Collection missingKeys = Stream.of("_displayName").map(n -> prefix + "." + n).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + missingKeys.stream().collect(Collectors.joining("\n"));
        }
        return null;
    }

    private boolean isSerializable(Class<?> aClass) {
        return Serializable.class.isAssignableFrom(aClass);
    }

    private static <T> Collector<T, ?, Set<T>> toSet() {
        return Collectors.toCollection(TreeSet::new);
    }

    public static class Configuration {
        private boolean validateFamily;
        private boolean validateSerializable;
        private boolean validateInternationalization;
        private boolean validateHttpClient;
        private boolean validateModel;
        private boolean validateMetadata;
        private boolean validateComponent;
        private boolean validateDataStore;
        private boolean validateDataSet;
        private boolean validateActions;
        private boolean validateDocumentation;
        private boolean validateLayout;
        private boolean validateOptionNames;

        public boolean isValidateFamily() {
            return this.validateFamily;
        }

        public boolean isValidateSerializable() {
            return this.validateSerializable;
        }

        public boolean isValidateInternationalization() {
            return this.validateInternationalization;
        }

        public boolean isValidateHttpClient() {
            return this.validateHttpClient;
        }

        public boolean isValidateModel() {
            return this.validateModel;
        }

        public boolean isValidateMetadata() {
            return this.validateMetadata;
        }

        public boolean isValidateComponent() {
            return this.validateComponent;
        }

        public boolean isValidateDataStore() {
            return this.validateDataStore;
        }

        public boolean isValidateDataSet() {
            return this.validateDataSet;
        }

        public boolean isValidateActions() {
            return this.validateActions;
        }

        public boolean isValidateDocumentation() {
            return this.validateDocumentation;
        }

        public boolean isValidateLayout() {
            return this.validateLayout;
        }

        public boolean isValidateOptionNames() {
            return this.validateOptionNames;
        }

        public void setValidateFamily(boolean validateFamily) {
            this.validateFamily = validateFamily;
        }

        public void setValidateSerializable(boolean validateSerializable) {
            this.validateSerializable = validateSerializable;
        }

        public void setValidateInternationalization(boolean validateInternationalization) {
            this.validateInternationalization = validateInternationalization;
        }

        public void setValidateHttpClient(boolean validateHttpClient) {
            this.validateHttpClient = validateHttpClient;
        }

        public void setValidateModel(boolean validateModel) {
            this.validateModel = validateModel;
        }

        public void setValidateMetadata(boolean validateMetadata) {
            this.validateMetadata = validateMetadata;
        }

        public void setValidateComponent(boolean validateComponent) {
            this.validateComponent = validateComponent;
        }

        public void setValidateDataStore(boolean validateDataStore) {
            this.validateDataStore = validateDataStore;
        }

        public void setValidateDataSet(boolean validateDataSet) {
            this.validateDataSet = validateDataSet;
        }

        public void setValidateActions(boolean validateActions) {
            this.validateActions = validateActions;
        }

        public void setValidateDocumentation(boolean validateDocumentation) {
            this.validateDocumentation = validateDocumentation;
        }

        public void setValidateLayout(boolean validateLayout) {
            this.validateLayout = validateLayout;
        }

        public void setValidateOptionNames(boolean validateOptionNames) {
            this.validateOptionNames = validateOptionNames;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isValidateFamily() != other.isValidateFamily()) {
                return false;
            }
            if (this.isValidateSerializable() != other.isValidateSerializable()) {
                return false;
            }
            if (this.isValidateInternationalization() != other.isValidateInternationalization()) {
                return false;
            }
            if (this.isValidateHttpClient() != other.isValidateHttpClient()) {
                return false;
            }
            if (this.isValidateModel() != other.isValidateModel()) {
                return false;
            }
            if (this.isValidateMetadata() != other.isValidateMetadata()) {
                return false;
            }
            if (this.isValidateComponent() != other.isValidateComponent()) {
                return false;
            }
            if (this.isValidateDataStore() != other.isValidateDataStore()) {
                return false;
            }
            if (this.isValidateDataSet() != other.isValidateDataSet()) {
                return false;
            }
            if (this.isValidateActions() != other.isValidateActions()) {
                return false;
            }
            if (this.isValidateDocumentation() != other.isValidateDocumentation()) {
                return false;
            }
            if (this.isValidateLayout() != other.isValidateLayout()) {
                return false;
            }
            return this.isValidateOptionNames() == other.isValidateOptionNames();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValidateFamily() ? 79 : 97);
            result = result * 59 + (this.isValidateSerializable() ? 79 : 97);
            result = result * 59 + (this.isValidateInternationalization() ? 79 : 97);
            result = result * 59 + (this.isValidateHttpClient() ? 79 : 97);
            result = result * 59 + (this.isValidateModel() ? 79 : 97);
            result = result * 59 + (this.isValidateMetadata() ? 79 : 97);
            result = result * 59 + (this.isValidateComponent() ? 79 : 97);
            result = result * 59 + (this.isValidateDataStore() ? 79 : 97);
            result = result * 59 + (this.isValidateDataSet() ? 79 : 97);
            result = result * 59 + (this.isValidateActions() ? 79 : 97);
            result = result * 59 + (this.isValidateDocumentation() ? 79 : 97);
            result = result * 59 + (this.isValidateLayout() ? 79 : 97);
            result = result * 59 + (this.isValidateOptionNames() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ComponentValidator.Configuration(validateFamily=" + this.isValidateFamily() + ", validateSerializable=" + this.isValidateSerializable() + ", validateInternationalization=" + this.isValidateInternationalization() + ", validateHttpClient=" + this.isValidateHttpClient() + ", validateModel=" + this.isValidateModel() + ", validateMetadata=" + this.isValidateMetadata() + ", validateComponent=" + this.isValidateComponent() + ", validateDataStore=" + this.isValidateDataStore() + ", validateDataSet=" + this.isValidateDataSet() + ", validateActions=" + this.isValidateActions() + ", validateDocumentation=" + this.isValidateDocumentation() + ", validateLayout=" + this.isValidateLayout() + ", validateOptionNames=" + this.isValidateOptionNames() + ")";
        }
    }
}

