/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnCoordinateToFileConverter;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class StudioInstaller
implements Runnable {
    private final String mainGav;
    private final File studioHome;
    private final Map<String, File> artifacts;
    private final Log log;
    private final boolean enforceDeployment;
    private final File m2;

    public StudioInstaller(String mainGav, File studioHome, Map<String, File> artifacts, Object log, boolean enforceDeployment, File m2) {
        this.mainGav = mainGav;
        this.studioHome = studioHome;
        this.artifacts = artifacts;
        this.m2 = m2;
        this.enforceDeployment = enforceDeployment;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void run() {
        Throwable throwable;
        FileWriter writer;
        String repoType;
        File osgiCache;
        this.log.info("Installing development version of " + this.mainGav + " in " + this.studioHome);
        List artifacts = this.artifacts.values().stream().map(File::getName).collect(Collectors.toList());
        String[] mvnMeta = this.mainGav.split(":");
        String artifact = mvnMeta[1];
        String version = mvnMeta[2];
        File configIni = new File(this.studioHome, "configuration/config.ini");
        Properties config = new Properties();
        if (configIni.exists()) {
            try (FileInputStream is = new FileInputStream(configIni);){
                config.load(is);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        String registry = config.getProperty("component.java.registry", config.getProperty("talend.component.server.component.registry"));
        if (!this.enforceDeployment && registry != null && new File(registry).exists()) {
            Properties components = new Properties();
            try (FileReader reader = new FileReader(registry);){
                String installedVersion;
                components.load(reader);
                if (components.containsKey(artifact) && !version.equals(installedVersion = components.getProperty(artifact).split(":")[2])) {
                    throw new IllegalStateException("Can't deploy this component. A different version '" + installedVersion + "' is already installed.\nYou can enforce the deployment by using -Dtalend.component.enforceDeploy=true");
                }
            }
            catch (IOException e) {
                this.log.error("Can't load registered component from the studio " + e.getMessage());
            }
        }
        if ((osgiCache = new File(this.studioHome, "configuration/org.eclipse.osgi")).isDirectory()) {
            Optional.ofNullable(osgiCache.listFiles(child -> {
                try {
                    return child.isDirectory() && Integer.parseInt(child.getName()) > 0;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            })).map(Stream::of).orElseGet(Stream::empty).map(id -> new File((File)id, ".cp")).filter(File::exists).flatMap(cp -> Optional.ofNullable(cp.listFiles((dir, name) -> name.endsWith(".jar"))).map(Stream::of).orElseGet(Stream::empty)).filter(jar -> artifacts.contains(jar.getName())).forEach(this::tryDelete);
        }
        if (!"global".equals(repoType = config.getProperty("maven.repository"))) {
            MvnCoordinateToFileConverter converter = new MvnCoordinateToFileConverter();
            this.artifacts.forEach((gav, file) -> {
                Artifact dependency = converter.toArtifact(gav);
                File target = this.m2 == null || !this.m2.exists() ? new File(this.studioHome, "configuration/.m2/repository/" + dependency.toPath()) : new File(this.m2, dependency.toPath());
                try {
                    if (target.exists() && !dependency.getVersion().endsWith("-SNAPSHOT")) {
                        this.log.info(gav + " already exists, skipping");
                        return;
                    }
                    this.copy((File)file, target);
                    this.log.info("Installed " + gav + " at " + target.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        } else {
            this.log.info("Studio " + this.studioHome + " configured to use global maven repository, skipping artifact installation");
        }
        if (registry == null) {
            File registryLocation = new File(configIni.getParentFile(), "components-registration.properties");
            registryLocation.getParentFile().mkdirs();
            registry = registryLocation.getAbsolutePath().replace('\\', '/');
            config.setProperty("component.java.registry", registry);
            try {
                File backup = new File(configIni.getParentFile(), "backup/" + configIni.getName() + "_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-mm-dd_HH-mm-ss")));
                this.log.info("Saving configuration in " + backup);
                this.copy(configIni, backup);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            try {
                writer = new FileWriter(configIni);
                throwable = null;
                try {
                    config.store(writer, "File rewritten by " + this.getClass().getName() + " utility to add component.java.registry entry");
                    this.log.info("Updated " + configIni + " to add the component registry entry");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            try {
                Files.write(registryLocation.toPath(), new byte[0], StandardOpenOption.CREATE_NEW);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Properties components = new Properties();
        try {
            throwable = null;
            try (FileReader reader = new FileReader(registry);){
                components.load(reader);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!components.containsKey(artifact) || this.enforceDeployment) {
            components.setProperty(artifact, this.mainGav);
            try {
                writer = new FileWriter(registry);
                throwable = null;
                try {
                    components.store(writer, "File rewritten to add " + this.mainGav);
                    this.log.info("Updated " + registry + " with '" + this.mainGav + "'");
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (writer != null) {
                        if (throwable != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void copy(File source, File target) throws IOException {
        this.mkdirP(target.getParentFile());
        try (BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(target));){
            Files.copy(source.toPath(), to);
        }
    }

    private void mkdirP(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Can't create " + dir);
        }
    }

    private void tryDelete(File jar) {
        if (!jar.delete()) {
            this.log.error("Can't delete " + jar.getAbsolutePath());
        } else {
            this.log.info("Deleting " + jar.getAbsolutePath());
        }
    }
}

