/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.internationalization.ParameterBundle;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConditionParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.ConfigurationTypeParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.DocumentationParameterEnricher;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.UiParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.util.DefaultValueInspector;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.ComponentHelper;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public abstract class DocBaseGenerator
extends BaseTask {
    private final DefaultValueInspector defaultValueInspector = new DefaultValueInspector();
    private final Locale locale;
    private final AbsolutePathResolver resolver = new AbsolutePathResolver();
    protected final Log log;
    protected final File output;
    private final ParameterModelService parameterModelService = new ParameterModelService(Arrays.asList(new DocumentationParameterEnricher(), new ConditionParameterEnricher(), new ConfigurationTypeParameterEnricher(), new UiParameterEnricher()), (PropertyEditorRegistry)new EnrichedPropertyEditorRegistry()){};

    DocBaseGenerator(File[] classes, Locale locale, Object log, File output) {
        super(classes);
        this.locale = locale;
        this.output = output;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final void run() {
        boolean shouldSwitchLocale;
        Locale oldLocale = Locale.getDefault();
        boolean bl = shouldSwitchLocale = oldLocale != Locale.ROOT && !Optional.ofNullable(oldLocale.getLanguage()).orElse("").equals("en");
        if (shouldSwitchLocale) {
            Locale.setDefault(Locale.ROOT);
        }
        try {
            this.doRun();
        }
        finally {
            if (shouldSwitchLocale) {
                Locale.setDefault(oldLocale);
            }
        }
    }

    protected abstract void doRun();

    protected Stream<ComponentDescription> components() {
        AnnotationFinder finder = this.newFinder();
        return this.findComponents(finder).map(component -> {
            List parameterMetas = this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)component), Optional.ofNullable(component.getPackage()).map(Package::getName).orElse(""), new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools")));
            ComponentHelper.Component componentMeta = ComponentHelper.componentMarkers().filter(component::isAnnotationPresent).map(component::getAnnotation).map(ComponentHelper::asComponent).findFirst().orElseThrow(NoSuchElementException::new);
            String family = "";
            try {
                family = ComponentHelper.findFamily(componentMeta, component);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return new ComponentDescription((Class)component, family, componentMeta.name(), this.getDoc((Class<?>)component), this.sort(parameterMetas), this.resolver, this.defaultValueInspector, this.locale, this.emptyDefaultValue());
        });
    }

    protected Stream<Class<?>> findComponents(AnnotationFinder finder) {
        return ComponentHelper.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream());
    }

    private String getDoc(Class<?> component) {
        Collection docKeys = Stream.of(this.getComponentPrefix(component), component.getSimpleName()).map(it -> it + "._documentation").collect(Collectors.toList());
        return Optional.ofNullable(this.findResourceBundle(component)).map(bundle -> docKeys.stream().filter(bundle::containsKey).map(bundle::getString).findFirst().map(v -> v + "\n\n").orElse(null)).orElseGet(() -> Optional.ofNullable(component.getAnnotation(Documentation.class)).map(Documentation::value).map(v -> v + "\n\n").orElse(""));
    }

    private String getComponentPrefix(Class<?> component) {
        try {
            return ComponentHelper.components(component).map(c -> ComponentHelper.findFamily(c, component) + "." + c.name()).orElseGet(component::getSimpleName);
        }
        catch (RuntimeException e) {
            return component.getSimpleName();
        }
    }

    private Collection<ParameterMeta> sort(Collection<ParameterMeta> parameterMetas) {
        return parameterMetas.stream().sorted(Comparator.comparing(ParameterMeta::getPath)).collect(Collectors.toList());
    }

    protected void write(File output, String content) {
        this.ensureParentExists(output);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void ensureParentExists(File output) {
        if (!output.getParentFile().isDirectory() && !output.getParentFile().mkdirs()) {
            throw new IllegalStateException("Can't create " + output.getParentFile());
        }
    }

    protected String emptyDefaultValue() {
        return "-";
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    protected static class ComponentDescription {
        private final Class<?> type;
        private final String family;
        private final String name;
        private final String documentation;
        private final Collection<ParameterMeta> parameters;
        private final AbsolutePathResolver resolver;
        private final DefaultValueInspector defaultValueInspector;
        private final Locale locale;
        private final String emptyDefaultValue;

        private Map<String, UIInfo> getUIParamByPath(Collection<ParameterMeta> parameters) {
            HashMap<String, UIInfo> uiparams = new HashMap<String, UIInfo>();
            this.recurseUIParam(parameters, uiparams, "", null, null);
            return uiparams;
        }

        private Set<String> recurseUIParam(Collection<ParameterMeta> params, Map<String, UIInfo> uiparams, String currentSectionName, ParameterMeta parent, Collection<String> parentLayouts) {
            HashSet<String> layouts = new HashSet<String>();
            for (ParameterMeta param : params) {
                String path = param.getPath();
                String sectionType = (String)param.getMetadata().get("tcomp::configurationtype::type");
                if (sectionType == null) {
                    sectionType = currentSectionName;
                }
                Collection<String> paramLayouts = this.getPropertiesByLayout(parent, param.getName(), parentLayouts);
                layouts.addAll(paramLayouts);
                UIInfo uiInfo = new UIInfo(currentSectionName, paramLayouts);
                uiparams.put(path, uiInfo);
                if (param.getNestedParameters().size() <= 0) continue;
                Set<String> set = this.recurseUIParam(param.getNestedParameters(), uiparams, sectionType, param, paramLayouts);
            }
            return layouts;
        }

        private Collection<String> getPropertiesByLayout(ParameterMeta parent, String param, Collection<String> parentLayouts) {
            TreeSet<String> layouts = new TreeSet<String>();
            if (parent == null) {
                return Arrays.asList("tcomp::ui::gridlayout::Main::value", "tcomp::ui::gridlayout::Advanced::value");
            }
            Collection definedLayouts = parent.getMetadata().keySet().stream().filter(k -> k.startsWith("tcomp::ui::gridlayout::")).collect(Collectors.toList());
            if (definedLayouts.isEmpty() && parentLayouts.contains("tcomp::ui::gridlayout::Main::value")) {
                return Arrays.asList("tcomp::ui::gridlayout::Main::value");
            }
            definedLayouts.stream().filter(l -> parentLayouts.contains(l)).forEach(k -> {
                boolean isInThisLayout;
                String layoutConfig = (String)parent.getMetadata().get(k);
                if (layoutConfig != null && (isInThisLayout = Collections.list(new StringTokenizer(layoutConfig, "|")).stream().flatMap(p -> Collections.list(new StringTokenizer(p.toString(), ",")).stream()).collect(Collectors.toList()).contains(param))) {
                    layouts.add((String)k);
                }
            });
            return layouts;
        }

        Map<String, Map<String, List<Param>>> getParametersWithUInfo() {
            HashMap<String, Map<String, List<Param>>> params = new HashMap<String, Map<String, List<Param>>>();
            Map<String, UIInfo> uiInfos = this.getUIParamByPath(this.parameters);
            for (Param p : this.toParams()) {
                this.setParametersWithUInfoRecurs(p, uiInfos, params);
            }
            return params;
        }

        void setParametersWithUInfoRecurs(Param p, Map<String, UIInfo> uiInfos, Map<String, Map<String, List<Param>>> params) {
            UIInfo info = uiInfos.get(p.fullPath);
            p.setUiInfo(info);
            Map<String, List<Param>> section = params.get(info.getSection());
            if (section == null) {
                section = new HashMap<String, List<Param>>();
                params.put(info.getSection(), section);
            }
            for (String l : info.getNestedLayout()) {
                List<Param> layout = section.get(l);
                if (layout == null) {
                    layout = new ArrayList<Param>();
                    section.put(l, layout);
                }
                layout.add(p);
            }
            for (Param n : p.getNested()) {
                this.setParametersWithUInfoRecurs(n, uiInfos, params);
            }
        }

        private Collection<Param> toParams() {
            ArrayList<Param> params = new ArrayList<Param>();
            for (ParameterMeta p : this.parameters) {
                Param tp = this.toParamWithNested(p, null, null, new HashMap<String, String>());
                params.add(tp);
            }
            return params;
        }

        Stream<Param> parameters() {
            return this.mapParameters(this.parameters, null, null, new HashMap<String, String>());
        }

        private Stream<Param> mapParameters(Collection<ParameterMeta> parameterMetas, DefaultValueInspector.Instance parentInstance, ParameterBundle parentBundle, Map<String, String> types) {
            return parameterMetas.stream().flatMap(p -> {
                DefaultValueInspector.Instance instance = this.defaultValueInspector.createDemoInstance(Optional.ofNullable(parentInstance).map(DefaultValueInspector.Instance::getValue).orElse(null), p);
                return Stream.concat(Stream.of(this.toParam((ParameterMeta)p, instance, parentBundle, types)), this.mapParameters(p.getNestedParameters(), instance, this.findBundle((ParameterMeta)p), types));
            });
        }

        private Param toParamWithNested(ParameterMeta p, DefaultValueInspector.Instance parentInstance, ParameterBundle parent, Map<String, String> types) {
            ParameterBundle bundle = this.findBundle(p);
            String type = this.findEnclosingConfigurationType(p, types);
            DefaultValueInspector.Instance instance = this.defaultValueInspector.createDemoInstance(Optional.ofNullable(parentInstance).map(DefaultValueInspector.Instance::getValue).orElse(null), p);
            Param param = new Param(bundle.displayName(parent).orElse(p.getName()), bundle.documentation(parent).orElseGet(() -> this.findDocumentation(p)), Optional.ofNullable(this.findDefault(p, instance)).orElse(this.emptyDefaultValue), Optional.ofNullable(type).orElse("-"), p.getPath(), this.createConditions(p.getPath(), p.getMetadata()), (String)p.getMetadata().get("tcomp::configurationtype::type"));
            for (ParameterMeta child : p.getNestedParameters()) {
                Param np = this.toParamWithNested(child, instance, bundle, types);
                param.addNested(np);
            }
            return param;
        }

        private Param toParam(ParameterMeta p, DefaultValueInspector.Instance instance, ParameterBundle parent, Map<String, String> types) {
            ParameterBundle bundle = this.findBundle(p);
            String type = this.findEnclosingConfigurationType(p, types);
            return new Param(bundle.displayName(parent).orElse(p.getName()), bundle.documentation(parent).orElseGet(() -> this.findDocumentation(p)), Optional.ofNullable(this.findDefault(p, instance)).orElse(this.emptyDefaultValue), Optional.ofNullable(type).orElse("-"), p.getPath(), this.createConditions(p.getPath(), p.getMetadata()), "Not computed");
        }

        private ParameterBundle findBundle(ParameterMeta p) {
            return p.findBundle(Thread.currentThread().getContextClassLoader(), this.locale);
        }

        private String findEnclosingConfigurationType(ParameterMeta p, Map<String, String> types) {
            String type = (String)p.getMetadata().get("tcomp::configurationtype::type");
            if (type != null) {
                types.put(p.getPath(), type);
            } else {
                int sep;
                String currentPath = p.getPath();
                while (type == null && (sep = currentPath.lastIndexOf(46)) >= 0) {
                    currentPath = currentPath.substring(0, sep);
                    type = types.get(currentPath);
                }
            }
            return type;
        }

        private String findDefault(ParameterMeta p, DefaultValueInspector.Instance instance) {
            String defVal = (String)p.getMetadata().get("tcomp::ui::defaultvalue::value");
            if (defVal != null) {
                return defVal;
            }
            if (instance == null || instance.getValue() == null || instance.isCreated()) {
                return null;
            }
            switch (p.getType()) {
                case NUMBER: 
                case BOOLEAN: 
                case STRING: 
                case ENUM: {
                    return Optional.ofNullable(instance.getValue()).map(String::valueOf).map(it -> it.isEmpty() ? "<empty>" : it).orElse(null);
                }
                case ARRAY: {
                    return String.valueOf(Collection.class.isInstance(instance.getValue()) ? ((Collection)Collection.class.cast(instance.getValue())).size() : Array.getLength(instance.getValue()));
                }
            }
            return null;
        }

        private Conditions createConditions(String path, Map<String, String> metadata) {
            String globalOperator = metadata.getOrDefault("tcomp::condition::ifs::operator", "AND");
            Collection conditionEntries = metadata.keySet().stream().filter(it -> it.startsWith("tcomp::condition::if::target")).map(it -> {
                String target = (String)metadata.get(it);
                return new Condition(target, this.resolver.doResolveProperty(path, target), (String)metadata.get(it.replace("::target", "::value")), Boolean.parseBoolean((String)metadata.get(it.replace("::target", "::negate"))), (String)metadata.get(it.replace("::target", "::evaluationStrategy")));
            }).collect(Collectors.toList());
            return new Conditions(path, globalOperator, conditionEntries);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String findDocumentation(ParameterMeta p) {
            String inline = (String)p.getMetadata().get("tcomp::documentation::value");
            if (inline == null) return p.getName() + " configuration";
            if (!inline.startsWith("resource:")) return inline;
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(inline.substring("resource:".length()));
            if (stream == null) throw new IllegalArgumentException("No resource: '" + inline + "'");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String string = reader.lines().collect(Collectors.joining("\n"));
                return string;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Bad resource: '" + inline + "'", e);
            }
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getFamily() {
            return this.family;
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public Collection<ParameterMeta> getParameters() {
            return this.parameters;
        }

        public AbsolutePathResolver getResolver() {
            return this.resolver;
        }

        public DefaultValueInspector getDefaultValueInspector() {
            return this.defaultValueInspector;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getEmptyDefaultValue() {
            return this.emptyDefaultValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentDescription)) {
                return false;
            }
            ComponentDescription other = (ComponentDescription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$family = this.getFamily();
            String other$family = other.getFamily();
            if (this$family == null ? other$family != null : !this$family.equals(other$family)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$documentation = this.getDocumentation();
            String other$documentation = other.getDocumentation();
            if (this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation)) {
                return false;
            }
            Collection<ParameterMeta> this$parameters = this.getParameters();
            Collection<ParameterMeta> other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
                return false;
            }
            AbsolutePathResolver this$resolver = this.getResolver();
            AbsolutePathResolver other$resolver = other.getResolver();
            if (this$resolver == null ? other$resolver != null : !this$resolver.equals(other$resolver)) {
                return false;
            }
            DefaultValueInspector this$defaultValueInspector = this.getDefaultValueInspector();
            DefaultValueInspector other$defaultValueInspector = other.getDefaultValueInspector();
            if (this$defaultValueInspector == null ? other$defaultValueInspector != null : !this$defaultValueInspector.equals(other$defaultValueInspector)) {
                return false;
            }
            Locale this$locale = this.getLocale();
            Locale other$locale = other.getLocale();
            if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
                return false;
            }
            String this$emptyDefaultValue = this.getEmptyDefaultValue();
            String other$emptyDefaultValue = other.getEmptyDefaultValue();
            return !(this$emptyDefaultValue == null ? other$emptyDefaultValue != null : !this$emptyDefaultValue.equals(other$emptyDefaultValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComponentDescription;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $family = this.getFamily();
            result = result * 59 + ($family == null ? 43 : $family.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $documentation = this.getDocumentation();
            result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
            Collection<ParameterMeta> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            AbsolutePathResolver $resolver = this.getResolver();
            result = result * 59 + ($resolver == null ? 43 : $resolver.hashCode());
            DefaultValueInspector $defaultValueInspector = this.getDefaultValueInspector();
            result = result * 59 + ($defaultValueInspector == null ? 43 : $defaultValueInspector.hashCode());
            Locale $locale = this.getLocale();
            result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
            String $emptyDefaultValue = this.getEmptyDefaultValue();
            result = result * 59 + ($emptyDefaultValue == null ? 43 : $emptyDefaultValue.hashCode());
            return result;
        }

        public String toString() {
            return "DocBaseGenerator.ComponentDescription(type=" + this.getType() + ", family=" + this.getFamily() + ", name=" + this.getName() + ", documentation=" + this.getDocumentation() + ", parameters=" + this.getParameters() + ", resolver=" + this.getResolver() + ", defaultValueInspector=" + this.getDefaultValueInspector() + ", locale=" + this.getLocale() + ", emptyDefaultValue=" + this.getEmptyDefaultValue() + ")";
        }

        private ComponentDescription(Class<?> type, String family, String name, String documentation, Collection<ParameterMeta> parameters, AbsolutePathResolver resolver, DefaultValueInspector defaultValueInspector, Locale locale, String emptyDefaultValue) {
            this.type = type;
            this.family = family;
            this.name = name;
            this.documentation = documentation;
            this.parameters = parameters;
            this.resolver = resolver;
            this.defaultValueInspector = defaultValueInspector;
            this.locale = locale;
            this.emptyDefaultValue = emptyDefaultValue;
        }
    }

    public static class Conditions {
        private final String path;
        private final String operator;
        private final Collection<Condition> conditions;

        public String getPath() {
            return this.path;
        }

        public String getOperator() {
            return this.operator;
        }

        public Collection<Condition> getConditions() {
            return this.conditions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conditions)) {
                return false;
            }
            Conditions other = (Conditions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            Collection<Condition> this$conditions = this.getConditions();
            Collection<Condition> other$conditions = other.getConditions();
            return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conditions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            Collection<Condition> $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
            return result;
        }

        public String toString() {
            return "DocBaseGenerator.Conditions(path=" + this.getPath() + ", operator=" + this.getOperator() + ", conditions=" + this.getConditions() + ")";
        }

        private Conditions(String path, String operator, Collection<Condition> conditions) {
            this.path = path;
            this.operator = operator;
            this.conditions = conditions;
        }
    }

    protected static class Param
    implements Comparable<Param> {
        private final String displayName;
        private final String documentation;
        private final String defaultValue;
        private final String type;
        private final String fullPath;
        private final Conditions conditions;
        private final String section;
        private UIInfo uiInfo;
        private final SortedSet<Param> nested = new TreeSet<Param>();

        public void addNested(Param p) {
            this.nested.add(p);
        }

        @Override
        public int compareTo(Param p) {
            return this.getDisplayName().compareTo(p.getDisplayName());
        }

        public boolean isComplex() {
            return this.nested.size() > 0;
        }

        public boolean isSection() {
            return this.isComplex() && this.section != null && !this.section.isEmpty();
        }

        public String getSectionName() {
            return "datastore".equals(this.section) ? "connection" : this.section;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getType() {
            return this.type;
        }

        public String getFullPath() {
            return this.fullPath;
        }

        public Conditions getConditions() {
            return this.conditions;
        }

        public String getSection() {
            return this.section;
        }

        public UIInfo getUiInfo() {
            return this.uiInfo;
        }

        public SortedSet<Param> getNested() {
            return this.nested;
        }

        public void setUiInfo(UIInfo uiInfo) {
            this.uiInfo = uiInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Param)) {
                return false;
            }
            Param other = (Param)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$documentation = this.getDocumentation();
            String other$documentation = other.getDocumentation();
            if (this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$fullPath = this.getFullPath();
            String other$fullPath = other.getFullPath();
            if (this$fullPath == null ? other$fullPath != null : !this$fullPath.equals(other$fullPath)) {
                return false;
            }
            Conditions this$conditions = this.getConditions();
            Conditions other$conditions = other.getConditions();
            if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
                return false;
            }
            String this$section = this.getSection();
            String other$section = other.getSection();
            if (this$section == null ? other$section != null : !this$section.equals(other$section)) {
                return false;
            }
            UIInfo this$uiInfo = this.getUiInfo();
            UIInfo other$uiInfo = other.getUiInfo();
            if (this$uiInfo == null ? other$uiInfo != null : !((Object)this$uiInfo).equals(other$uiInfo)) {
                return false;
            }
            SortedSet<Param> this$nested = this.getNested();
            SortedSet<Param> other$nested = other.getNested();
            return !(this$nested == null ? other$nested != null : !this$nested.equals(other$nested));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Param;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $documentation = this.getDocumentation();
            result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $fullPath = this.getFullPath();
            result = result * 59 + ($fullPath == null ? 43 : $fullPath.hashCode());
            Conditions $conditions = this.getConditions();
            result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
            String $section = this.getSection();
            result = result * 59 + ($section == null ? 43 : $section.hashCode());
            UIInfo $uiInfo = this.getUiInfo();
            result = result * 59 + ($uiInfo == null ? 43 : ((Object)$uiInfo).hashCode());
            SortedSet<Param> $nested = this.getNested();
            result = result * 59 + ($nested == null ? 43 : $nested.hashCode());
            return result;
        }

        public String toString() {
            return "DocBaseGenerator.Param(displayName=" + this.getDisplayName() + ", documentation=" + this.getDocumentation() + ", defaultValue=" + this.getDefaultValue() + ", type=" + this.getType() + ", fullPath=" + this.getFullPath() + ", conditions=" + this.getConditions() + ", section=" + this.getSection() + ", uiInfo=" + this.getUiInfo() + ", nested=" + this.getNested() + ")";
        }

        private Param(String displayName, String documentation, String defaultValue, String type, String fullPath, Conditions conditions, String section) {
            this.displayName = displayName;
            this.documentation = documentation;
            this.defaultValue = defaultValue;
            this.type = type;
            this.fullPath = fullPath;
            this.conditions = conditions;
            this.section = section;
        }
    }

    protected static class UIInfo {
        private final String section;
        private final Set<String> nestedLayout = new HashSet<String>();

        public UIInfo(String section, Collection<String> layouts) {
            this.section = section;
            this.nestedLayout.addAll(layouts);
        }

        public void addNestedLayouts(Collection<String> layouts) {
            this.nestedLayout.addAll(layouts);
        }

        public String getSection() {
            return this.section;
        }

        public Set<String> getNestedLayout() {
            return this.nestedLayout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UIInfo)) {
                return false;
            }
            UIInfo other = (UIInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$section = this.getSection();
            String other$section = other.getSection();
            if (this$section == null ? other$section != null : !this$section.equals(other$section)) {
                return false;
            }
            Set<String> this$nestedLayout = this.getNestedLayout();
            Set<String> other$nestedLayout = other.getNestedLayout();
            return !(this$nestedLayout == null ? other$nestedLayout != null : !((Object)this$nestedLayout).equals(other$nestedLayout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UIInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $section = this.getSection();
            result = result * 59 + ($section == null ? 43 : $section.hashCode());
            Set<String> $nestedLayout = this.getNestedLayout();
            result = result * 59 + ($nestedLayout == null ? 43 : ((Object)$nestedLayout).hashCode());
            return result;
        }

        public String toString() {
            return "DocBaseGenerator.UIInfo(section=" + this.getSection() + ", nestedLayout=" + this.getNestedLayout() + ")";
        }
    }

    protected static class Condition {
        private final String target;
        private final String path;
        private final String value;
        private final boolean negate;
        private final String strategy;

        public String getTarget() {
            return this.target;
        }

        public String getPath() {
            return this.path;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Condition)) {
                return false;
            }
            Condition other = (Condition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            if (this.isNegate() != other.isNegate()) {
                return false;
            }
            String this$strategy = this.getStrategy();
            String other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Condition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            result = result * 59 + (this.isNegate() ? 79 : 97);
            String $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
            return result;
        }

        public String toString() {
            return "DocBaseGenerator.Condition(target=" + this.getTarget() + ", path=" + this.getPath() + ", value=" + this.getValue() + ", negate=" + this.isNegate() + ", strategy=" + this.getStrategy() + ")";
        }

        private Condition(String target, String path, String value, boolean negate, String strategy) {
            this.target = target;
            this.path = path;
            this.value = value;
            this.negate = negate;
            this.strategy = strategy;
        }
    }

    private static class AbsolutePathResolver {
        private AbsolutePathResolver() {
        }

        public String resolveProperty(String propPath, String paramRef) {
            return this.doResolveProperty(propPath, this.normalizeParamRef(paramRef));
        }

        private String normalizeParamRef(String paramRef) {
            return (!paramRef.contains(".") ? "../" : "") + paramRef;
        }

        private String doResolveProperty(String propPath, String paramRef) {
            if (".".equals(paramRef)) {
                return propPath;
            }
            if (paramRef.startsWith("..")) {
                String current = propPath;
                String ref = paramRef;
                while (ref.startsWith("..")) {
                    int lastDot = current.lastIndexOf(46);
                    if (lastDot < 0) {
                        lastDot = 0;
                    }
                    current = current.substring(0, lastDot);
                    if ((ref = ref.substring("..".length(), ref.length())).startsWith("/")) {
                        ref = ref.substring(1);
                    }
                    if (!current.isEmpty()) continue;
                    break;
                }
                return Stream.of(current, ref.replace('/', '.')).filter(it -> !it.isEmpty()).collect(Collectors.joining("."));
            }
            if (paramRef.startsWith(".") || paramRef.startsWith("./")) {
                return propPath + '.' + paramRef.replaceFirst("\\./?", "").replace('/', '.');
            }
            return paramRef;
        }
    }
}

