/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class SVG2Png
implements Runnable {
    private final Path iconsFolder;
    private final Log log;
    private final boolean activeWorkarounds;

    public SVG2Png(Path iconsFolder, boolean activeWorkarounds, Object log) {
        this.iconsFolder = iconsFolder;
        this.activeWorkarounds = activeWorkarounds;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        try {
            Files.walkFileTree(this.iconsFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path svg;
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(".svg") && !Files.exists(svg = file.getParent().resolve(fileName.substring(0, fileName.length() - ".svg".length()) + "_icon32.png"), new LinkOption[0])) {
                        SVG2Png.this.createPng(file, svg);
                        SVG2Png.this.log.info("Created " + svg);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void createPng(Path svg, Path png) {
        PNGTranscoder transcoder = new PNGTranscoder(){

            public void writeImage(BufferedImage img, TranscoderOutput output) throws TranscoderException {
                if (SVG2Png.this.activeWorkarounds) {
                    this.ensureAlphaDiff(img);
                }
                super.writeImage(img, output);
            }

            private void ensureAlphaDiff(BufferedImage img) {
                for (int x = 1; x < img.getWidth() - 1; ++x) {
                    for (int y = 1; y < img.getHeight() - 1; ++y) {
                        Color color = new Color(img.getRGB(x, y), true);
                        if (color.getAlpha() != 0) continue;
                        img.setRGB(x, y, new Color(255, 255, 255, color.getAlpha()).getRGB());
                    }
                }
            }
        };
        transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(32.0f));
        transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(32.0f));
        try (InputStream in = Files.newInputStream(svg, new OpenOption[0]);
             OutputStream out = Files.newOutputStream(png, new OpenOption[0]);){
            transcoder.transcode(new TranscoderInput(in), new TranscoderOutput(out));
        }
        catch (IOException | TranscoderException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

